/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import java.util.Arrays;
import org.broadinstitute.sting.gatk.walkers.phasing.BaseArray;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class Haplotype
extends BaseArray
implements Cloneable {
    public Haplotype(byte[] bases) {
        super(bases);
    }

    private Haplotype(Byte[] bases) {
        super(bases);
    }

    public Haplotype(Haplotype other) {
        super(other);
    }

    public Haplotype(BaseArray baseArr) {
        super(baseArr.bases);
        if (baseArr.getNonNullIndices().length != baseArr.bases.length) {
            throw new ReviewedStingException("Should NEVER call Haplotype ctor with null bases!");
        }
    }

    @Override
    public void updateBase(int index, Byte base) {
        if (base == null) {
            throw new ReviewedStingException("Internal error: CANNOT have null for a missing Haplotype base!");
        }
        super.updateBase(index, base);
    }

    public Haplotype clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new Haplotype(this);
    }

    public Haplotype subHaplotype(int fromIndex, int toIndex) {
        return new Haplotype(Arrays.copyOfRange(this.bases, fromIndex, Math.min(toIndex, this.size())));
    }
}

