/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import java.util.NoSuchElementException;

public class CloneableIteratorLinkedList<E> {
    private CloneableIteratorDoublyLinkedNode<E> first = null;
    private CloneableIteratorDoublyLinkedNode<E> last = null;
    private int size = 0;

    public boolean isEmpty() {
        return this.first == null;
    }

    public int size() {
        return this.size;
    }

    public void addFirst(E e) {
        CloneableIteratorDoublyLinkedNode<E> newNode = new CloneableIteratorDoublyLinkedNode<E>(e);
        if (this.isEmpty()) {
            this.last = newNode;
        } else {
            ((CloneableIteratorDoublyLinkedNode)this.first).previous = (CloneableIteratorDoublyLinkedNode)newNode;
            ((CloneableIteratorDoublyLinkedNode)newNode).next = (CloneableIteratorDoublyLinkedNode)this.first;
        }
        this.first = newNode;
        ++this.size;
    }

    public void addLast(E e) {
        CloneableIteratorDoublyLinkedNode<E> newNode = new CloneableIteratorDoublyLinkedNode<E>(e);
        if (this.isEmpty()) {
            this.first = newNode;
        } else {
            ((CloneableIteratorDoublyLinkedNode)this.last).next = (CloneableIteratorDoublyLinkedNode)newNode;
            ((CloneableIteratorDoublyLinkedNode)newNode).previous = (CloneableIteratorDoublyLinkedNode)this.last;
        }
        this.last = newNode;
        ++this.size;
    }

    public E removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object e = ((CloneableIteratorDoublyLinkedNode)this.first).element;
        if (((CloneableIteratorDoublyLinkedNode)this.first).next == null) {
            this.last = null;
        } else {
            ((CloneableIteratorDoublyLinkedNode)this.first).next.previous = null;
        }
        this.first = ((CloneableIteratorDoublyLinkedNode)this.first).next;
        --this.size;
        return (E)e;
    }

    public E removeLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object e = ((CloneableIteratorDoublyLinkedNode)this.last).element;
        if (((CloneableIteratorDoublyLinkedNode)this.last).previous == null) {
            this.first = null;
        } else {
            ((CloneableIteratorDoublyLinkedNode)this.last).previous.next = null;
        }
        this.last = ((CloneableIteratorDoublyLinkedNode)this.last).previous;
        --this.size;
        return (E)e;
    }

    public E getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (E)((CloneableIteratorDoublyLinkedNode)this.first).element;
    }

    public E getLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (E)((CloneableIteratorDoublyLinkedNode)this.last).element;
    }

    public E peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.getFirst();
    }

    public E remove() {
        return this.removeFirst();
    }

    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    public CloneableIterator<E> iterator() {
        return new CloneableIterator(this);
    }

    public static class CloneableIterator<E>
    implements Cloneable {
        private CloneableIteratorDoublyLinkedNode<E> nextNode;
        private CloneableIteratorDoublyLinkedNode<E> lastNode;

        private CloneableIterator(CloneableIteratorDoublyLinkedNode<E> nextNode, CloneableIteratorDoublyLinkedNode<E> lastNode) {
            this.nextNode = nextNode;
            this.lastNode = lastNode;
        }

        private CloneableIterator(CloneableIteratorLinkedList<E> list) {
            this(((CloneableIteratorLinkedList)list).first, ((CloneableIteratorLinkedList)list).last);
        }

        public boolean hasNext() {
            return this.nextNode != null;
        }

        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object e = ((CloneableIteratorDoublyLinkedNode)this.nextNode).element;
            this.nextNode = ((CloneableIteratorDoublyLinkedNode)this.nextNode).next;
            return (E)e;
        }

        public boolean hasPrevious() {
            if (this.nextNode != null) {
                return ((CloneableIteratorDoublyLinkedNode)this.nextNode).previous != null;
            }
            return this.lastNode != null;
        }

        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.nextNode = this.nextNode != null ? ((CloneableIteratorDoublyLinkedNode)this.nextNode).previous : this.lastNode;
            return (E)((CloneableIteratorDoublyLinkedNode)this.nextNode).element;
        }

        public CloneableIterator<E> clone() {
            try {
                super.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            return new CloneableIterator<E>(this.nextNode, this.lastNode);
        }
    }

    private static class CloneableIteratorDoublyLinkedNode<E> {
        private E element = null;
        private CloneableIteratorDoublyLinkedNode<E> next = null;
        private CloneableIteratorDoublyLinkedNode<E> previous = null;

        public CloneableIteratorDoublyLinkedNode(E element) {
            this.element = element;
            this.next = null;
            this.previous = null;
        }
    }
}

