/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.io.File;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.walkers.genotyper.AlleleFrequencyCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.ExactAFCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedGenotyperEngine;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class UnifiedArgumentCollection {
    @Argument(fullName="genotype_likelihoods_model", shortName="glm", doc="Genotype likelihoods calculation model to employ -- SNP is the default option, while INDEL is also available for calling indels and BOTH is available for calling both together", required=false)
    public GenotypeLikelihoodsCalculationModel.Model GLmodel = GenotypeLikelihoodsCalculationModel.Model.SNP;
    @Argument(fullName="p_nonref_model", shortName="pnrm", doc="Non-reference probability calculation model to employ -- EXACT is the default option, while GRID_SEARCH is also available.", required=false)
    public AlleleFrequencyCalculationModel.Model AFmodel = AlleleFrequencyCalculationModel.Model.EXACT;
    @Argument(fullName="heterozygosity", shortName="hets", doc="Heterozygosity value used to compute prior likelihoods for any locus", required=false)
    public Double heterozygosity = 0.001;
    @Argument(fullName="pcr_error_rate", shortName="pcr_error", doc="The PCR error rate to be used for computing fragment-based likelihoods", required=false)
    public Double PCR_error = 1.0E-4;
    @Argument(fullName="genotyping_mode", shortName="gt_mode", doc="Should we output confident genotypes (i.e. including ref calls) or just the variants?", required=false)
    public GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE GenotypingMode = GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.DISCOVERY;
    @Argument(fullName="output_mode", shortName="out_mode", doc="Should we output confident genotypes (i.e. including ref calls) or just the variants?", required=false)
    public UnifiedGenotyperEngine.OUTPUT_MODE OutputMode = UnifiedGenotyperEngine.OUTPUT_MODE.EMIT_VARIANTS_ONLY;
    @Argument(fullName="standard_min_confidence_threshold_for_calling", shortName="stand_call_conf", doc="The minimum phred-scaled confidence threshold at which variants not at 'trigger' track sites should be called", required=false)
    public double STANDARD_CONFIDENCE_FOR_CALLING = 30.0;
    @Argument(fullName="standard_min_confidence_threshold_for_emitting", shortName="stand_emit_conf", doc="The minimum phred-scaled confidence threshold at which variants not at 'trigger' track sites should be emitted (and filtered if less than the calling threshold)", required=false)
    public double STANDARD_CONFIDENCE_FOR_EMITTING = 30.0;
    @Argument(fullName="computeSLOD", shortName="sl", doc="If provided, we will calculate the SLOD", required=false)
    public boolean COMPUTE_SLOD = false;
    @Input(fullName="alleles", shortName="alleles", doc="The set of alleles at which to genotype when in GENOTYPE_MODE = GENOTYPE_GIVEN_ALLELES", required=false)
    public RodBinding<VariantContext> alleles;
    @Hidden
    @Argument(fullName="assume_single_sample_reads", shortName="single_sample", doc="The single sample that we should assume is represented in the input bam (and therefore associate with all reads regardless of whether they have read groups)", required=false)
    public String ASSUME_SINGLE_SAMPLE = null;
    @Hidden
    @Argument(fullName="abort_at_too_much_coverage", doc="Don't call a site if the downsampled coverage is greater than this value", required=false)
    public int COVERAGE_AT_WHICH_TO_ABORT = -1;
    @Argument(fullName="min_base_quality_score", shortName="mbq", doc="Minimum base quality required to consider a base for calling", required=false)
    public int MIN_BASE_QUALTY_SCORE = 17;
    @Argument(fullName="min_mapping_quality_score", shortName="mmq", doc="Minimum read mapping quality required to consider a read for calling", required=false)
    public int MIN_MAPPING_QUALTY_SCORE = 20;
    @Argument(fullName="max_deletion_fraction", shortName="deletions", doc="Maximum fraction of reads with deletions spanning this locus for it to be callable [to disable, set to < 0 or > 1; default:0.05]", required=false)
    public Double MAX_DELETION_FRACTION = 0.05;
    @Argument(fullName="min_indel_count_for_genotyping", shortName="minIndelCnt", doc="Minimum number of consensus indels required to trigger genotyping run", required=false)
    public int MIN_INDEL_COUNT_FOR_GENOTYPING = 5;
    @Argument(fullName="indel_heterozygosity", shortName="indelHeterozygosity", doc="Heterozygosity for indel calling", required=false)
    public double INDEL_HETEROZYGOSITY = 1.25E-4;
    @Hidden
    @Argument(fullName="indelGapContinuationPenalty", shortName="indelGCP", doc="Indel gap continuation penalty", required=false)
    public double INDEL_GAP_CONTINUATION_PENALTY = 10.0;
    @Hidden
    @Argument(fullName="indelGapOpenPenalty", shortName="indelGOP", doc="Indel gap open penalty", required=false)
    public double INDEL_GAP_OPEN_PENALTY = 45.0;
    @Hidden
    @Argument(fullName="indelHaplotypeSize", shortName="indelHSize", doc="Indel haplotype size", required=false)
    public int INDEL_HAPLOTYPE_SIZE = 80;
    @Hidden
    @Argument(fullName="doContextDependentGapPenalties", shortName="doCDP", doc="Vary gap penalties by context", required=false)
    public boolean DO_CONTEXT_DEPENDENT_PENALTIES = true;
    @Hidden
    @Argument(fullName="getGapPenaltiesFromData", shortName="dataGP", doc="Vary gap penalties by context - EXPERIMENTAL, DO NO USE", required=false)
    public boolean GET_GAP_PENALTIES_FROM_DATA = false;
    @Hidden
    @Argument(fullName="indel_recal_file", shortName="recalFile", required=false, doc="Filename for the input covariates table recalibration .csv file - EXPERIMENTAL, DO NO USE")
    public File INDEL_RECAL_FILE = new File("indel.recal_data.csv");
    @Hidden
    @Argument(fullName="indelDebug", shortName="indelDebug", doc="Output indel debug info", required=false)
    public boolean OUTPUT_DEBUG_INDEL_INFO = false;
    @Hidden
    @Argument(fullName="dovit", shortName="dovit", doc="Perform full Viterbi calculation when evaluating the HMM", required=false)
    public boolean dovit = false;
    @Hidden
    @Argument(fullName="GSA_PRODUCTION_ONLY", shortName="GSA_PRODUCTION_ONLY", doc="don't ever use me", required=false)
    public boolean GSA_PRODUCTION_ONLY = false;
    @Hidden
    @Argument(fullName="exactCalculation", shortName="exactCalculation", doc="expt", required=false)
    public ExactAFCalculationModel.ExactCalculation EXACT_CALCULATION_TYPE = ExactAFCalculationModel.ExactCalculation.LINEAR_EXPERIMENTAL;
    @Hidden
    @Argument(fullName="ignoreSNPAlleles", shortName="ignoreSNPAlleles", doc="expt", required=false)
    public boolean IGNORE_SNP_ALLELES = false;
    @Deprecated
    @Argument(fullName="output_all_callable_bases", shortName="all_bases", doc="Please use --output_mode EMIT_ALL_SITES instead", required=false)
    private Boolean ALL_BASES_DEPRECATED = false;
    @Deprecated
    @Argument(fullName="genotype", shortName="genotype", doc="Please use --output_mode EMIT_ALL_CONFIDENT_SITES instead", required=false)
    private Boolean GENOTYPE_DEPRECATED = false;

    public UnifiedArgumentCollection clone() {
        UnifiedArgumentCollection uac = new UnifiedArgumentCollection();
        uac.GLmodel = this.GLmodel;
        uac.AFmodel = this.AFmodel;
        uac.EXACT_CALCULATION_TYPE = this.EXACT_CALCULATION_TYPE;
        uac.heterozygosity = this.heterozygosity;
        uac.PCR_error = this.PCR_error;
        uac.GenotypingMode = this.GenotypingMode;
        uac.OutputMode = this.OutputMode;
        uac.COMPUTE_SLOD = this.COMPUTE_SLOD;
        uac.ASSUME_SINGLE_SAMPLE = this.ASSUME_SINGLE_SAMPLE;
        uac.STANDARD_CONFIDENCE_FOR_CALLING = this.STANDARD_CONFIDENCE_FOR_CALLING;
        uac.STANDARD_CONFIDENCE_FOR_EMITTING = this.STANDARD_CONFIDENCE_FOR_EMITTING;
        uac.MIN_BASE_QUALTY_SCORE = this.MIN_BASE_QUALTY_SCORE;
        uac.MIN_MAPPING_QUALTY_SCORE = this.MIN_MAPPING_QUALTY_SCORE;
        uac.MAX_DELETION_FRACTION = this.MAX_DELETION_FRACTION;
        uac.MIN_INDEL_COUNT_FOR_GENOTYPING = this.MIN_INDEL_COUNT_FOR_GENOTYPING;
        uac.INDEL_HETEROZYGOSITY = this.INDEL_HETEROZYGOSITY;
        uac.INDEL_GAP_OPEN_PENALTY = this.INDEL_GAP_OPEN_PENALTY;
        uac.INDEL_GAP_CONTINUATION_PENALTY = this.INDEL_GAP_CONTINUATION_PENALTY;
        uac.OUTPUT_DEBUG_INDEL_INFO = this.OUTPUT_DEBUG_INDEL_INFO;
        uac.INDEL_HAPLOTYPE_SIZE = this.INDEL_HAPLOTYPE_SIZE;
        uac.DO_CONTEXT_DEPENDENT_PENALTIES = this.DO_CONTEXT_DEPENDENT_PENALTIES;
        uac.alleles = this.alleles;
        uac.GET_GAP_PENALTIES_FROM_DATA = this.GET_GAP_PENALTIES_FROM_DATA;
        uac.INDEL_RECAL_FILE = this.INDEL_RECAL_FILE;
        uac.COVERAGE_AT_WHICH_TO_ABORT = this.COVERAGE_AT_WHICH_TO_ABORT;
        uac.dovit = this.dovit;
        uac.GSA_PRODUCTION_ONLY = this.GSA_PRODUCTION_ONLY;
        uac.IGNORE_SNP_ALLELES = this.IGNORE_SNP_ALLELES;
        return uac;
    }
}

