/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.beagle;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.arguments.StandardVariantContextInputArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.variantrecalibration.VQSRCalibrationCurve;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFilterHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class ProduceBeagleInputWalker
extends RodWalker<Integer, Integer> {
    @ArgumentCollection
    protected StandardVariantContextInputArgumentCollection variantCollection = new StandardVariantContextInputArgumentCollection();
    @Hidden
    @Input(fullName="validation", shortName="validation", doc="Validation VCF file", required=false)
    public RodBinding<VariantContext> validation;
    @Output(doc="File to which BEAGLE input should be written", required=true)
    protected PrintStream beagleWriter = null;
    @Hidden
    @Output(doc="File to which BEAGLE markers should be written", shortName="markers", fullName="markers", required=false)
    protected PrintStream markers = null;
    int markerCounter = 1;
    @Hidden
    @Input(doc="VQSqual calibration file", shortName="cc", required=false)
    protected File VQSRCalibrationFile = null;
    protected VQSRCalibrationCurve VQSRCalibrator = null;
    @Hidden
    @Argument(doc="VQSqual key", shortName="vqskey", required=false)
    protected String VQSLOD_KEY = "VQSqual";
    @Hidden
    @Argument(fullName="inserted_nocall_rate", shortName="nc_rate", doc="Rate (0-1) at which genotype no-calls will be randomly inserted, for testing", required=false)
    public double insertedNoCallRate = 0.0;
    @Hidden
    @Argument(fullName="validation_genotype_ptrue", shortName="valp", doc="Flat probability to assign to validation genotypes. Will override GL field.", required=false)
    public double validationPrior = -1.0;
    @Hidden
    @Argument(fullName="validation_bootstrap", shortName="bs", doc="Proportion of records to be used in bootstrap set", required=false)
    public double bootstrap = 0.0;
    @Hidden
    @Argument(fullName="bootstrap_vcf", shortName="bvcf", doc="Output a VCF with the records used for bootstrapping filtered out", required=false)
    VCFWriter bootstrapVCFOutput = null;
    @Argument(fullName="checkIsMaleOnChrX", shortName="checkIsMaleOnChrX", doc="Set to true when Beagle-ing chrX and want to ensure male samples don't have heterozygous calls.", required=false)
    public boolean CHECK_IS_MALE_ON_CHR_X = false;
    @Hidden
    @Argument(fullName="variant_genotype_ptrue", shortName="varp", doc="Flat probability prior to assign to variant (not validation) genotypes. Does not override GL field.", required=false)
    public double variantPrior = 0.96;
    private Set<String> samples = null;
    private Set<String> BOOTSTRAP_FILTER = new HashSet<String>(Arrays.asList("bootstrap"));
    private int bootstrapSetSize = 0;
    private int testSetSize = 0;
    private CachingFormatter formatter = new CachingFormatter("%5.4f ", 100000);
    private int certainFPs = 0;
    private static final double[] HAPLOID_FLAT_LOG10_LIKELIHOODS = MathUtils.toLog10(new double[]{0.5, 0.0, 0.5});
    private static final double[] DIPLOID_FLAT_LOG10_LIKELIHOODS = MathUtils.toLog10(new double[]{0.33, 0.33, 0.33});

    @Override
    public void initialize() {
        this.samples = SampleUtils.getSampleListWithVCFHeader(this.getToolkit(), Arrays.asList(this.variantCollection.variants.getName()));
        this.beagleWriter.print("marker alleleA alleleB");
        for (String sample : this.samples) {
            this.beagleWriter.print(String.format(" %s %s %s", sample, sample, sample));
        }
        this.beagleWriter.println();
        if (this.bootstrapVCFOutput != null) {
            this.initializeVcfWriter();
        }
        if (this.VQSRCalibrationFile != null) {
            this.VQSRCalibrator = VQSRCalibrationCurve.readFromFile(this.VQSRCalibrationFile);
            logger.info("Read calibration curve");
            this.VQSRCalibrator.printInfo(logger);
        }
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker != null) {
            VariantContext validation_eval;
            GenomeLoc loc = context.getLocation();
            VariantContext variant_eval = tracker.getFirstValue(this.variantCollection.variants, loc);
            if (this.goodSite(variant_eval, validation_eval = tracker.getFirstValue(this.validation, loc))) {
                if (this.useValidation(validation_eval, ref)) {
                    this.writeBeagleOutput(validation_eval, variant_eval, true, this.validationPrior);
                    return 1;
                }
                if (this.goodSite(variant_eval)) {
                    this.writeBeagleOutput(variant_eval, validation_eval, false, this.variantPrior);
                    return 1;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }

    public boolean goodSite(VariantContext a, VariantContext b) {
        return this.goodSite(a) || this.goodSite(b);
    }

    public boolean goodSite(VariantContext v) {
        if (ProduceBeagleInputWalker.canBeOutputToBeagle(v)) {
            if (this.VQSRCalibrator != null && this.VQSRCalibrator.certainFalsePositive(this.VQSLOD_KEY, v)) {
                ++this.certainFPs;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean canBeOutputToBeagle(VariantContext v) {
        return v != null && !v.isFiltered() && v.isBiallelic() && v.hasGenotypes();
    }

    public boolean useValidation(VariantContext validation, ReferenceContext ref) {
        if (this.goodSite(validation)) {
            logger.debug(String.format("boot: %d, test: %d, total: %d", this.bootstrapSetSize, this.testSetSize, this.bootstrapSetSize + this.testSetSize + 1));
            if (((double)this.bootstrapSetSize + 1.0) / (1.0 + (double)this.bootstrapSetSize + (double)this.testSetSize) <= this.bootstrap) {
                if (this.bootstrapVCFOutput != null) {
                    this.bootstrapVCFOutput.add(VariantContext.modifyFilters(validation, this.BOOTSTRAP_FILTER));
                }
                ++this.bootstrapSetSize;
                return true;
            }
            if (this.bootstrapVCFOutput != null) {
                this.bootstrapVCFOutput.add(validation);
            }
            ++this.testSetSize;
            return false;
        }
        if (validation != null && this.bootstrapVCFOutput != null) {
            this.bootstrapVCFOutput.add(validation);
        }
        return false;
    }

    public void writeBeagleOutput(VariantContext preferredVC, VariantContext otherVC, boolean isValidationSite, double prior) {
        GenomeLoc currentLoc = VariantContextUtils.getLocation(this.getToolkit().getGenomeLocParser(), preferredVC);
        StringBuffer beagleOut = new StringBuffer();
        String marker = String.format("%s:%d ", currentLoc.getContig(), currentLoc.getStart());
        beagleOut.append(marker);
        if (this.markers != null) {
            this.markers.append(marker).append("\t").append(Integer.toString(this.markerCounter++)).append("\t");
        }
        for (Allele allele : preferredVC.getAlleles()) {
            String bglPrintString = allele.isNoCall() || allele.isNull() ? "-" : allele.getBaseString();
            beagleOut.append(String.format("%s ", bglPrintString));
            if (this.markers == null) continue;
            this.markers.append(bglPrintString).append("\t");
        }
        if (this.markers != null) {
            this.markers.append("\n");
        }
        Map<String, Genotype> preferredGenotypes = preferredVC.getGenotypes();
        Map<String, Genotype> otherGenotypes = this.goodSite(otherVC) ? otherVC.getGenotypes() : null;
        for (String sample : this.samples) {
            boolean isValidation;
            Genotype genotype;
            boolean isMaleOnChrX;
            boolean bl = isMaleOnChrX = this.CHECK_IS_MALE_ON_CHR_X && this.getToolkit().getSampleById(sample).isMale();
            if (preferredGenotypes.keySet().contains(sample)) {
                genotype = preferredGenotypes.get(sample);
                isValidation = isValidationSite;
            } else if (otherGenotypes != null && otherGenotypes.keySet().contains(sample)) {
                genotype = otherGenotypes.get(sample);
                isValidation = !isValidationSite;
            } else {
                throw new StingException("Sample " + sample + " arose with no genotype in variant or validation VCF. This should never happen.");
            }
            double[] log10Likelihoods = null;
            if (isValidation && prior < 0.0 || genotype.hasLikelihoods()) {
                log10Likelihoods = genotype.getLikelihoods().getAsVector();
                if (GenomeAnalysisEngine.getRandomGenerator().nextDouble() <= this.insertedNoCallRate) {
                    double[] dArray = log10Likelihoods = isMaleOnChrX ? HAPLOID_FLAT_LOG10_LIKELIHOODS : DIPLOID_FLAT_LOG10_LIKELIHOODS;
                }
                if (isMaleOnChrX) {
                    log10Likelihoods[1] = -255.0;
                }
            } else if (!isValidation && genotype.isCalled() && !genotype.hasLikelihoods()) {
                double AA = (1.0 - prior) / 2.0;
                double AB = (1.0 - prior) / 2.0;
                double BB = (1.0 - prior) / 2.0;
                if (genotype.isHomRef()) {
                    AA = prior;
                } else if (genotype.isHet()) {
                    AB = prior;
                } else if (genotype.isHomVar()) {
                    BB = prior;
                }
                log10Likelihoods = MathUtils.toLog10(new double[]{AA, isMaleOnChrX ? 0.0 : AB, BB});
            } else {
                log10Likelihoods = isMaleOnChrX ? HAPLOID_FLAT_LOG10_LIKELIHOODS : DIPLOID_FLAT_LOG10_LIKELIHOODS;
            }
            this.writeSampleLikelihoods(beagleOut, preferredVC, log10Likelihoods);
        }
        this.beagleWriter.println(beagleOut.toString());
    }

    private void writeSampleLikelihoods(StringBuffer out, VariantContext vc, double[] log10Likelihoods) {
        double[] normalizedLikelihoods;
        if (this.VQSRCalibrator != null) {
            log10Likelihoods = this.VQSRCalibrator.includeErrorRateInLikelihoods(this.VQSLOD_KEY, vc, log10Likelihoods);
        }
        for (double likeVal : normalizedLikelihoods = MathUtils.normalizeFromLog10(log10Likelihoods)) {
            out.append(this.formatter.format(likeVal));
        }
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return value + sum;
    }

    @Override
    public void onTraversalDone(Integer includedSites) {
        logger.info("Sites included in beagle likelihoods file             : " + includedSites);
        logger.info(String.format("Certain false positive found from recalibration curve : %d (%.2f%%)", this.certainFPs, 100.0 * (double)this.certainFPs / (double)Math.max(this.certainFPs + includedSites, 1)));
    }

    private void initializeVcfWriter() {
        List<String> inputNames = Arrays.asList(this.validation.getName());
        HashSet<VCFHeaderLine> hInfo = new HashSet<VCFHeaderLine>();
        hInfo.addAll(VCFUtils.getHeaderFields(this.getToolkit(), inputNames));
        hInfo.add(new VCFFilterHeaderLine("bootstrap", "This site used for genotype bootstrapping with ProduceBeagleInputWalker"));
        this.bootstrapVCFOutput.writeHeader(new VCFHeader(hInfo, SampleUtils.getUniqueSamplesFromRods(this.getToolkit(), inputNames)));
    }

    public static class LRUCache<K, V> {
        private static final float hashTableLoadFactor = 0.75f;
        private LinkedHashMap<K, V> map;
        private int cacheSize;

        public LRUCache(int cacheSize) {
            this.cacheSize = cacheSize;
            int hashTableCapacity = (int)Math.ceil((float)cacheSize / 0.75f) + 1;
            this.map = new LinkedHashMap<K, V>(hashTableCapacity, 0.75f, true){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                    return this.size() > LRUCache.this.cacheSize;
                }
            };
        }

        public synchronized V get(K key) {
            return this.map.get(key);
        }

        public synchronized void put(K key, V value) {
            this.map.put(key, value);
        }

        public synchronized void clear() {
            this.map.clear();
        }

        public synchronized int usedEntries() {
            return this.map.size();
        }

        public synchronized Collection<Map.Entry<K, V>> getAll() {
            return new ArrayList<Map.Entry<K, V>>(this.map.entrySet());
        }
    }

    public static class CachingFormatter {
        private int maxCacheSize = 0;
        private String format;
        private LRUCache<Double, String> cache;

        public String getFormat() {
            return this.format;
        }

        public String format(double value) {
            String f = this.cache.get(value);
            if (f == null) {
                f = String.format(this.format, value);
                this.cache.put(value, f);
            }
            return f;
        }

        public CachingFormatter(String format, int maxCacheSize) {
            this.maxCacheSize = maxCacheSize;
            this.format = format;
            this.cache = new LRUCache(maxCacheSize);
        }
    }
}

