/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineCount;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class SampleList
extends InfoFieldAnnotation {
    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatibleWalker walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        if (vc.isMonomorphic() || !vc.hasGenotypes()) {
            return null;
        }
        StringBuffer samples = new StringBuffer();
        for (Genotype genotype : vc.getGenotypesSortedByName()) {
            if (!genotype.isCalled() || genotype.isHomRef()) continue;
            if (samples.length() > 0) {
                samples.append(",");
            }
            samples.append(genotype.getSampleName());
        }
        if (samples.length() == 0) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Samples", samples.toString());
        return map;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("Samples");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine("Samples", VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "List of polymorphic samples"));
    }
}

