/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashSet;
import java.util.Set;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.BAQMode;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.text.XReadLines;

@BAQMode(QualityMode=BAQ.QualityMode.ADD_TAG, ApplicationTime=BAQ.ApplicationTime.ON_OUTPUT)
@Requires(value={DataSource.READS, DataSource.REFERENCE})
public class FindReadsWithNamesWalker
extends ReadWalker<SAMRecord, SAMFileWriter> {
    @Output(doc="Write output to this BAM filename instead of STDOUT")
    SAMFileWriter out;
    @Argument(fullName="readNamesToKeep", shortName="rn", doc="names to keep", required=true)
    File readNamesFile = null;
    Set<String> namesToKeep;

    @Override
    public void initialize() {
        try {
            this.namesToKeep = new HashSet<String>(new XReadLines(this.readNamesFile).readLines());
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotReadInputFile(this.readNamesFile, (Exception)e);
        }
    }

    @Override
    public boolean filter(ReferenceContext ref, SAMRecord read) {
        return this.namesToKeep.contains(read.getReadName());
    }

    @Override
    public SAMRecord map(ReferenceContext ref, SAMRecord read, ReadMetaDataTracker metaDataTracker) {
        return read;
    }

    @Override
    public SAMFileWriter reduceInit() {
        return this.out;
    }

    @Override
    public SAMFileWriter reduce(SAMRecord read, SAMFileWriter output) {
        output.addAlignment(read);
        return output;
    }
}

