/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.traversals;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.ReadMetrics;
import org.broadinstitute.sting.gatk.datasources.providers.ShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.SimpleTimer;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

public abstract class TraversalEngine<M, T, WalkerType extends Walker<M, T>, ProviderType extends ShardDataProvider> {
    private static final int HISTORY_WINDOW_SIZE = 50;
    private static final Object lock = new Object();
    LinkedList<ProcessingHistory> history = new LinkedList();
    private SimpleTimer timer = null;
    private static final int PRINT_PROGRESS_CHECK_FREQUENCY_IN_CYCLES = 1000;
    private int printProgressCheckCounter = 0;
    private long lastProgressPrintTime = -1L;
    private long MIN_ELAPSED_TIME_BEFORE_FIRST_PROGRESS = 120000L;
    private long PROGRESS_PRINT_FREQUENCY = 10000L;
    private final double TWO_HOURS_IN_SECONDS = 7200.0;
    private final double TWELVE_HOURS_IN_SECONDS = 43200.0;
    private boolean progressMeterInitialized = false;
    private static final boolean PERFORMANCE_LOG_ENABLED = true;
    private final Object performanceLogLock = new Object();
    private File performanceLogFile;
    private PrintStream performanceLog = null;
    private long lastPerformanceLogPrintTime = -1L;
    private final long PERFORMANCE_LOG_PRINT_FREQUENCY = this.PROGRESS_PRINT_FREQUENCY;
    long targetSize = -1L;
    GenomeLocSortedSet targetIntervals = null;
    protected static Logger logger = Logger.getLogger(TraversalEngine.class);
    protected GenomeAnalysisEngine engine;

    protected abstract String getTraversalType();

    public abstract T traverse(WalkerType var1, ProviderType var2, T var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(GenomeAnalysisEngine engine) {
        if (engine == null) {
            throw new ReviewedStingException("BUG: GenomeAnalysisEngine cannot be null!");
        }
        this.engine = engine;
        if (engine.getArguments() != null && engine.getArguments().performanceLog != null) {
            Object object = this.performanceLogLock;
            synchronized (object) {
                this.performanceLogFile = engine.getArguments().performanceLog;
                this.createNewPerformanceLog();
            }
        }
        this.targetIntervals = this.engine.getIntervals() == null ? GenomeLocSortedSet.createSetFromSequenceDictionary(engine.getReferenceDataSource().getReference().getSequenceDictionary()) : this.engine.getIntervals();
        this.targetSize = this.targetIntervals.coveredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewPerformanceLog() {
        Object object = this.performanceLogLock;
        synchronized (object) {
            try {
                this.performanceLog = new PrintStream(new FileOutputStream(this.engine.getArguments().performanceLog));
                List<String> pLogHeader = Arrays.asList("elapsed.time", "units.processed", "processing.speed", "bp.processed", "bp.speed", "genome.fraction.complete", "est.total.runtime", "est.time.remaining");
                this.performanceLog.println(Utils.join("\t", pLogHeader));
            }
            catch (FileNotFoundException e) {
                throw new UserException.CouldNotCreateOutputFile(this.engine.getArguments().performanceLog, e);
            }
        }
    }

    public void startTimersIfNecessary() {
        if (this.timer == null) {
            this.timer = new SimpleTimer("Traversal");
            this.timer.start();
            this.lastProgressPrintTime = this.timer.currentTime();
        }
    }

    private boolean maxElapsedIntervalForPrinting(long curTime, long lastPrintTime, long printFreq) {
        long elapsed = curTime - lastPrintTime;
        return elapsed > printFreq && elapsed > this.MIN_ELAPSED_TIME_BEFORE_FIRST_PROGRESS;
    }

    public void printProgress(Shard shard, GenomeLoc loc) {
        this.printProgress(loc, shard.getReadMetrics(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printProgress(GenomeLoc loc, ReadMetrics metrics, boolean mustPrint) {
        boolean printLog;
        if (mustPrint || this.printProgressCheckCounter++ % 1000 != 0) {
            return;
        }
        if (!this.progressMeterInitialized && !mustPrint) {
            logger.info("[INITIALIZATION COMPLETE; TRAVERSAL STARTING]");
            logger.info(String.format("%15s processed.%s  runtime per.1M.%s completed total.runtime remaining", "Location", this.getTraversalType(), this.getTraversalType()));
            this.progressMeterInitialized = true;
        }
        long curTime = this.timer.currentTime();
        boolean printProgress = mustPrint || this.maxElapsedIntervalForPrinting(curTime, this.lastProgressPrintTime, this.PROGRESS_PRINT_FREQUENCY);
        boolean bl = printLog = this.performanceLog != null && this.maxElapsedIntervalForPrinting(curTime, this.lastPerformanceLogPrintTime, this.PERFORMANCE_LOG_PRINT_FREQUENCY);
        if (printProgress || printLog) {
            ReadMetrics cumulativeMetrics;
            ReadMetrics readMetrics = cumulativeMetrics = this.engine.getCumulativeMetrics() != null ? this.engine.getCumulativeMetrics() : new ReadMetrics();
            if (metrics != null) {
                cumulativeMetrics.incrementMetrics(metrics);
            }
            long nRecords = cumulativeMetrics.getNumIterations();
            ProcessingHistory last = this.updateHistory(loc, cumulativeMetrics);
            MyTime elapsed = new MyTime(last.elapsedSeconds);
            MyTime bpRate = new MyTime(this.secondsPerMillionBP(last));
            MyTime unitRate = new MyTime(this.secondsPerMillionElements(last));
            double fractionGenomeTargetCompleted = this.calculateFractionGenomeTargetCompleted(last);
            MyTime estTotalRuntime = new MyTime(elapsed.t / fractionGenomeTargetCompleted);
            MyTime timeToCompletion = new MyTime(estTotalRuntime.t - elapsed.t);
            if (printProgress) {
                this.lastProgressPrintTime = curTime;
                this.PROGRESS_PRINT_FREQUENCY = estTotalRuntime.t > 43200.0 ? 60000L : (estTotalRuntime.t > 7200.0 ? 30000L : 10000L);
                logger.info(String.format("%15s        %5.2e %s     %s     %4.1f%%      %s  %s", loc == null ? "done with mapped reads" : loc, (double)nRecords * 1.0, elapsed, unitRate, 100.0 * fractionGenomeTargetCompleted, estTotalRuntime, timeToCompletion));
            }
            if (printLog) {
                this.lastPerformanceLogPrintTime = curTime;
                Object object = this.performanceLogLock;
                synchronized (object) {
                    this.performanceLog.printf("%.2f\t%d\t%.2e\t%d\t%.2e\t%.2e\t%.2f\t%.2f%n", elapsed.t, nRecords, unitRate.t, last.bpProcessed, bpRate.t, fractionGenomeTargetCompleted, estTotalRuntime.t, timeToCompletion.t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ProcessingHistory updateHistory(GenomeLoc loc, ReadMetrics metrics) {
        Object object = lock;
        synchronized (object) {
            if (this.history.size() > 50) {
                this.history.pop();
            }
            long nRecords = metrics.getNumIterations();
            long bpProcessed = loc == null ? this.targetSize : this.targetIntervals.sizeBeforeLoc(loc);
            this.history.add(new ProcessingHistory(this.timer.getElapsedTime(), loc, nRecords, bpProcessed));
            return this.history.getLast();
        }
    }

    private final double secondsPerMillionElements(ProcessingHistory last) {
        return last.elapsedSeconds * 1000000.0 / (double)Math.max(last.unitsProcessed, 1L);
    }

    private final double secondsPerMillionBP(ProcessingHistory last) {
        return last.elapsedSeconds * 1000000.0 / (double)Math.max(last.bpProcessed, 1L);
    }

    private final double calculateFractionGenomeTargetCompleted(ProcessingHistory last) {
        return 1.0 * (double)last.bpProcessed / (double)this.targetSize;
    }

    public void printOnTraversalDone() {
        this.printProgress(null, null, true);
        double elapsed = this.timer == null ? 0.0 : this.timer.getElapsedTime();
        ReadMetrics cumulativeMetrics = this.engine.getCumulativeMetrics();
        long nSkippedReads = 0L;
        for (Map.Entry<Class, Long> countsByFilter : cumulativeMetrics.getCountsByFilter().entrySet()) {
            nSkippedReads += countsByFilter.getValue().longValue();
        }
        logger.info(String.format("Total runtime %.2f secs, %.2f min, %.2f hours", elapsed, elapsed / 60.0, elapsed / 3600.0));
        if (cumulativeMetrics.getNumReadsSeen() > 0L) {
            logger.info(String.format("%d reads were filtered out during traversal out of %d total (%.2f%%)", nSkippedReads, cumulativeMetrics.getNumReadsSeen(), 100.0 * MathUtils.ratio(nSkippedReads, cumulativeMetrics.getNumReadsSeen())));
        }
        for (Map.Entry<Class, Long> filterCounts : cumulativeMetrics.getCountsByFilter().entrySet()) {
            long count = filterCounts.getValue();
            logger.info(String.format("  -> %d reads (%.2f%% of total) failing %s", count, 100.0 * MathUtils.ratio(count, cumulativeMetrics.getNumReadsSeen()), Utils.getClassName(filterCounts.getKey())));
        }
        if (this.performanceLog != null) {
            this.performanceLog.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPerformanceLogFileName() {
        Object object = this.performanceLogLock;
        synchronized (object) {
            return this.performanceLogFile.getAbsolutePath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPerformanceLogFileName(String fileName) {
        File file = new File(fileName);
        Object object = this.performanceLogLock;
        synchronized (object) {
            if (this.performanceLogFile != null && this.performanceLogFile.equals(fileName)) {
                return;
            }
            if (this.performanceLog != null) {
                this.performanceLog.close();
            }
            this.performanceLogFile = file;
            this.createNewPerformanceLog();
        }
    }

    public long getPerformanceProgressPrintFrequencySeconds() {
        return this.PROGRESS_PRINT_FREQUENCY;
    }

    public void setPerformanceProgressPrintFrequencySeconds(long seconds) {
        this.PROGRESS_PRINT_FREQUENCY = seconds;
    }

    private static class MyTime {
        double t;
        int precision;

        public MyTime(double t, int precision) {
            this.t = t;
            this.precision = precision;
        }

        public MyTime(double t) {
            this(t, 1);
        }

        public String toString() {
            double unitTime = this.t;
            String unit = "s";
            if (this.t > 120.0) {
                unitTime = this.t / 60.0;
                unit = "m";
                if (unitTime > 120.0) {
                    unitTime /= 60.0;
                    unit = "h";
                    if (unitTime > 100.0) {
                        unitTime /= 24.0;
                        unit = "d";
                        if (unitTime > 20.0) {
                            unitTime /= 7.0;
                            unit = "w";
                        }
                    }
                }
            }
            return String.format("%6." + this.precision + "f %s", unitTime, unit);
        }
    }

    private static class ProcessingHistory {
        double elapsedSeconds;
        long unitsProcessed;
        long bpProcessed;
        GenomeLoc loc;

        public ProcessingHistory(double elapsedSeconds, GenomeLoc loc, long unitsProcessed, long bpProcessed) {
            this.elapsedSeconds = elapsedSeconds;
            this.loc = loc;
            this.unitsProcessed = unitsProcessed;
            this.bpProcessed = bpProcessed;
        }
    }
}

