/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.iterators;

import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.iterators.ReadSelector;

class SamplePartitioner
implements ReadSelector {
    private final Map<String, ReadSelector> readsBySample;
    private long readsSeen = 0L;

    public SamplePartitioner(Map<String, ReadSelector> readSelectors) {
        this.readsBySample = readSelectors;
    }

    @Override
    public void submitRead(SAMRecord read) {
        String sampleName;
        String string = sampleName = read.getReadGroup() != null ? read.getReadGroup().getSample() : null;
        if (this.readsBySample.containsKey(sampleName)) {
            this.readsBySample.get(sampleName).submitRead(read);
        }
        ++this.readsSeen;
    }

    @Override
    public void notifyReadRejected(SAMRecord read) {
        String sampleName;
        String string = sampleName = read.getReadGroup() != null ? read.getReadGroup().getSample() : null;
        if (this.readsBySample.containsKey(sampleName)) {
            this.readsBySample.get(sampleName).notifyReadRejected(read);
        }
        ++this.readsSeen;
    }

    @Override
    public void complete() {
    }

    @Override
    public long getNumReadsSeen() {
        return this.readsSeen;
    }

    @Override
    public long getNumReadsSelected() {
        return this.readsSeen;
    }

    @Override
    public int getDownsamplingExtent() {
        int downsamplingExtent = 0;
        for (ReadSelector storage : this.readsBySample.values()) {
            downsamplingExtent = Math.max(downsamplingExtent, storage.getDownsamplingExtent());
        }
        return downsamplingExtent;
    }

    @Override
    public Collection<SAMRecord> getSelectedReads() {
        throw new UnsupportedOperationException("Cannot directly get selected reads from a read partitioner.");
    }

    public ReadSelector getSelectedReads(String sampleName) {
        if (!this.readsBySample.containsKey(sampleName)) {
            throw new NoSuchElementException("Sample name not found");
        }
        return this.readsBySample.get(sampleName);
    }

    @Override
    public void reset() {
        for (ReadSelector storage : this.readsBySample.values()) {
            storage.reset();
        }
        this.readsSeen = 0L;
    }
}

