/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.io.storage;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import net.sf.samtools.util.BlockCompressedOutputStream;
import org.apache.log4j.Logger;
import org.broad.tribble.source.BasicFeatureSource;
import org.broadinstitute.sting.gatk.io.storage.Storage;
import org.broadinstitute.sting.gatk.io.stubs.VCFWriterStub;
import org.broadinstitute.sting.utils.codecs.vcf.StandardVCFWriter;
import org.broadinstitute.sting.utils.codecs.vcf.VCFCodec;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class VCFWriterStorage
implements Storage<VCFWriterStorage>,
VCFWriter {
    private static Logger logger = Logger.getLogger(VCFWriterStorage.class);
    protected final File file;
    protected OutputStream stream;
    protected final VCFWriter writer;

    public VCFWriterStorage(VCFWriterStub stub) {
        if (stub.getFile() != null) {
            this.file = stub.getFile();
            this.writer = this.vcfWriterToFile(stub, stub.getFile(), true);
        } else if (stub.getOutputStream() != null) {
            this.file = null;
            this.stream = stub.getOutputStream();
            this.writer = new StandardVCFWriter(this.stream, stub.doNotWriteGenotypes());
        } else {
            throw new ReviewedStingException("Unable to create target to which to write; storage was provided with neither a file nor a stream.");
        }
    }

    private StandardVCFWriter vcfWriterToFile(VCFWriterStub stub, File file, boolean indexOnTheFly) {
        try {
            this.stream = stub.isCompressed() ? new BlockCompressedOutputStream(file) : new PrintStream(file);
        }
        catch (IOException ex) {
            throw new UserException.CouldNotCreateOutputFile(file, "Unable to open target output stream", (Exception)ex);
        }
        return new StandardVCFWriter(file, this.stream, indexOnTheFly && !stub.isCompressed(), stub.doNotWriteGenotypes());
    }

    public VCFWriterStorage(VCFWriterStub stub, File tempFile) {
        logger.debug("Creating temporary VCF file " + tempFile.getAbsolutePath() + " for VCF output.");
        this.file = tempFile;
        this.writer = this.vcfWriterToFile(stub, this.file, false);
        this.writer.writeHeader(stub.getVCFHeader());
    }

    @Override
    public void add(VariantContext vc) {
        this.writer.add(vc);
    }

    @Override
    public void writeHeader(VCFHeader header) {
        this.writer.writeHeader(header);
    }

    @Override
    public void close() {
        if (this.file != null) {
            logger.debug("Closing temporary file " + this.file.getAbsolutePath());
        }
        this.writer.close();
    }

    @Override
    public void mergeInto(VCFWriterStorage target) {
        try {
            String sourceFilePath = this.file.getAbsolutePath();
            String targetFilePath = target.file != null ? target.file.getAbsolutePath() : "/dev/stdin";
            logger.debug(String.format("Merging %s into %s", sourceFilePath, targetFilePath));
            BasicFeatureSource source = BasicFeatureSource.getFeatureSource(this.file.getAbsolutePath(), new VCFCodec(), false);
            for (VariantContext vc : source.iterator()) {
                target.writer.add(vc);
            }
            source.close();
        }
        catch (IOException e) {
            throw new UserException.CouldNotReadInputFile(this.file, "Error reading file in VCFWriterStorage: ", e);
        }
    }
}

