/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.sting.gatk.datasources.reads.LocusShardStrategy;
import org.broadinstitute.sting.gatk.datasources.reads.ReadShardStrategy;
import org.broadinstitute.sting.gatk.datasources.reads.SAMDataSource;
import org.broadinstitute.sting.gatk.datasources.reads.ShardStrategy;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class ShardStrategyFactory {
    public static ShardStrategy shatter(SAMDataSource readsDataSource, IndexedFastaSequenceFile referenceDataSource, SHATTER_STRATEGY strat, SAMSequenceDictionary dic, long startingSize, GenomeLocParser genomeLocParser) {
        return ShardStrategyFactory.shatter(readsDataSource, referenceDataSource, strat, dic, startingSize, genomeLocParser, -1L);
    }

    public static ShardStrategy shatter(SAMDataSource readsDataSource, IndexedFastaSequenceFile referenceDataSource, SHATTER_STRATEGY strat, SAMSequenceDictionary dic, long startingSize, GenomeLocParser genomeLocParser, long limitByCount) {
        switch (strat) {
            case LOCUS_EXPERIMENTAL: {
                return new LocusShardStrategy(readsDataSource, referenceDataSource, genomeLocParser, null);
            }
            case READS_EXPERIMENTAL: {
                return new ReadShardStrategy(genomeLocParser, readsDataSource, null);
            }
        }
        throw new ReviewedStingException("Strategy: " + (Object)((Object)strat) + " isn't implemented for this type of shatter request");
    }

    public static ShardStrategy shatter(SAMDataSource readsDataSource, IndexedFastaSequenceFile referenceDataSource, SHATTER_STRATEGY strat, SAMSequenceDictionary dic, long startingSize, GenomeLocParser genomeLocParser, GenomeLocSortedSet lst) {
        return ShardStrategyFactory.shatter(readsDataSource, referenceDataSource, strat, dic, startingSize, genomeLocParser, lst, -1L);
    }

    public static ShardStrategy shatter(SAMDataSource readsDataSource, IndexedFastaSequenceFile referenceDataSource, SHATTER_STRATEGY strat, SAMSequenceDictionary dic, long startingSize, GenomeLocParser genomeLocParser, GenomeLocSortedSet lst, long limitDataCount) {
        switch (strat) {
            case LOCUS_EXPERIMENTAL: {
                return new LocusShardStrategy(readsDataSource, referenceDataSource, genomeLocParser, lst);
            }
            case READS_EXPERIMENTAL: {
                return new ReadShardStrategy(genomeLocParser, readsDataSource, lst);
            }
        }
        throw new ReviewedStingException("Strategy: " + (Object)((Object)strat) + " isn't implemented");
    }

    public static enum SHATTER_STRATEGY {
        MONOLITHIC,
        LOCUS_EXPERIMENTAL,
        READS_EXPERIMENTAL;

    }
}

