/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.sf.samtools.SAMFileSpan;
import org.broadinstitute.sting.gatk.datasources.reads.FilePointer;
import org.broadinstitute.sting.gatk.datasources.reads.IntervalSharder;
import org.broadinstitute.sting.gatk.datasources.reads.LowMemoryIntervalSharder;
import org.broadinstitute.sting.gatk.datasources.reads.ReadShard;
import org.broadinstitute.sting.gatk.datasources.reads.SAMDataSource;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.datasources.reads.ShardStrategy;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;

public class ReadShardStrategy
implements ShardStrategy {
    protected static final int MAX_READS = 10000;
    private final SAMDataSource dataSource;
    private final GenomeLocSortedSet locations;
    private Shard nextShard = null;
    private final List<FilePointer> filePointers = new ArrayList<FilePointer>();
    private final Iterator<FilePointer> filePointerIterator;
    private FilePointer currentFilePointer;
    private Map<SAMReaderID, SAMFileSpan> position;
    private boolean isIntoUnmappedRegion = false;
    private final GenomeLocParser parser;

    public ReadShardStrategy(GenomeLocParser parser, SAMDataSource dataSource, GenomeLocSortedSet locations) {
        this.dataSource = dataSource;
        this.parser = parser;
        this.position = this.dataSource.getCurrentPosition();
        this.locations = locations;
        this.filePointerIterator = locations != null ? (dataSource.isLowMemoryShardingEnabled() ? new LowMemoryIntervalSharder(this.dataSource, locations) : IntervalSharder.shardIntervals(this.dataSource, locations)) : this.filePointers.iterator();
        if (this.filePointerIterator.hasNext()) {
            this.currentFilePointer = this.filePointerIterator.next();
        }
        this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.nextShard != null;
    }

    @Override
    public Shard next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next read shard available");
        }
        Shard currentShard = this.nextShard;
        this.advance();
        return currentShard;
    }

    public void advance() {
        Map<Object, Object> shardPosition = new HashMap();
        this.nextShard = null;
        if (this.locations != null) {
            HashMap<SAMReaderID, SAMFileSpan> selectedReaders = new HashMap<SAMReaderID, SAMFileSpan>();
            while (selectedReaders.size() == 0 && this.currentFilePointer != null) {
                shardPosition = this.currentFilePointer.fileSpans;
                for (SAMReaderID sAMReaderID : shardPosition.keySet()) {
                    SAMFileSpan fileSpan = ((SAMFileSpan)shardPosition.get(sAMReaderID)).removeContentsBefore(this.position.get(sAMReaderID));
                    if (fileSpan.isEmpty()) continue;
                    selectedReaders.put(sAMReaderID, fileSpan);
                }
                if (selectedReaders.size() > 0) {
                    ReadShard shard = new ReadShard(this.parser, this.dataSource, selectedReaders, this.currentFilePointer.locations, this.currentFilePointer.isRegionUnmapped);
                    this.dataSource.fillShard(shard);
                    if (!((Shard)shard).isBufferEmpty()) {
                        this.nextShard = shard;
                        break;
                    }
                }
                selectedReaders.clear();
                this.currentFilePointer = this.filePointerIterator.hasNext() ? this.filePointerIterator.next() : null;
            }
        } else {
            ReadShard shard = new ReadShard(this.parser, this.dataSource, this.position, null, false);
            this.dataSource.fillShard(shard);
            this.nextShard = !((Shard)shard).isBufferEmpty() ? shard : null;
        }
        this.position = this.dataSource.getCurrentPosition();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove not supported");
    }

    @Override
    public Iterator<Shard> iterator() {
        return this;
    }
}

