/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.providers;

import java.util.ArrayList;
import java.util.Collection;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.datasources.providers.ManagingReferenceOrderedView;
import org.broadinstitute.sting.gatk.datasources.providers.ShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.providers.View;
import org.broadinstitute.sting.gatk.datasources.providers.WindowedData;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;

public class ReadBasedReferenceOrderedView
implements View {
    private final WindowedData window;

    public ReadBasedReferenceOrderedView(ShardDataProvider provider) {
        this.window = new WindowedData(provider);
        provider.register(this);
    }

    ReadBasedReferenceOrderedView(WindowedData data) {
        this.window = data;
    }

    public ReadMetaDataTracker getReferenceOrderedDataForRead(SAMRecord read) {
        return this.window.getTracker(read);
    }

    @Override
    public Collection<Class<? extends View>> getConflictingViews() {
        ArrayList<Class<? extends View>> classes = new ArrayList<Class<? extends View>>();
        classes.add(ManagingReferenceOrderedView.class);
        return classes;
    }

    @Override
    public void close() {
        if (this.window != null) {
            this.window.close();
        }
    }
}

