/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk;

import java.util.Collection;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import org.broadinstitute.sting.gatk.DownsamplingMethod;
import org.broadinstitute.sting.gatk.arguments.ValidationExclusion;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.gatk.filters.ReadFilter;
import org.broadinstitute.sting.utils.baq.BAQ;

public class ReadProperties {
    private Collection<SAMReaderID> readers = null;
    private SAMFileHeader header = null;
    private SAMFileReader.ValidationStringency validationStringency = SAMFileReader.ValidationStringency.STRICT;
    private Integer readBufferSize = null;
    private DownsamplingMethod downsamplingMethod = null;
    private ValidationExclusion exclusionList = null;
    private Collection<ReadFilter> supplementalFilters = null;
    private boolean includeReadsWithDeletionAtLoci = false;
    private boolean useOriginalBaseQualities = false;
    private boolean generateExtendedEvents = false;
    private BAQ.CalculationMode cmode = BAQ.CalculationMode.OFF;
    private BAQ.QualityMode qmode = BAQ.QualityMode.DONT_MODIFY;
    IndexedFastaSequenceFile refReader = null;
    private byte defaultBaseQualities;

    public boolean includeReadsWithDeletionAtLoci() {
        return this.includeReadsWithDeletionAtLoci;
    }

    public boolean generateExtendedEvents() {
        return this.generateExtendedEvents;
    }

    public Collection<SAMReaderID> getSAMReaderIDs() {
        return this.readers;
    }

    public SAMFileHeader getHeader() {
        return this.header;
    }

    public SAMFileReader.ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    public Integer getReadBufferSize() {
        return this.readBufferSize;
    }

    public DownsamplingMethod getDownsamplingMethod() {
        return this.downsamplingMethod;
    }

    public ValidationExclusion getValidationExclusionList() {
        return this.exclusionList;
    }

    public Collection<ReadFilter> getSupplementalFilters() {
        return this.supplementalFilters;
    }

    public boolean useOriginalBaseQualities() {
        return this.useOriginalBaseQualities;
    }

    public BAQ.QualityMode getBAQQualityMode() {
        return this.qmode;
    }

    public BAQ.CalculationMode getBAQCalculationMode() {
        return this.cmode;
    }

    public IndexedFastaSequenceFile getRefReader() {
        return this.refReader;
    }

    public byte defaultBaseQualities() {
        return this.defaultBaseQualities;
    }

    public ReadProperties(Collection<SAMReaderID> samFiles, SAMFileHeader header, boolean useOriginalBaseQualities, SAMFileReader.ValidationStringency strictness, Integer readBufferSize, DownsamplingMethod downsamplingMethod, ValidationExclusion exclusionList, Collection<ReadFilter> supplementalFilters, boolean includeReadsWithDeletionAtLoci, boolean generateExtendedEvents, BAQ.CalculationMode cmode, BAQ.QualityMode qmode, IndexedFastaSequenceFile refReader, byte defaultBaseQualities) {
        this.readers = samFiles;
        this.header = header;
        this.readBufferSize = readBufferSize;
        this.validationStringency = strictness;
        this.downsamplingMethod = downsamplingMethod == null ? DownsamplingMethod.NONE : downsamplingMethod;
        this.exclusionList = exclusionList == null ? new ValidationExclusion() : exclusionList;
        this.supplementalFilters = supplementalFilters;
        this.includeReadsWithDeletionAtLoci = includeReadsWithDeletionAtLoci;
        this.generateExtendedEvents = generateExtendedEvents;
        this.useOriginalBaseQualities = useOriginalBaseQualities;
        this.cmode = cmode;
        this.qmode = qmode;
        this.refReader = refReader;
        this.defaultBaseQualities = defaultBaseQualities;
    }
}

