/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import net.sf.samtools.SAMBinaryTagAndValue;
import net.sf.samtools.SAMFileWriterImpl;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMTagUtil;
import net.sf.samtools.TextTagCodec;
import net.sf.samtools.util.AsciiWriter;
import net.sf.samtools.util.RuntimeIOException;

public class SAMTextWriter
extends SAMFileWriterImpl {
    private static final String FIELD_SEPARATOR = "\t";
    private final Writer out;
    private final File file;
    private final TextTagCodec tagCodec = new TextTagCodec();
    private final SAMTagUtil tagUtil = new SAMTagUtil();

    public SAMTextWriter(File file) {
        try {
            this.file = file;
            this.out = new AsciiWriter(new FileOutputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public SAMTextWriter(OutputStream stream) {
        this.file = null;
        this.out = new AsciiWriter(stream);
    }

    @Override
    public void writeAlignment(SAMRecord alignment) {
        try {
            this.out.write(alignment.getReadName());
            this.out.write(FIELD_SEPARATOR);
            this.out.write(Integer.toString(alignment.getFlags()));
            this.out.write(FIELD_SEPARATOR);
            this.out.write(alignment.getReferenceName());
            this.out.write(FIELD_SEPARATOR);
            this.out.write(Integer.toString(alignment.getAlignmentStart()));
            this.out.write(FIELD_SEPARATOR);
            this.out.write(Integer.toString(alignment.getMappingQuality()));
            this.out.write(FIELD_SEPARATOR);
            this.out.write(alignment.getCigarString());
            this.out.write(FIELD_SEPARATOR);
            if (alignment.getReferenceName() == alignment.getMateReferenceName() && "*" != alignment.getReferenceName()) {
                this.out.write("=");
            } else {
                this.out.write(alignment.getMateReferenceName());
            }
            this.out.write(FIELD_SEPARATOR);
            this.out.write(Integer.toString(alignment.getMateAlignmentStart()));
            this.out.write(FIELD_SEPARATOR);
            this.out.write(Integer.toString(alignment.getInferredInsertSize()));
            this.out.write(FIELD_SEPARATOR);
            this.out.write(alignment.getReadString());
            this.out.write(FIELD_SEPARATOR);
            this.out.write(alignment.getBaseQualityString());
            for (SAMBinaryTagAndValue attribute = alignment.getBinaryAttributes(); attribute != null; attribute = attribute.getNext()) {
                this.out.write(FIELD_SEPARATOR);
                String encodedTag = attribute.isUnsignedArray() ? this.tagCodec.encodeUnsignedArray(this.tagUtil.makeStringTag(attribute.tag), attribute.value) : this.tagCodec.encode(this.tagUtil.makeStringTag(attribute.tag), attribute.value);
                this.out.write(encodedTag);
            }
            this.out.write("\n");
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void writeHeader(String textHeader) {
        try {
            this.out.write(textHeader);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void finish() {
        try {
            this.out.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public String getFilename() {
        if (this.file == null) {
            return null;
        }
        return this.file.getAbsolutePath();
    }
}

