/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.samtools.BAMFileSpan;
import net.sf.samtools.Chunk;
import net.sf.samtools.GATKChunk;

public class GATKBAMFileSpan
extends BAMFileSpan {
    public GATKBAMFileSpan() {
    }

    public GATKBAMFileSpan(Chunk chunk) {
        super(chunk);
    }

    public GATKBAMFileSpan(GATKChunk[] chunks) {
        super(Arrays.asList(chunks));
    }

    public boolean equals(Object other) {
        if (!(other instanceof BAMFileSpan)) {
            return false;
        }
        List<Chunk> theseChunks = this.getChunks();
        List<Chunk> otherChunks = ((BAMFileSpan)other).getChunks();
        if (theseChunks.size() != otherChunks.size()) {
            return false;
        }
        for (int i = 0; i < theseChunks.size(); ++i) {
            if (theseChunks.get(i).equals(otherChunks.get(i))) continue;
            return false;
        }
        return true;
    }

    public List<GATKChunk> getGATKChunks() {
        ArrayList<GATKChunk> gatkChunks = new ArrayList<GATKChunk>();
        for (Chunk chunk : this.getChunks()) {
            gatkChunks.add(new GATKChunk(chunk));
        }
        return gatkChunks;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (GATKChunk chunk : this.getGATKChunks()) {
            builder.append(String.format("%s;", chunk));
        }
        return builder.toString();
    }

    public long size() {
        long size = 0L;
        for (GATKChunk chunk : this.getGATKChunks()) {
            size += chunk.size();
        }
        return size;
    }

    public GATKBAMFileSpan union(GATKBAMFileSpan other) {
        if (this.getGATKChunks().size() == 0 && other.getGATKChunks().size() == 0) {
            return new GATKBAMFileSpan();
        }
        LinkedList<GATKChunk> unmergedUnion = new LinkedList<GATKChunk>();
        unmergedUnion.addAll(this.getGATKChunks());
        unmergedUnion.addAll(other.getGATKChunks());
        Collections.sort(unmergedUnion);
        ArrayList<GATKChunk> mergedUnion = new ArrayList<GATKChunk>();
        GATKChunk currentChunk = (GATKChunk)unmergedUnion.remove();
        while (!unmergedUnion.isEmpty()) {
            while (!unmergedUnion.isEmpty() && currentChunk.getChunkEnd() >= ((GATKChunk)unmergedUnion.peek()).getChunkStart()) {
                GATKChunk nextChunk = (GATKChunk)unmergedUnion.remove();
                currentChunk = new GATKChunk(currentChunk.getChunkStart(), nextChunk.getChunkEnd());
            }
            mergedUnion.add(currentChunk);
            currentChunk = !unmergedUnion.isEmpty() ? (GATKChunk)unmergedUnion.remove() : null;
        }
        if (currentChunk != null) {
            mergedUnion.add(currentChunk);
        }
        return new GATKBAMFileSpan(mergedUnion.toArray(new GATKChunk[mergedUnion.size()]));
    }

    public GATKBAMFileSpan intersection(GATKBAMFileSpan other) {
        Iterator<GATKChunk> thisIterator = this.getGATKChunks().iterator();
        Iterator<GATKChunk> otherIterator = other.getGATKChunks().iterator();
        if (!thisIterator.hasNext() || !otherIterator.hasNext()) {
            return new GATKBAMFileSpan();
        }
        GATKChunk thisChunk = thisIterator.next();
        GATKChunk otherChunk = otherIterator.next();
        ArrayList<GATKChunk> intersected = new ArrayList<GATKChunk>();
        while (thisChunk != null && otherChunk != null) {
            if (thisChunk.getChunkEnd() <= otherChunk.getChunkStart()) {
                thisChunk = thisIterator.hasNext() ? thisIterator.next() : null;
                continue;
            }
            if (thisChunk.getChunkStart() >= otherChunk.getChunkEnd()) {
                otherChunk = otherIterator.hasNext() ? otherIterator.next() : null;
                continue;
            }
            if (!thisChunk.overlaps(otherChunk)) continue;
            GATKChunk firstChunk = thisChunk.getChunkStart() < otherChunk.getChunkStart() ? thisChunk : otherChunk;
            GATKChunk secondChunk = thisChunk == firstChunk ? otherChunk : thisChunk;
            GATKChunk intersectedChunk = new GATKChunk(secondChunk.getChunkStart(), Math.min(firstChunk.getChunkEnd(), secondChunk.getChunkEnd()));
            intersected.add(intersectedChunk);
            if (thisChunk.getChunkEnd() > intersectedChunk.getChunkEnd()) {
                thisChunk = new GATKChunk(intersectedChunk.getChunkEnd(), thisChunk.getChunkEnd());
            } else {
                GATKChunk gATKChunk = thisChunk = thisIterator.hasNext() ? thisIterator.next() : null;
            }
            if (otherChunk.getChunkEnd() > intersectedChunk.getChunkEnd()) {
                otherChunk = new GATKChunk(intersectedChunk.getChunkEnd(), otherChunk.getChunkEnd());
                continue;
            }
            otherChunk = otherIterator.hasNext() ? otherIterator.next() : null;
        }
        return new GATKBAMFileSpan(intersected.toArray(new GATKChunk[intersected.size()]));
    }

    public GATKBAMFileSpan minus(GATKBAMFileSpan other) {
        Iterator<GATKChunk> thisIterator = this.getGATKChunks().iterator();
        Iterator<GATKChunk> otherIterator = other.getGATKChunks().iterator();
        if (!thisIterator.hasNext() || !otherIterator.hasNext()) {
            return this;
        }
        GATKChunk thisChunk = thisIterator.next();
        GATKChunk otherChunk = otherIterator.next();
        ArrayList<GATKChunk> subtracted = new ArrayList<GATKChunk>();
        while (thisChunk != null && otherChunk != null) {
            if (thisChunk.getChunkEnd() <= otherChunk.getChunkStart()) {
                subtracted.add(thisChunk);
                thisChunk = thisIterator.hasNext() ? thisIterator.next() : null;
                continue;
            }
            if (thisChunk.getChunkStart() >= otherChunk.getChunkEnd()) {
                otherChunk = otherIterator.hasNext() ? otherIterator.next() : null;
                continue;
            }
            if (!thisChunk.overlaps(otherChunk)) continue;
            if (thisChunk.getChunkStart() < otherChunk.getChunkStart()) {
                subtracted.add(new GATKChunk(thisChunk.getChunkStart(), otherChunk.getChunkStart()));
            }
            if (thisChunk.getChunkEnd() > otherChunk.getChunkEnd()) {
                thisChunk = new GATKChunk(otherChunk.getChunkEnd(), thisChunk.getChunkEnd());
                continue;
            }
            thisChunk = thisIterator.hasNext() ? thisIterator.next() : null;
        }
        if (thisChunk != null) {
            subtracted.add(thisChunk);
        }
        while (thisIterator.hasNext()) {
            subtracted.add(thisIterator.next());
        }
        return new GATKBAMFileSpan(subtracted.toArray(new GATKChunk[subtracted.size()]));
    }
}

