/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.AlignmentBlock;
import net.sf.samtools.Cigar;
import net.sf.samtools.SAMBinaryTagAndValue;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileSource;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMValidationError;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.sam.GATKSAMReadGroupRecord;

public class GATKSAMRecord
extends SAMRecord {
    private final SAMRecord mRecord;
    private String mReadString = null;
    private SAMReadGroupRecord mReadGroup = null;
    private boolean mNegativeStrandFlag;
    private boolean mUnmappedFlag;
    private Boolean mSecondOfPairFlag = null;
    private boolean retrievedReadGroup = false;
    private boolean lookedUpReducedReadQuality = false;
    private Integer reducedReadQuality;
    private Map<Object, Object> temporaryAttributes;

    public GATKSAMRecord(SAMRecord record, boolean useOriginalBaseQualities, byte defaultBaseQualities) {
        super(null);
        byte[] originalQuals;
        if (record == null) {
            throw new IllegalArgumentException("The SAMRecord argument cannot be null");
        }
        this.mRecord = record;
        this.mNegativeStrandFlag = this.mRecord.getReadNegativeStrandFlag();
        this.mUnmappedFlag = this.mRecord.getReadUnmappedFlag();
        List<SAMRecord.SAMTagAndValue> attributes = record.getAttributes();
        for (SAMRecord.SAMTagAndValue attribute : attributes) {
            this.setAttribute(attribute.tag, attribute.value);
        }
        if (defaultBaseQualities >= 0) {
            byte[] reads = record.getReadBases();
            byte[] quals = record.getBaseQualities();
            if (quals == null || quals.length < reads.length) {
                byte[] new_quals = new byte[reads.length];
                for (int i = 0; i < reads.length; ++i) {
                    new_quals[i] = defaultBaseQualities;
                }
                record.setBaseQualities(new_quals);
            }
        }
        if (useOriginalBaseQualities && (originalQuals = this.mRecord.getOriginalBaseQualities()) != null) {
            this.mRecord.setBaseQualities(originalQuals);
        }
        if (this.getBaseQualities().length != this.getReadLength()) {
            throw new UserException.MalformedBAM(this, String.format("Error: the number of base qualities does not match the number of bases in %s.", this.mRecord.getReadName()));
        }
    }

    @Override
    public String getReadString() {
        if (this.mReadString == null) {
            this.mReadString = this.mRecord.getReadString();
        }
        return this.mReadString;
    }

    @Override
    public void setReadString(String s) {
        this.mRecord.setReadString(s);
        this.mReadString = s;
    }

    @Override
    public SAMReadGroupRecord getReadGroup() {
        if (!this.retrievedReadGroup) {
            SAMReadGroupRecord tempReadGroup = this.mRecord.getReadGroup();
            this.mReadGroup = tempReadGroup == null ? tempReadGroup : new GATKSAMReadGroupRecord(tempReadGroup);
            this.retrievedReadGroup = true;
        }
        return this.mReadGroup;
    }

    public void setReadGroup(SAMReadGroupRecord record) {
        this.mReadGroup = record;
    }

    @Override
    public boolean getReadUnmappedFlag() {
        return this.mUnmappedFlag;
    }

    @Override
    public void setReadUnmappedFlag(boolean b) {
        this.mRecord.setReadUnmappedFlag(b);
        this.mUnmappedFlag = b;
    }

    @Override
    public boolean getReadNegativeStrandFlag() {
        return this.mNegativeStrandFlag;
    }

    @Override
    public void setReadNegativeStrandFlag(boolean b) {
        this.mRecord.setReadNegativeStrandFlag(b);
        this.mNegativeStrandFlag = b;
    }

    @Override
    public boolean getSecondOfPairFlag() {
        if (this.mSecondOfPairFlag == null) {
            this.mSecondOfPairFlag = this.mRecord.getSecondOfPairFlag();
        }
        return this.mSecondOfPairFlag;
    }

    @Override
    public void setSecondOfPairFlag(boolean b) {
        this.mRecord.setSecondOfPairFlag(b);
        this.mSecondOfPairFlag = b;
    }

    public boolean containsTemporaryAttribute(Object key) {
        if (this.temporaryAttributes != null) {
            return this.temporaryAttributes.containsKey(key);
        }
        return false;
    }

    public Object setTemporaryAttribute(Object key, Object value) {
        if (this.temporaryAttributes == null) {
            this.temporaryAttributes = new HashMap<Object, Object>();
        }
        return this.temporaryAttributes.put(key, value);
    }

    public Object getTemporaryAttribute(Object key) {
        if (this.temporaryAttributes != null) {
            return this.temporaryAttributes.get(key);
        }
        return null;
    }

    public Object removeTemporaryAttribute(Object key) {
        if (this.temporaryAttributes != null) {
            return this.temporaryAttributes.remove(key);
        }
        return null;
    }

    @Override
    public String getReadName() {
        return this.mRecord.getReadName();
    }

    @Override
    public int getReadNameLength() {
        return this.mRecord.getReadNameLength();
    }

    @Override
    public void setReadName(String s) {
        this.mRecord.setReadName(s);
    }

    @Override
    public byte[] getReadBases() {
        return this.mRecord.getReadBases();
    }

    @Override
    public void setReadBases(byte[] bytes) {
        this.mRecord.setReadBases(bytes);
    }

    @Override
    public int getReadLength() {
        return this.mRecord.getReadLength();
    }

    @Override
    public byte[] getBaseQualities() {
        return this.mRecord.getBaseQualities();
    }

    @Override
    public void setBaseQualities(byte[] bytes) {
        this.mRecord.setBaseQualities(bytes);
    }

    @Override
    public String getBaseQualityString() {
        return this.mRecord.getBaseQualityString();
    }

    @Override
    public void setBaseQualityString(String s) {
        this.mRecord.setBaseQualityString(s);
    }

    @Override
    public byte[] getOriginalBaseQualities() {
        return this.mRecord.getOriginalBaseQualities();
    }

    @Override
    public void setOriginalBaseQualities(byte[] bytes) {
        this.mRecord.setOriginalBaseQualities(bytes);
    }

    @Override
    public String getReferenceName() {
        return this.mRecord.getReferenceName();
    }

    @Override
    public void setReferenceName(String s) {
        this.mRecord.setReferenceName(s);
    }

    @Override
    public Integer getReferenceIndex() {
        return this.mRecord.getReferenceIndex();
    }

    @Override
    public void setReferenceIndex(int i) {
        this.mRecord.setReferenceIndex(i);
    }

    @Override
    public String getMateReferenceName() {
        return this.mRecord.getMateReferenceName();
    }

    @Override
    public void setMateReferenceName(String s) {
        this.mRecord.setMateReferenceName(s);
    }

    @Override
    public Integer getMateReferenceIndex() {
        return this.mRecord.getMateReferenceIndex();
    }

    @Override
    public void setMateReferenceIndex(int i) {
        this.mRecord.setMateReferenceIndex(i);
    }

    @Override
    public int getAlignmentStart() {
        return this.mRecord.getAlignmentStart();
    }

    @Override
    public void setAlignmentStart(int i) {
        this.mRecord.setAlignmentStart(i);
    }

    @Override
    public int getAlignmentEnd() {
        return this.mRecord.getAlignmentEnd();
    }

    @Override
    public int getUnclippedStart() {
        return this.mRecord.getUnclippedStart();
    }

    @Override
    public int getUnclippedEnd() {
        return this.mRecord.getUnclippedEnd();
    }

    @Override
    public void setAlignmentEnd(int i) {
        this.mRecord.setAlignmentEnd(i);
    }

    @Override
    public int getMateAlignmentStart() {
        return this.mRecord.getMateAlignmentStart();
    }

    @Override
    public void setMateAlignmentStart(int i) {
        this.mRecord.setMateAlignmentStart(i);
    }

    @Override
    public int getInferredInsertSize() {
        return this.mRecord.getInferredInsertSize();
    }

    @Override
    public void setInferredInsertSize(int i) {
        this.mRecord.setInferredInsertSize(i);
    }

    @Override
    public int getMappingQuality() {
        return this.mRecord.getMappingQuality();
    }

    @Override
    public void setMappingQuality(int i) {
        this.mRecord.setMappingQuality(i);
    }

    @Override
    public String getCigarString() {
        return this.mRecord.getCigarString();
    }

    @Override
    public void setCigarString(String s) {
        this.mRecord.setCigarString(s);
    }

    @Override
    public Cigar getCigar() {
        return this.mRecord.getCigar();
    }

    @Override
    public int getCigarLength() {
        return this.mRecord.getCigarLength();
    }

    @Override
    public void setCigar(Cigar cigar) {
        this.mRecord.setCigar(cigar);
    }

    @Override
    public int getFlags() {
        return this.mRecord.getFlags();
    }

    @Override
    public void setFlags(int i) {
        this.mRecord.setFlags(i);
    }

    @Override
    public boolean getReadPairedFlag() {
        return this.mRecord.getReadPairedFlag();
    }

    @Override
    public boolean getProperPairFlag() {
        return this.mRecord.getProperPairFlag();
    }

    @Override
    public boolean getMateUnmappedFlag() {
        return this.mRecord.getMateUnmappedFlag();
    }

    @Override
    public boolean getMateNegativeStrandFlag() {
        return this.mRecord.getMateNegativeStrandFlag();
    }

    @Override
    public boolean getFirstOfPairFlag() {
        return this.mRecord.getFirstOfPairFlag();
    }

    @Override
    public boolean getNotPrimaryAlignmentFlag() {
        return this.mRecord.getNotPrimaryAlignmentFlag();
    }

    @Override
    public boolean getReadFailsVendorQualityCheckFlag() {
        return this.mRecord.getReadFailsVendorQualityCheckFlag();
    }

    @Override
    public boolean getDuplicateReadFlag() {
        return this.mRecord.getDuplicateReadFlag();
    }

    @Override
    public void setReadPairedFlag(boolean b) {
        this.mRecord.setReadPairedFlag(b);
    }

    @Override
    public void setProperPairFlag(boolean b) {
        this.mRecord.setProperPairFlag(b);
    }

    @Override
    public void setMateUnmappedFlag(boolean b) {
        this.mRecord.setMateUnmappedFlag(b);
    }

    @Override
    public void setMateNegativeStrandFlag(boolean b) {
        this.mRecord.setMateNegativeStrandFlag(b);
    }

    @Override
    public void setFirstOfPairFlag(boolean b) {
        this.mRecord.setFirstOfPairFlag(b);
    }

    @Override
    public void setNotPrimaryAlignmentFlag(boolean b) {
        this.mRecord.setNotPrimaryAlignmentFlag(b);
    }

    @Override
    public void setReadFailsVendorQualityCheckFlag(boolean b) {
        this.mRecord.setReadFailsVendorQualityCheckFlag(b);
    }

    @Override
    public void setDuplicateReadFlag(boolean b) {
        this.mRecord.setDuplicateReadFlag(b);
    }

    @Override
    public SAMFileReader.ValidationStringency getValidationStringency() {
        return this.mRecord.getValidationStringency();
    }

    @Override
    public void setValidationStringency(SAMFileReader.ValidationStringency validationStringency) {
        this.mRecord.setValidationStringency(validationStringency);
    }

    @Override
    public Object getAttribute(String tag) {
        return this.mRecord.getAttribute(tag);
    }

    @Override
    public Integer getIntegerAttribute(String tag) {
        if (tag == "RQ") {
            if (!this.lookedUpReducedReadQuality) {
                this.lookedUpReducedReadQuality = true;
                this.reducedReadQuality = this.mRecord.getIntegerAttribute(tag);
            }
            return this.reducedReadQuality;
        }
        return this.mRecord.getIntegerAttribute(tag);
    }

    @Override
    public Short getShortAttribute(String tag) {
        return this.mRecord.getShortAttribute(tag);
    }

    @Override
    public Byte getByteAttribute(String tag) {
        return this.mRecord.getByteAttribute(tag);
    }

    @Override
    public String getStringAttribute(String tag) {
        return this.mRecord.getStringAttribute(tag);
    }

    @Override
    public Character getCharacterAttribute(String tag) {
        return this.mRecord.getCharacterAttribute(tag);
    }

    @Override
    public Float getFloatAttribute(String tag) {
        return this.mRecord.getFloatAttribute(tag);
    }

    @Override
    public byte[] getByteArrayAttribute(String tag) {
        return this.mRecord.getByteArrayAttribute(tag);
    }

    @Override
    protected Object getAttribute(short tag) {
        Object attribute;
        try {
            Method method = this.mRecord.getClass().getDeclaredMethod("getAttribute", Short.TYPE);
            method.setAccessible(true);
            attribute = method.invoke((Object)this.mRecord, tag);
        }
        catch (Exception ex) {
            throw new ReviewedStingException("Unable to invoke getAttribute method", ex);
        }
        return attribute;
    }

    @Override
    public void setAttribute(String tag, Object value) {
        this.mRecord.setAttribute(tag, value);
    }

    @Override
    protected void setAttribute(short tag, Object value) {
        try {
            Method method = this.mRecord.getClass().getDeclaredMethod("setAttribute", Short.TYPE, Object.class);
            method.setAccessible(true);
            method.invoke((Object)this.mRecord, tag, value);
        }
        catch (Exception ex) {
            throw new ReviewedStingException("Unable to invoke setAttribute method", ex);
        }
    }

    @Override
    public void clearAttributes() {
        this.mRecord.clearAttributes();
    }

    @Override
    protected void setAttributes(SAMBinaryTagAndValue attributes) {
        try {
            Method method = this.mRecord.getClass().getDeclaredMethod("setAttributes", SAMBinaryTagAndValue.class);
            method.setAccessible(true);
            method.invoke((Object)this.mRecord, attributes);
        }
        catch (Exception ex) {
            throw new ReviewedStingException("Unable to invoke setAttributes method", ex);
        }
    }

    @Override
    protected SAMBinaryTagAndValue getBinaryAttributes() {
        SAMBinaryTagAndValue binaryAttributes;
        try {
            Method method = this.mRecord.getClass().getDeclaredMethod("getBinaryAttributes", new Class[0]);
            method.setAccessible(true);
            binaryAttributes = (SAMBinaryTagAndValue)method.invoke((Object)this.mRecord, new Object[0]);
        }
        catch (Exception ex) {
            throw new ReviewedStingException("Unable to invoke getBinaryAttributes method", ex);
        }
        return binaryAttributes;
    }

    @Override
    public List<SAMRecord.SAMTagAndValue> getAttributes() {
        return this.mRecord.getAttributes();
    }

    @Override
    public SAMFileHeader getHeader() {
        return this.mRecord.getHeader();
    }

    @Override
    public void setHeader(SAMFileHeader samFileHeader) {
        this.mRecord.setHeader(samFileHeader);
    }

    @Override
    public byte[] getVariableBinaryRepresentation() {
        return this.mRecord.getVariableBinaryRepresentation();
    }

    @Override
    public int getAttributesBinarySize() {
        return this.mRecord.getAttributesBinarySize();
    }

    @Override
    public String format() {
        return this.mRecord.format();
    }

    @Override
    public List<AlignmentBlock> getAlignmentBlocks() {
        return this.mRecord.getAlignmentBlocks();
    }

    @Override
    public List<SAMValidationError> validateCigar(long l) {
        return this.mRecord.validateCigar(l);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GATKSAMRecord)) {
            return false;
        }
        return this.mRecord.equals(((GATKSAMRecord)o).mRecord);
    }

    @Override
    public int hashCode() {
        return this.mRecord.hashCode();
    }

    @Override
    public List<SAMValidationError> isValid() {
        return this.mRecord.isValid();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.mRecord.clone();
    }

    @Override
    public String toString() {
        return this.mRecord.toString();
    }

    @Override
    public SAMFileSource getFileSource() {
        return this.mRecord.getFileSource();
    }

    @Override
    protected void setFileSource(SAMFileSource fileSource) {
        try {
            Method method = SAMRecord.class.getDeclaredMethod("setFileSource", SAMFileSource.class);
            method.setAccessible(true);
            method.invoke((Object)this.mRecord, fileSource);
        }
        catch (Exception ex) {
            throw new ReviewedStingException("Unable to invoke setFileSource method", ex);
        }
    }
}

