/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pileup;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.utils.BaseUtils;

public class PileupElement {
    public static final byte DELETION_BASE = 68;
    public static final byte DELETION_QUAL = 16;
    public static final byte A_FOLLOWED_BY_INSERTION_BASE = 87;
    public static final byte C_FOLLOWED_BY_INSERTION_BASE = 88;
    public static final byte T_FOLLOWED_BY_INSERTION_BASE = 89;
    public static final byte G_FOLLOWED_BY_INSERTION_BASE = 90;
    protected final SAMRecord read;
    protected final int offset;

    @Requires(value={"read != null", "offset >= -1", "offset <= read.getReadLength()"})
    public PileupElement(SAMRecord read, int offset) {
        this.read = read;
        this.offset = offset;
    }

    public boolean isDeletion() {
        return this.offset == -1;
    }

    @Ensures(value={"result != null"})
    public SAMRecord getRead() {
        return this.read;
    }

    @Ensures(value={"result == offset"})
    public int getOffset() {
        return this.offset;
    }

    public byte getBase() {
        return this.getBase(this.offset);
    }

    public int getBaseIndex() {
        return this.getBaseIndex(this.offset);
    }

    public byte getQual() {
        return this.getQual(this.offset);
    }

    public int getMappingQual() {
        return this.read.getMappingQuality();
    }

    @Ensures(value={"result != null"})
    public String toString() {
        return String.format("%s @ %d = %c Q%d", this.getRead().getReadName(), this.getOffset(), Character.valueOf((char)this.getBase()), this.getQual());
    }

    protected byte getBase(int offset) {
        return this.isDeletion() ? (byte)68 : this.read.getReadBases()[offset];
    }

    protected int getBaseIndex(int offset) {
        return BaseUtils.simpleBaseToBaseIndex(this.isDeletion() ? (byte)68 : this.read.getReadBases()[offset]);
    }

    protected byte getQual(int offset) {
        return this.isDeletion() ? (byte)16 : this.read.getBaseQualities()[offset];
    }

    private Integer getReducedReadQualityTagValue() {
        return this.getRead().getIntegerAttribute("RQ");
    }

    public boolean isReducedRead() {
        return this.getReducedReadQualityTagValue() != null;
    }

    public int getReducedCount() {
        return this.getQual();
    }

    public byte getReducedQual() {
        return (byte)this.getReducedReadQualityTagValue().intValue();
    }
}

