/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.interval;

import java.util.Iterator;
import java.util.PriorityQueue;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.interval.IntervalMergingRule;

public class NwayIntervalMergingIterator
implements Iterator<GenomeLoc>,
Iterable<GenomeLoc> {
    private PriorityQueue<Element> queue = null;
    private IntervalMergingRule myRule;

    public NwayIntervalMergingIterator(IntervalMergingRule rule) {
        this.myRule = rule;
        this.queue = new PriorityQueue();
    }

    public void add(Iterator<GenomeLoc> it) {
        Element e = new Element(it);
        if (!e.isEmpty()) {
            this.queue.add(e);
        }
    }

    @Override
    public Iterator<GenomeLoc> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public GenomeLoc next() {
        Element e = this.queue.poll();
        GenomeLoc result = e.current;
        e.advance();
        if (!e.isEmpty()) {
            this.queue.add(e);
        }
        while (!this.queue.isEmpty() && (result.overlapsP((e = this.queue.peek()).current) || this.myRule == IntervalMergingRule.ALL && result.contiguousP(e.current))) {
            result = result.merge(e.current);
            e = this.queue.poll();
            e.advance();
            if (e.isEmpty()) continue;
            this.queue.add(e);
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() method not supported by this iterator");
    }

    private class Element
    implements Comparable<Element> {
        private Iterator<GenomeLoc> it;
        private GenomeLoc current = null;

        private void advance() {
            if (this.it.hasNext()) {
                GenomeLoc next = this.it.next();
                if (next.isBefore(this.current)) {
                    throw new UserException("Interval list provided by underlying iterator " + this.it.getClass().getName() + " is out of order");
                }
                this.current = next;
            } else {
                this.current = null;
            }
        }

        public boolean isEmpty() {
            return this.current == null;
        }

        public Element(Iterator<GenomeLoc> it) {
            this.it = it;
            if (this.it.hasNext()) {
                this.current = this.it.next();
            }
        }

        @Override
        public int compareTo(Element o) {
            if (this.current == null) {
                return 1;
            }
            if (o.current == null) {
                return -1;
            }
            return this.current.compareTo(o.current);
        }
    }
}

