/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMReadGroupRecord;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.text.XReadLines;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class SampleUtils {
    private SampleUtils() {
    }

    public static Set<String> getSAMFileSamples(SAMFileHeader header) {
        TreeSet<String> samples = new TreeSet<String>();
        List<SAMReadGroupRecord> readGroups = header.getReadGroups();
        for (SAMReadGroupRecord readGroup : readGroups) {
            samples.add(readGroup.getSample());
        }
        return samples;
    }

    public static Set<String> getUniqueSamplesFromRods(GenomeAnalysisEngine toolkit) {
        return SampleUtils.getUniqueSamplesFromRods(toolkit, null);
    }

    public static Set<String> getUniqueSamplesFromRods(GenomeAnalysisEngine toolkit, Collection<String> rodNames) {
        LinkedHashSet<String> samples = new LinkedHashSet<String>();
        for (VCFHeader header : VCFUtils.getVCFHeadersFromRods(toolkit, rodNames).values()) {
            samples.addAll(header.getGenotypeSamples());
        }
        return samples;
    }

    public static Set<String> getRodNamesWithVCFHeader(GenomeAnalysisEngine toolkit, Collection<String> rodNames) {
        return VCFUtils.getVCFHeadersFromRods(toolkit, rodNames).keySet();
    }

    public static Set<String> getSampleListWithVCFHeader(GenomeAnalysisEngine toolkit, Collection<String> rodNames) {
        return SampleUtils.getSampleList(VCFUtils.getVCFHeadersFromRods(toolkit, rodNames));
    }

    public static Set<String> getSampleList(Map<String, VCFHeader> headers) {
        return SampleUtils.getSampleList(headers, VariantContextUtils.GenotypeMergeType.PRIORITIZE);
    }

    public static Set<String> getSampleList(Map<String, VCFHeader> headers, VariantContextUtils.GenotypeMergeType mergeOption) {
        TreeSet<String> samples = new TreeSet<String>();
        for (Map.Entry<String, VCFHeader> val : headers.entrySet()) {
            VCFHeader header = val.getValue();
            for (String sample : header.getGenotypeSamples()) {
                samples.add(VariantContextUtils.mergedSampleName(val.getKey(), sample, mergeOption == VariantContextUtils.GenotypeMergeType.UNIQUIFY));
            }
        }
        return samples;
    }

    public static void getUniquifiedSamplesFromRods(GenomeAnalysisEngine toolkit, Set<String> samples, Map<Pair<String, String>, String> rodNamesToSampleNames) {
        HashMap<String, Integer> sampleOverlapMap = new HashMap<String, Integer>();
        for (Map.Entry<String, VCFHeader> pair : VCFUtils.getVCFHeadersFromRods(toolkit, null).entrySet()) {
            Set<String> vcfSamples = pair.getValue().getGenotypeSamples();
            for (String sample : vcfSamples) {
                SampleUtils.addUniqueSample(samples, sampleOverlapMap, rodNamesToSampleNames, sample, pair.getKey());
            }
        }
    }

    private static void addUniqueSample(Set<String> samples, Map<String, Integer> sampleOverlapMap, Map<Pair<String, String>, String> rodNamesToSampleNames, String newSample, String rodName) {
        Integer occurrences = sampleOverlapMap.get(newSample);
        if (occurrences == null) {
            samples.add(newSample);
            rodNamesToSampleNames.put(new Pair<String, String>(rodName, newSample), newSample);
            sampleOverlapMap.put(newSample, 1);
        } else if (occurrences >= 2) {
            String uniqueName = newSample + "." + rodName;
            samples.add(uniqueName);
            rodNamesToSampleNames.put(new Pair<String, String>(rodName, newSample), uniqueName);
            sampleOverlapMap.put(newSample, occurrences + 1);
        } else {
            samples.remove(newSample);
            String uniqueName1 = null;
            for (Map.Entry<Pair<String, String>, String> entry : rodNamesToSampleNames.entrySet()) {
                if (!entry.getValue().equals(newSample)) continue;
                uniqueName1 = newSample + "." + (String)entry.getKey().first;
                entry.setValue(uniqueName1);
                break;
            }
            samples.add(uniqueName1);
            String uniqueName2 = newSample + "." + rodName;
            samples.add(uniqueName2);
            rodNamesToSampleNames.put(new Pair<String, String>(rodName, newSample), uniqueName2);
            sampleOverlapMap.put(newSample, 2);
        }
    }

    public static List<String> getSamplesFromCommandLineInput(Collection<String> sampleArgs) {
        if (sampleArgs != null) {
            ArrayList<String> samplesFromFiles = new ArrayList<String>();
            for (String SAMPLE_EXPRESSION : sampleArgs) {
                File sampleFile = new File(SAMPLE_EXPRESSION);
                try {
                    XReadLines reader = new XReadLines(sampleFile);
                    List<String> lines = reader.readLines();
                    for (String line : lines) {
                        samplesFromFiles.add(line);
                    }
                }
                catch (FileNotFoundException e) {
                    samplesFromFiles.add(SAMPLE_EXPRESSION);
                }
            }
            return samplesFromFiles;
        }
        return new ArrayList<String>();
    }

    public static Set<String> getSamplesFromCommandLineInput(Collection<String> vcfSamples, Collection<String> sampleExpressions) {
        HashSet<String> samples = new HashSet<String>();
        if (sampleExpressions != null) {
            HashSet<String> samplesFromFiles = new HashSet<String>();
            for (String sampleExpression : sampleExpressions) {
                File sampleFile = new File(sampleExpression);
                try {
                    XReadLines reader = new XReadLines(sampleFile);
                    List<String> lines = reader.readLines();
                    for (String line : lines) {
                        samplesFromFiles.add(line);
                    }
                }
                catch (FileNotFoundException e) {
                }
            }
            sampleExpressions.addAll(samplesFromFiles);
            HashSet<String> possibleSampleRegexs = new HashSet<String>();
            for (String sampleExpression : sampleExpressions) {
                if (new File(sampleExpression).exists()) continue;
                if (vcfSamples.contains(sampleExpression)) {
                    samples.add(sampleExpression);
                    continue;
                }
                possibleSampleRegexs.add(sampleExpression);
            }
            for (String sampleRegex : possibleSampleRegexs) {
                Pattern p = Pattern.compile(sampleRegex);
                for (String vcfSample : vcfSamples) {
                    Matcher m = p.matcher(vcfSample);
                    if (!m.find()) continue;
                    samples.add(vcfSample);
                }
            }
        } else {
            samples.addAll(vcfSamples);
        }
        return samples;
    }

    public static Collection<String> matchSamplesExpressions(Collection<String> originalSamples, Collection<String> sampleExpressions) {
        HashSet<String> samples = new HashSet<String>();
        if (sampleExpressions != null) {
            for (String expression : sampleExpressions) {
                Pattern p = Pattern.compile(expression);
                for (String originalSample : originalSamples) {
                    Matcher m = p.matcher(originalSample);
                    if (!m.find()) continue;
                    samples.add(originalSample);
                }
            }
        }
        return samples;
    }

    public static Collection<String> getSamplesFromFiles(Collection<File> files) {
        HashSet<String> samplesFromFiles = new HashSet<String>();
        if (files != null) {
            for (File file : files) {
                try {
                    XReadLines reader = new XReadLines(file);
                    List<String> lines = reader.readLines();
                    for (String line : lines) {
                        samplesFromFiles.add(line);
                    }
                }
                catch (FileNotFoundException e) {
                }
            }
        }
        return samplesFromFiles;
    }
}

