/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import java.util.ArrayList;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.VariantEvalWalker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.StandardEval;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.Degeneracy;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.Sample;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.StateKey;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.TableType;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

@Analysis(name="Quality Metrics by allele count", description="Shows various stats binned by allele count")
public class SimpleMetricsByAC
extends VariantEvaluator
implements StandardEval {
    @DataPoint(description="TiTv by allele count")
    MetricsByAc metrics = null;
    private static final Object[] METRIC_COLUMNS = new Object[]{"AC", "nTi", "nTv", "n", "TiTv"};
    private int numSamples;

    @Override
    public void initialize(VariantEvalWalker walker) {
        this.numSamples = walker.getNumSamples();
        this.metrics = new MetricsByAc(2 * this.numSamples);
    }

    public String getName() {
        return "SimpleMetricsByAC";
    }

    @Override
    public int getComparisonOrder() {
        return 1;
    }

    @Override
    public boolean enabled() {
        return true;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String update1(VariantContext eval, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (this.numSamples == 0) {
            return null;
        }
        String interesting = null;
        if (eval != null) {
            int nSamples;
            if (this.metrics == null && (nSamples = this.numSamples) != -1) {
                this.metrics = new MetricsByAc(2 * nSamples);
            }
            if (eval.isSNP() && eval.isBiallelic() && eval.isPolymorphic() && this.metrics != null) {
                this.metrics.incrValue(eval);
            }
        }
        return interesting;
    }

    @Override
    public boolean stateIsApplicable(StateKey stateKey) {
        String sampleClassName = Sample.class.getSimpleName();
        String degeneracyClassName = Degeneracy.class.getSimpleName();
        if (stateKey.containsKey(sampleClassName) && !((String)stateKey.get(sampleClassName)).equalsIgnoreCase("all")) {
            return false;
        }
        return !stateKey.containsKey(degeneracyClassName) || ((String)stateKey.get(degeneracyClassName)).equalsIgnoreCase("all");
    }

    class MetricsByAc
    implements TableType {
        ArrayList<MetricsAtAC> metrics = new ArrayList();
        Object[] rows = null;

        public MetricsByAc(int nchromosomes) {
            this.rows = new Object[nchromosomes + 1];
            this.metrics = new ArrayList(nchromosomes + 1);
            for (int i = 0; i < nchromosomes + 1; ++i) {
                this.metrics.add(new MetricsAtAC(i));
                this.rows[i] = "ac" + i;
            }
        }

        @Override
        public Object[] getRowKeys() {
            return this.rows;
        }

        @Override
        public Object[] getColumnKeys() {
            return METRIC_COLUMNS;
        }

        @Override
        public String getName() {
            return "MetricsByAc";
        }

        @Override
        public String getCell(int ac, int y) {
            return this.metrics.get(ac).getColumn(y);
        }

        public String toString() {
            return "";
        }

        public void incrValue(VariantContext eval) {
            int ac = -1;
            if (eval.hasGenotypes()) {
                ac = eval.getChromosomeCount(eval.getAlternateAllele(0));
            } else if (eval.hasAttribute("AC")) {
                ac = Integer.valueOf(eval.getAttributeAsString("AC"));
            }
            if (ac != -1) {
                this.metrics.get(ac).update(eval);
            }
        }
    }

    class MetricsAtAC {
        public int ac = -1;
        public int nTi = 0;
        public int nTv = 0;

        public MetricsAtAC(int ac) {
            this.ac = ac;
        }

        public void update(VariantContext eval) {
            if (VariantContextUtils.isTransition(eval)) {
                ++this.nTi;
            } else {
                ++this.nTv;
            }
        }

        public String getColumn(int i) {
            switch (i) {
                case 0: {
                    return String.valueOf(this.ac);
                }
                case 1: {
                    return String.valueOf(this.nTi);
                }
                case 2: {
                    return String.valueOf(this.nTv);
                }
                case 3: {
                    return String.valueOf(this.nTi + this.nTv);
                }
                case 4: {
                    return String.valueOf(SimpleMetricsByAC.this.ratio(this.nTi, this.nTv));
                }
            }
            throw new ReviewedStingException("Unexpected column " + i);
        }
    }
}

