/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.VariantEvalWalker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.utils.MendelianViolation;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@Analysis(name="Mendelian Violation Evaluator", description="Mendelian Violation Evaluator")
public class MendelianViolationEvaluator
extends VariantEvaluator {
    @DataPoint(description="Number of mendelian variants found")
    long nVariants;
    @DataPoint(description="Number of mendelian violations found")
    long nViolations;
    @DataPoint(description="number of child hom ref calls where the parent was hom variant")
    long KidHomRef_ParentHomVar;
    @DataPoint(description="number of child het calls where the parent was hom ref")
    long KidHet_ParentsHomRef;
    @DataPoint(description="number of child het calls where the parent was hom variant")
    long KidHet_ParentsHomVar;
    @DataPoint(description="number of child hom variant calls where the parent was hom ref")
    long KidHomVar_ParentHomRef;
    MendelianViolation mv;

    @Override
    public void initialize(VariantEvalWalker walker) {
        this.mv = new MendelianViolation(walker.getFamilyStructure(), walker.getMendelianViolationQualThreshold());
    }

    @Override
    public boolean enabled() {
        return true;
    }

    public String getName() {
        return "mendelian_violations";
    }

    @Override
    public int getComparisonOrder() {
        return 1;
    }

    @Override
    public String update1(VariantContext vc, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (vc.isBiallelic() && vc.hasGenotypes() && this.mv.setAlleles(vc)) {
            ++this.nVariants;
            Genotype momG = vc.getGenotype(this.mv.getSampleMom());
            Genotype dadG = vc.getGenotype(this.mv.getSampleDad());
            Genotype childG = vc.getGenotype(this.mv.getSampleChild());
            if (this.mv.isViolation()) {
                String label;
                ++this.nViolations;
                if (childG.isHomRef() && (momG.isHomVar() || dadG.isHomVar())) {
                    label = "KidHomRef_ParentHomVar";
                    ++this.KidHomRef_ParentHomVar;
                } else if (childG.isHet() && momG.isHomRef() && dadG.isHomRef()) {
                    label = "KidHet_ParentsHomRef";
                    ++this.KidHet_ParentsHomRef;
                } else if (childG.isHet() && momG.isHomVar() && dadG.isHomVar()) {
                    label = "KidHet_ParentsHomVar";
                    ++this.KidHet_ParentsHomVar;
                } else if (childG.isHomVar() && (momG.isHomRef() || dadG.isHomRef())) {
                    label = "KidHomVar_ParentHomRef";
                    ++this.KidHomVar_ParentHomRef;
                } else {
                    throw new ReviewedStingException("BUG: unexpected child genotype class " + childG);
                }
                return "MendelViolation=" + label;
            }
        }
        return null;
    }
}

