/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.phasing.AllelePair;
import org.broadinstitute.sting.gatk.walkers.varianteval.VariantEvalWalker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.CompEvalGenotypes;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.PhaseStats;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.SamplePhasingStatistics;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.SamplePreviousGenotypes;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.NewEvaluationContext;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@Analysis(name="Genotype Phasing Evaluation", description="Evaluates the phasing of genotypes in different tracks")
public class GenotypePhasingEvaluator
extends VariantEvaluator {
    protected static final Logger logger = Logger.getLogger(GenotypePhasingEvaluator.class);
    @DataPoint(description="the phasing statistics for each sample")
    SamplePhasingStatistics samplePhasingStatistics = null;
    SamplePreviousGenotypes samplePrevGenotypes = null;
    double minPhaseQuality = 10.0;

    @Override
    public void initialize(VariantEvalWalker walker) {
        this.samplePhasingStatistics = new SamplePhasingStatistics(walker.getMinPhaseQuality());
        this.samplePrevGenotypes = new SamplePreviousGenotypes();
    }

    public String getName() {
        return "GenotypePhasingEvaluator";
    }

    @Override
    public int getComparisonOrder() {
        return 2;
    }

    @Override
    public boolean enabled() {
        return true;
    }

    public String toString() {
        return this.getName() + ": <table>";
    }

    public String update2(VariantContext eval, VariantContext comp, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context, NewEvaluationContext group) {
        Reasons interesting = new Reasons();
        if (ref == null) {
            return interesting.toString();
        }
        GenomeLoc curLocus = ref.getLocus();
        logger.debug("update2() locus: " + curLocus);
        logger.debug("comp = " + comp + " eval = " + eval);
        HashSet<String> allSamples = new HashSet<String>();
        Map<String, Genotype> compSampGenotypes = null;
        if (GenotypePhasingEvaluator.isRelevantToPhasing(comp)) {
            allSamples.addAll(comp.getSampleNames());
            compSampGenotypes = comp.getGenotypes();
        }
        Map<String, Genotype> evalSampGenotypes = null;
        if (GenotypePhasingEvaluator.isRelevantToPhasing(eval)) {
            allSamples.addAll(eval.getSampleNames());
            evalSampGenotypes = eval.getGenotypes();
        }
        for (String samp : allSamples) {
            logger.debug("sample = " + samp);
            Genotype compSampGt = null;
            if (compSampGenotypes != null) {
                compSampGt = compSampGenotypes.get(samp);
            }
            Genotype evalSampGt = null;
            if (evalSampGenotypes != null) {
                evalSampGt = evalSampGenotypes.get(samp);
            }
            if (compSampGt == null || evalSampGt == null) {
                if (!this.isNonNullButUnphased(compSampGt) && !this.isNonNullButUnphased(evalSampGt)) continue;
                this.samplePrevGenotypes.put(samp, null);
                continue;
            }
            AllelePair compAllelePair = new AllelePair(compSampGt);
            AllelePair evalAllelePair = new AllelePair(evalSampGt);
            boolean breakPhasing = false;
            if (compSampGt.isHet() != evalSampGt.isHet() || compSampGt.isHom() != evalSampGt.isHom()) {
                breakPhasing = true;
            } else {
                boolean topMatchesBottomAndBottomMatchesTop;
                boolean topMatchesTopAndBottomMatchesBottom = GenotypePhasingEvaluator.topMatchesTop(compAllelePair, evalAllelePair) && GenotypePhasingEvaluator.bottomMatchesBottom(compAllelePair, evalAllelePair);
                boolean bl = topMatchesBottomAndBottomMatchesTop = GenotypePhasingEvaluator.topMatchesBottom(compAllelePair, evalAllelePair) && GenotypePhasingEvaluator.bottomMatchesTop(compAllelePair, evalAllelePair);
                if (!topMatchesTopAndBottomMatchesBottom && !topMatchesBottomAndBottomMatchesTop) {
                    breakPhasing = true;
                }
            }
            if (breakPhasing) {
                this.samplePrevGenotypes.put(samp, null);
                continue;
            }
            if (!compSampGt.isHet() || !evalSampGt.isHet()) continue;
            CompEvalGenotypes prevCompAndEval = this.samplePrevGenotypes.get(samp);
            if (prevCompAndEval != null && !prevCompAndEval.getLocus().onSameContig(curLocus)) {
                prevCompAndEval = null;
            }
            this.samplePrevGenotypes.put(samp, curLocus, compSampGt, evalSampGt);
            if (prevCompAndEval == null) continue;
            GenomeLoc prevLocus = prevCompAndEval.getLocus();
            logger.debug("Potentially phaseable het locus: " + curLocus + " [relative to previous het locus: " + prevLocus + "]");
            PhaseStats ps = this.samplePhasingStatistics.ensureSampleStats(samp);
            boolean compSampIsPhased = this.genotypesArePhasedAboveThreshold(compSampGt);
            boolean evalSampIsPhased = this.genotypesArePhasedAboveThreshold(evalSampGt);
            if (compSampIsPhased || evalSampIsPhased) {
                boolean topMatchesBottom;
                AllelePair prevEvalAllelePair;
                if (!evalSampIsPhased) {
                    ++ps.onlyCompPhased;
                    continue;
                }
                if (!compSampIsPhased) {
                    ++ps.onlyEvalPhased;
                    continue;
                }
                AllelePair prevCompAllelePair = new AllelePair(prevCompAndEval.getCompGenotpye());
                boolean topsMatch = GenotypePhasingEvaluator.topMatchesTop(prevCompAllelePair, prevEvalAllelePair = new AllelePair(prevCompAndEval.getEvalGenotype())) && GenotypePhasingEvaluator.topMatchesTop(compAllelePair, evalAllelePair);
                boolean bl = topMatchesBottom = GenotypePhasingEvaluator.topMatchesBottom(prevCompAllelePair, prevEvalAllelePair) && GenotypePhasingEvaluator.topMatchesBottom(compAllelePair, evalAllelePair);
                if (topsMatch || topMatchesBottom) {
                    ++ps.phasesAgree;
                    Double compPQ = GenotypePhasingEvaluator.getPQ(compSampGt);
                    Double evalPQ = GenotypePhasingEvaluator.getPQ(evalSampGt);
                    if (compPQ != null && evalPQ != null && MathUtils.compareDoubles(compPQ, evalPQ) == 0) continue;
                }
                ++ps.phasesDisagree;
                logger.debug("SWITCHED locus: " + curLocus);
                continue;
            }
            ++ps.neitherPhased;
        }
        logger.debug("\n" + this.samplePhasingStatistics + "\n");
        return interesting.toString();
    }

    public static boolean isRelevantToPhasing(VariantContext vc) {
        return vc != null && !vc.isFiltered();
    }

    public boolean isNonNullButUnphased(Genotype gt) {
        return gt != null && !this.genotypesArePhasedAboveThreshold(gt);
    }

    public boolean genotypesArePhasedAboveThreshold(Genotype gt) {
        if (gt.isHom()) {
            return true;
        }
        if (!gt.isPhased()) {
            return false;
        }
        Double pq = GenotypePhasingEvaluator.getPQ(gt);
        return pq == null || pq >= this.minPhaseQuality;
    }

    public static Double getPQ(Genotype gt) {
        return gt.getAttributeAsDoubleNoException("PQ");
    }

    public static boolean topMatchesTop(AllelePair b1, AllelePair b2) {
        return b1.getTopAllele().equals(b2.getTopAllele());
    }

    public static boolean topMatchesBottom(AllelePair b1, AllelePair b2) {
        return b1.getTopAllele().equals(b2.getBottomAllele());
    }

    public static boolean bottomMatchesTop(AllelePair b1, AllelePair b2) {
        return GenotypePhasingEvaluator.topMatchesBottom(b2, b1);
    }

    public static boolean bottomMatchesBottom(AllelePair b1, AllelePair b2) {
        return b1.getBottomAllele().equals(b2.getBottomAllele());
    }

    public String toString(AllelePair prev, AllelePair cur) {
        return prev.getTopAllele().getBaseString() + "+" + cur.getTopAllele().getBaseString() + "|" + prev.getBottomAllele().getBaseString() + "+" + cur.getBottomAllele().getBaseString();
    }

    @Override
    public void finalizeEvaluation() {
    }

    private static class Reasons {
        private StringBuilder sb = new StringBuilder();

        public String toString() {
            if (this.sb.length() == 0) {
                return null;
            }
            return "reasons=" + this.sb.toString();
        }
    }
}

