/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.SampleStats;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

class ACStats
extends SampleStats {
    private String[] rowKeys;

    public ACStats(VariantContext evalvc, VariantContext compvc, int nGenotypeTypes) {
        super(nGenotypeTypes);
        int i;
        this.rowKeys = new String[1 + 2 * evalvc.getGenotypes().size() + 1 + 2 * compvc.getGenotypes().size()];
        for (i = 0; i <= 2 * evalvc.getGenotypes().size(); ++i) {
            this.concordanceStats.put(String.format("evalAC%d", i), new long[nGenotypeTypes][nGenotypeTypes]);
            this.rowKeys[i] = String.format("evalAC%d", i);
        }
        for (i = 0; i <= 2 * compvc.getGenotypes().size(); ++i) {
            this.concordanceStats.put(String.format("compAC%d", i), new long[nGenotypeTypes][nGenotypeTypes]);
            this.rowKeys[1 + 2 * evalvc.getGenotypes().size() + i] = String.format("compAC%d", i);
        }
    }

    @Override
    public String getName() {
        return "Allele Count Statistics";
    }

    @Override
    public Object[] getRowKeys() {
        if (this.rowKeys == null) {
            throw new StingException("RowKeys is null!");
        }
        return this.rowKeys;
    }
}

