/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.qc;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;

public class PrintLocusContextWalker
extends LocusWalker<AlignmentContext, Integer>
implements TreeReducible<Integer> {
    @Output
    private PrintStream out;

    @Override
    public AlignmentContext map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        this.out.printf("In map: ref = %s, loc = %s %s, reads = %s%n", Character.valueOf(ref.getBaseAsChar()), context.getLocation(), context.hasExtendedEventPileup() ? "[extended]" : "", Arrays.deepToString(this.getReadNames(context.getReads())));
        return context;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(AlignmentContext context, Integer sum) {
        return sum + 1;
    }

    @Override
    public Integer treeReduce(Integer lhs, Integer rhs) {
        return lhs + rhs;
    }

    private String[] getReadNames(List<SAMRecord> reads) {
        String[] readNames = new String[reads.size()];
        for (int i = 0; i < reads.size(); ++i) {
            readNames[i] = String.format("%nname = %s, start = %d, end = %d", reads.get(i).getReadName(), reads.get(i).getAlignmentStart(), reads.get(i).getAlignmentEnd());
        }
        return readNames;
    }

    @Override
    public boolean generateExtendedEvents() {
        return true;
    }
}

