/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class RefSeqDataParser {
    private static String REFSEQ_PREFIX = "refseq.";
    private static String NUM_RECORDS_KEY = REFSEQ_PREFIX + "numMatchingRecords";
    private static String NAME_KEY = REFSEQ_PREFIX + "name";
    private static String NAME2_KEY = REFSEQ_PREFIX + "name2";
    private static String[] NAME_KEYS = new String[]{NAME_KEY, NAME2_KEY};

    private static Map<String, String> getRefSeqEntriesToNames(VariantContext vc, boolean getName2) {
        HashMap<String, String> entriesToNames;
        block6: {
            String nameKeyToUseMultiplePrefix;
            String nameKeyToUse;
            block5: {
                String name;
                nameKeyToUse = getName2 ? NAME2_KEY : NAME_KEY;
                nameKeyToUseMultiplePrefix = nameKeyToUse + "_";
                entriesToNames = new HashMap<String, String>();
                Integer numRecords = vc.getAttributeAsIntegerNoException(NUM_RECORDS_KEY);
                if (numRecords == null) break block5;
                boolean done = false;
                if (numRecords == 1 && (name = vc.getAttributeAsStringNoException(nameKeyToUse)) != null) {
                    entriesToNames.put(nameKeyToUse, name);
                    done = true;
                }
                if (done) break block6;
                for (int i = 1; i <= numRecords; ++i) {
                    String key = nameKeyToUseMultiplePrefix + i;
                    String name2 = vc.getAttributeAsStringNoException(key);
                    if (name2 == null) continue;
                    entriesToNames.put(key, name2);
                }
                break block6;
            }
            String name = vc.getAttributeAsStringNoException(nameKeyToUse);
            if (name != null) {
                entriesToNames.put(nameKeyToUse, name);
            } else {
                for (Map.Entry<String, Object> entry : vc.getAttributes().entrySet()) {
                    String key = entry.getKey();
                    if (!key.startsWith(nameKeyToUseMultiplePrefix)) continue;
                    entriesToNames.put(key, entry.getValue().toString());
                }
            }
        }
        return entriesToNames;
    }

    private static Map<String, String> getRefSeqEntriesToNames(VariantContext vc) {
        return RefSeqDataParser.getRefSeqEntriesToNames(vc, false);
    }

    public static Set<String> getRefSeqNames(VariantContext vc, boolean getName2) {
        return new TreeSet<String>(RefSeqDataParser.getRefSeqEntriesToNames(vc, getName2).values());
    }

    public static Set<String> getRefSeqNames(VariantContext vc) {
        return RefSeqDataParser.getRefSeqNames(vc, false);
    }

    public static Map<String, Object> getMergedRefSeqNameAttributes(VariantContext vc1, VariantContext vc2) {
        HashMap<String, Object> refSeqNameAttribs = new HashMap<String, Object>();
        Map<String, RefSeqEntry> entriesMap1 = RefSeqDataParser.getAllRefSeqEntriesByName(vc1);
        Map<String, RefSeqEntry> entriesMap2 = RefSeqDataParser.getAllRefSeqEntriesByName(vc2);
        Set<String> commonNames = entriesMap1.keySet();
        commonNames.retainAll(entriesMap2.keySet());
        boolean addSuffix = commonNames.size() > 1;
        int nextCount = 1;
        for (String name : commonNames) {
            RefSeqEntry refseq1 = entriesMap1.get(name);
            RefSeqEntry refseq2 = entriesMap2.get(name);
            String keySuffix = "";
            if (addSuffix) {
                keySuffix = "_" + nextCount;
            }
            boolean added = false;
            for (String key : NAME_KEYS) {
                Object obj1 = refseq1.info.get(key);
                Object obj2 = refseq2.info.get(key);
                if (obj1 == null || obj2 == null || !obj1.equals(obj2)) continue;
                added = true;
                String useKey = key + keySuffix;
                refSeqNameAttribs.put(useKey, obj1);
            }
            if (!added) continue;
            ++nextCount;
        }
        int totalCount = nextCount - 1;
        if (totalCount > 1) {
            refSeqNameAttribs.put(NUM_RECORDS_KEY, totalCount);
        }
        return refSeqNameAttribs;
    }

    public static Map<String, Object> removeRefSeqAttributes(Map<String, Object> attributes) {
        HashMap<String, Object> removedRefSeqAttributes = new HashMap<String, Object>(attributes);
        Iterator attrIt = removedRefSeqAttributes.entrySet().iterator();
        while (attrIt.hasNext()) {
            String key = (String)attrIt.next().getKey();
            if (!key.startsWith(REFSEQ_PREFIX)) continue;
            attrIt.remove();
        }
        return removedRefSeqAttributes;
    }

    private static Map<String, RefSeqEntry> getAllRefSeqEntriesByName(VariantContext vc) {
        TreeMap<String, RefSeqEntry> nameToEntries = new TreeMap<String, RefSeqEntry>();
        List<RefSeqEntry> allEntries = RefSeqDataParser.getAllRefSeqEntries(vc);
        for (RefSeqEntry entry : allEntries) {
            Object name = entry.info.get(NAME_KEY);
            if (name == null) continue;
            nameToEntries.put(name.toString(), entry);
        }
        return nameToEntries;
    }

    private static List<RefSeqEntry> getAllRefSeqEntries(VariantContext vc) {
        LinkedList<RefSeqEntry> allRefSeq = new LinkedList<RefSeqEntry>();
        for (Map.Entry<String, String> entryToName : RefSeqDataParser.getRefSeqEntriesToNames(vc).entrySet()) {
            String entry = entryToName.getKey();
            String entrySuffix = entry.replaceFirst(NAME_KEY, "");
            allRefSeq.add(new RefSeqEntry(vc, entrySuffix));
        }
        return allRefSeq;
    }

    private static class RefSeqEntry {
        public Map<String, Object> info = new HashMap<String, Object>();

        public RefSeqEntry(VariantContext vc, String entrySuffix) {
            for (Map.Entry<String, Object> attribEntry : vc.getAttributes().entrySet()) {
                String key = attribEntry.getKey();
                if (!key.startsWith(REFSEQ_PREFIX) || !key.endsWith(entrySuffix)) continue;
                String genericKey = key.replaceAll(entrySuffix, "");
                this.info.put(genericKey, attribEntry.getValue());
            }
        }
    }
}

