/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import java.util.Arrays;
import org.broadinstitute.sting.gatk.walkers.phasing.BaseArray;
import org.broadinstitute.sting.gatk.walkers.phasing.Haplotype;
import org.broadinstitute.sting.gatk.walkers.phasing.HaplotypeClass;
import org.broadinstitute.sting.gatk.walkers.phasing.PhasingScore;
import org.broadinstitute.sting.gatk.walkers.phasing.PreciseNonNegativeDouble;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class PhasingRead
extends BaseArray {
    private PreciseNonNegativeDouble mappingProb;
    private PreciseNonNegativeDouble[] baseProbs;
    private PreciseNonNegativeDouble[] baseErrorProbs;

    public PhasingRead(int length, int mappingQual) {
        super(length);
        this.mappingProb = new PreciseNonNegativeDouble(QualityUtils.qualToProb(mappingQual));
        this.baseProbs = new PreciseNonNegativeDouble[length];
        Arrays.fill(this.baseProbs, null);
        this.baseErrorProbs = new PreciseNonNegativeDouble[length];
        Arrays.fill(this.baseErrorProbs, null);
    }

    public void updateBaseAndQuality(int index, Byte base, byte baseQual) {
        this.updateBase(index, base);
        double errProb = QualityUtils.qualToErrorProb(baseQual);
        errProb = Math.max(errProb, 1.0 - this.mappingProb.getValue());
        this.baseProbs[index] = new PreciseNonNegativeDouble(1.0 - errProb);
        this.baseErrorProbs[index] = new PreciseNonNegativeDouble(errProb / 3.0);
    }

    public PhasingScore matchHaplotypeClassScore(HaplotypeClass hapClass) {
        PreciseNonNegativeDouble value = new PreciseNonNegativeDouble(0.0);
        for (Haplotype h : hapClass) {
            value.plusEqual(this.matchHaplotypeScore(h));
        }
        return new PhasingScore(value);
    }

    private PreciseNonNegativeDouble matchHaplotypeScore(Haplotype hap) {
        PreciseNonNegativeDouble score = new PreciseNonNegativeDouble(1.0);
        int sz = this.bases.length;
        if (sz != hap.bases.length) {
            throw new ReviewedStingException("Read and Haplotype should have same length to be compared!");
        }
        score.timesEqual(this.mappingProb);
        for (int i = 0; i < sz; ++i) {
            Byte thisBase = this.getBase(i);
            Byte hapBase = hap.getBase(i);
            if (thisBase == null || hapBase == null) continue;
            if (BaseUtils.basesAreEqual(thisBase, hapBase)) {
                score.timesEqual(this.baseProbs[i]);
                continue;
            }
            score.timesEqual(this.baseErrorProbs[i]);
        }
        return score;
    }
}

