/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.indels;

import java.io.File;
import java.util.Iterator;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.filters.BadMateFilter;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.interval.IntervalFileMergingIterator;
import org.broadinstitute.sting.utils.interval.IntervalMergingRule;
import org.broadinstitute.sting.utils.sam.ReadUtils;

@By(value=DataSource.READS)
public class RealignedReadCounter
extends ReadWalker<Integer, Integer> {
    public static final String ORIGINAL_CIGAR_TAG = "OC";
    public static final String ORIGINAL_POSITION_TAG = "OP";
    @Argument(fullName="targetIntervals", shortName="targetIntervals", doc="intervals file output from RealignerTargetCreator", required=true)
    protected String intervalsFile = null;
    private Iterator<GenomeLoc> intervals = null;
    private GenomeLoc currentInterval = null;
    private long updatedIntervals = 0L;
    private long updatedReads = 0L;
    private long affectedBases = 0L;
    private boolean intervalWasUpdated = false;

    @Override
    public void initialize() {
        this.intervals = new IntervalFileMergingIterator(this.getToolkit().getGenomeLocParser(), new File(this.intervalsFile), IntervalMergingRule.OVERLAPPING_ONLY);
        this.currentInterval = this.intervals.hasNext() ? this.intervals.next() : null;
    }

    @Override
    public Integer map(ReferenceContext ref, SAMRecord read, ReadMetaDataTracker metaDataTracker) {
        if (this.currentInterval == null) {
            return 0;
        }
        GenomeLoc readLoc = ref.getGenomeLocParser().createGenomeLoc(read);
        if (readLoc.getStop() == 0) {
            readLoc = ref.getGenomeLocParser().createGenomeLoc(readLoc.getContig(), readLoc.getStart(), readLoc.getStart());
        }
        if (readLoc.isBefore(this.currentInterval) || ReadUtils.is454Read(read)) {
            return 0;
        }
        if (readLoc.overlapsP(this.currentInterval)) {
            if (this.doNotTryToClean(read)) {
                return 0;
            }
            if (read.getAttribute(ORIGINAL_CIGAR_TAG) != null) {
                String newCigar = (String)read.getAttribute(ORIGINAL_CIGAR_TAG);
                if (read.getCigar().toString().equals(newCigar)) {
                    return 0;
                }
                if (!this.intervalWasUpdated) {
                    this.intervalWasUpdated = true;
                    ++this.updatedIntervals;
                    this.affectedBases += (long)(20 + this.getIndelSize(read));
                }
                ++this.updatedReads;
            }
        } else {
            do {
                this.intervalWasUpdated = false;
                GenomeLoc genomeLoc = this.currentInterval = this.intervals.hasNext() ? this.intervals.next() : null;
            } while (this.currentInterval != null && this.currentInterval.isBefore(readLoc));
        }
        return 0;
    }

    private int getIndelSize(SAMRecord read) {
        for (CigarElement ce : read.getCigar().getCigarElements()) {
            if (ce.getOperator() == CigarOperator.I) {
                return 0;
            }
            if (ce.getOperator() != CigarOperator.D) continue;
            return ce.getLength();
        }
        logger.warn("We didn't see an indel for this read: " + read.getReadName() + " " + read.getAlignmentStart() + " " + read.getCigar());
        return 0;
    }

    private boolean doNotTryToClean(SAMRecord read) {
        return read.getReadUnmappedFlag() || read.getNotPrimaryAlignmentFlag() || read.getReadFailsVendorQualityCheckFlag() || read.getMappingQuality() == 0 || read.getAlignmentStart() == 0 || BadMateFilter.hasBadMate(read);
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return sum + value;
    }

    @Override
    public void onTraversalDone(Integer result) {
        System.out.println(this.updatedIntervals + " intervals were updated");
        System.out.println(this.updatedReads + " reads were updated");
        System.out.println(this.affectedBases + " bases were affected");
    }
}

