/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.indels;

import net.sf.samtools.Cigar;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.io.StingSAMFileWriter;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.indels.IndelRealigner;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;

public class LeftAlignIndels
extends ReadWalker<Integer, Integer> {
    @Output(required=false, doc="Output bam")
    protected StingSAMFileWriter writer = null;
    @Argument(fullName="maxReadsInRam", shortName="maxInRam", doc="max reads allowed to be kept in memory at a time by the output writer", required=false)
    protected int MAX_RECORDS_IN_RAM = 500000;

    @Override
    public void initialize() {
        if (this.writer != null) {
            this.writer.setMaxRecordsInRam(this.MAX_RECORDS_IN_RAM);
        }
    }

    private void emit(SAMRecord read) {
        if (this.writer != null) {
            this.writer.addAlignment(read);
        }
    }

    @Override
    public Integer map(ReferenceContext ref, SAMRecord read, ReadMetaDataTracker metaDataTracker) {
        if (read.getCigar().numCigarElements() == 0) {
            this.emit(read);
            return 0;
        }
        int numBlocks = AlignmentUtils.getNumAlignmentBlocks(read);
        if (numBlocks == 2) {
            Cigar newCigar = AlignmentUtils.leftAlignIndel(IndelRealigner.unclipCigar(read.getCigar()), ref.getBases(), read.getReadBases(), 0, 0);
            newCigar = IndelRealigner.reclipCigar(newCigar, read);
            read.setCigar(newCigar);
        }
        this.emit(read);
        return 1;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return sum + value;
    }

    @Override
    public void onTraversalDone(Integer result) {
    }
}

