/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.AlignmentContextUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.genotyper.DiploidSNPGenotypeLikelihoods;
import org.broadinstitute.sting.gatk.walkers.genotyper.DiploidSNPGenotypePriors;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypePriors;
import org.broadinstitute.sting.gatk.walkers.genotyper.MultiallelicGenotypeLikelihoods;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedGenotyperEngine;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.genotype.DiploidGenotype;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileupImpl;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class SNPGenotypeLikelihoodsCalculationModel
extends GenotypeLikelihoodsCalculationModel {
    protected Byte bestAlternateAllele = null;
    private final boolean useAlleleFromVCF;

    protected SNPGenotypeLikelihoodsCalculationModel(UnifiedArgumentCollection UAC, Logger logger) {
        super(UAC, logger);
        this.useAlleleFromVCF = UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES;
    }

    @Override
    public Allele getLikelihoods(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, AlignmentContext> contexts, AlignmentContextUtils.ReadOrientation contextType, GenotypePriors priors, Map<String, MultiallelicGenotypeLikelihoods> GLs, Allele alternateAlleleToUse, boolean useBAQedPileup) {
        if (!(priors instanceof DiploidSNPGenotypePriors)) {
            throw new StingException("Only diploid-based SNP priors are supported in the SNP GL model");
        }
        byte refBase = ref.getBase();
        Allele refAllele = Allele.create(refBase, true);
        if (alternateAlleleToUse != null) {
            this.bestAlternateAllele = alternateAlleleToUse.getBases()[0];
        } else if (this.useAlleleFromVCF) {
            VariantContext vc = UnifiedGenotyperEngine.getVCFromAllelesRod(tracker, ref, ref.getLocus(), true, this.logger, this.UAC.alleles);
            if (vc == null) {
                return null;
            }
            if (!vc.isBiallelic()) {
                this.initializeBestAlternateAllele(refBase, contexts, useBAQedPileup);
            } else {
                this.bestAlternateAllele = vc.getAlternateAllele(0).getBases()[0];
            }
        } else {
            this.initializeBestAlternateAllele(refBase, contexts, useBAQedPileup);
        }
        if (this.bestAlternateAllele == null) {
            if (this.UAC.OutputMode == UnifiedGenotyperEngine.OUTPUT_MODE.EMIT_VARIANTS_ONLY) {
                return refAllele;
            }
            this.bestAlternateAllele = (byte)(refBase != 65 ? 65 : 67);
        }
        Allele altAllele = Allele.create(this.bestAlternateAllele, false);
        for (Map.Entry<String, AlignmentContext> sample : contexts.entrySet()) {
            DiploidSNPGenotypeLikelihoods GL;
            int nGoodBases;
            ReadBackedPileup pileup = AlignmentContextUtils.stratify(sample.getValue(), contextType).getBasePileup();
            if (useBAQedPileup) {
                pileup = this.createBAQedPileup(pileup);
            }
            if ((nGoodBases = (GL = new DiploidSNPGenotypeLikelihoods((DiploidSNPGenotypePriors)priors, this.UAC.PCR_error)).add(pileup, true, true, this.UAC.MIN_BASE_QUALTY_SCORE)) == 0) continue;
            double[] likelihoods = GL.getLikelihoods();
            DiploidGenotype refGenotype = DiploidGenotype.createHomGenotype(refBase);
            DiploidGenotype hetGenotype = DiploidGenotype.createDiploidGenotype(refBase, this.bestAlternateAllele);
            DiploidGenotype homGenotype = DiploidGenotype.createHomGenotype(this.bestAlternateAllele);
            ArrayList<Allele> aList = new ArrayList<Allele>();
            aList.add(refAllele);
            aList.add(altAllele);
            double[] dlike = new double[]{likelihoods[refGenotype.ordinal()], likelihoods[hetGenotype.ordinal()], likelihoods[homGenotype.ordinal()]};
            GLs.put(sample.getKey(), new MultiallelicGenotypeLikelihoods(sample.getKey(), aList, dlike, this.getFilteredDepth(pileup)));
        }
        return refAllele;
    }

    protected void initializeBestAlternateAllele(byte ref, Map<String, AlignmentContext> contexts, boolean useBAQedPileup) {
        int index;
        int[] qualCounts = new int[4];
        for (Map.Entry<String, AlignmentContext> sample : contexts.entrySet()) {
            ReadBackedPileup pileup = useBAQedPileup ? this.createBAQedPileup(sample.getValue().getBasePileup()) : sample.getValue().getBasePileup();
            for (PileupElement p : pileup) {
                if (p.isDeletion() || !p.isReducedRead() && p.getQual() < this.UAC.MIN_BASE_QUALTY_SCORE || (index = BaseUtils.simpleBaseToBaseIndex(p.getBase())) < 0) continue;
                int n = index;
                qualCounts[n] = qualCounts[n] + p.getQual();
            }
        }
        int maxCount = 0;
        this.bestAlternateAllele = null;
        for (byte altAllele : BaseUtils.BASES) {
            if (altAllele == ref || qualCounts[index = BaseUtils.simpleBaseToBaseIndex(altAllele)] <= maxCount) continue;
            maxCount = qualCounts[index];
            this.bestAlternateAllele = altAllele;
        }
    }

    public ReadBackedPileup createBAQedPileup(ReadBackedPileup pileup) {
        ArrayList<PileupElement> BAQedElements = new ArrayList<PileupElement>();
        for (PileupElement PE : pileup) {
            BAQedPileupElement newPE = new BAQedPileupElement(PE);
            BAQedElements.add(newPE);
        }
        return new ReadBackedPileupImpl(pileup.getLocation(), (List<PileupElement>)BAQedElements);
    }

    public class BAQedPileupElement
    extends PileupElement {
        public BAQedPileupElement(PileupElement PE) {
            super(PE.getRead(), PE.getOffset());
        }

        @Override
        public byte getQual(int offset) {
            return BAQ.calcBAQFromTag(this.getRead(), offset, true);
        }
    }
}

