/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ExperimentalAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class SnpEff
extends InfoFieldAnnotation
implements ExperimentalAnnotation {
    private static Logger logger = Logger.getLogger(SnpEff.class);
    public static final String[] SUPPORTED_SNPEFF_VERSIONS = new String[]{"2.0.2"};
    public static final String SNPEFF_VCF_HEADER_VERSION_LINE_KEY = "SnpEffVersion";
    public static final String SNPEFF_VCF_HEADER_COMMAND_LINE_KEY = "SnpEffCmd";
    public static final String OUTPUT_VCF_HEADER_VERSION_LINE_KEY = "OriginalSnpEffVersion";
    public static final String OUTPUT_VCF_HEADER_COMMAND_LINE_KEY = "OriginalSnpEffCmd";
    public static final String SNPEFF_INFO_FIELD_KEY = "EFF";
    public static final String SNPEFF_EFFECT_METADATA_DELIMITER = "[()]";
    public static final String SNPEFF_EFFECT_METADATA_SUBFIELD_DELIMITER = "\\|";

    @Override
    public void initialize(AnnotatorCompatibleWalker walker, GenomeAnalysisEngine toolkit, Set<VCFHeaderLine> headerLines) {
        this.validateRodBinding(walker.getSnpEffRodBinding());
        RodBinding<VariantContext> snpEffRodBinding = walker.getSnpEffRodBinding();
        VCFHeader snpEffVCFHeader = VCFUtils.getVCFHeadersFromRods(toolkit, Arrays.asList(snpEffRodBinding.getName())).get(snpEffRodBinding.getName());
        VCFHeaderLine snpEffVersionLine = snpEffVCFHeader.getOtherHeaderLine(SNPEFF_VCF_HEADER_VERSION_LINE_KEY);
        VCFHeaderLine snpEffCommandLine = snpEffVCFHeader.getOtherHeaderLine(SNPEFF_VCF_HEADER_COMMAND_LINE_KEY);
        this.checkSnpEffVersion(snpEffVersionLine);
        this.checkSnpEffCommandLine(snpEffCommandLine);
        headerLines.add(new VCFHeaderLine(OUTPUT_VCF_HEADER_VERSION_LINE_KEY, snpEffVersionLine.getValue()));
        headerLines.add(new VCFHeaderLine(OUTPUT_VCF_HEADER_COMMAND_LINE_KEY, snpEffCommandLine.getValue()));
    }

    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatibleWalker walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        RodBinding<VariantContext> snpEffRodBinding = walker.getSnpEffRodBinding();
        List<VariantContext> snpEffRecords = tracker.getValues(snpEffRodBinding, ref.getLocus());
        VariantContext matchingRecord = this.getMatchingSnpEffRecord(snpEffRecords, vc);
        if (matchingRecord == null) {
            return null;
        }
        List<SnpEffEffect> effects = this.parseSnpEffRecord(matchingRecord);
        if (effects.size() == 0) {
            return null;
        }
        SnpEffEffect mostSignificantEffect = this.getMostSignificantEffect(effects);
        return mostSignificantEffect.getAnnotations();
    }

    private void validateRodBinding(RodBinding<VariantContext> snpEffRodBinding) {
        if (snpEffRodBinding == null || !snpEffRodBinding.isBound()) {
            throw new UserException("The SnpEff annotator requires that a SnpEff VCF output file be provided as a rodbinding on the command line via the --snpEffFile option, but no SnpEff rodbinding was found.");
        }
    }

    private void checkSnpEffVersion(VCFHeaderLine snpEffVersionLine) {
        if (snpEffVersionLine == null || snpEffVersionLine.getValue() == null || snpEffVersionLine.getValue().trim().length() == 0) {
            throw new UserException("Could not find a SnpEffVersion entry in the VCF header for the SnpEff input file, and so could not verify that the file was generated by a supported version of SnpEff (" + Arrays.toString(SUPPORTED_SNPEFF_VERSIONS) + ")");
        }
        String snpEffVersionString = snpEffVersionLine.getValue().replaceAll("\"", "").split(" ")[0];
        if (!this.isSupportedSnpEffVersion(snpEffVersionString)) {
            throw new UserException("The version of SnpEff used to generate the SnpEff input file (" + snpEffVersionString + ") " + "is not currently supported by the GATK. Supported versions are: " + Arrays.toString(SUPPORTED_SNPEFF_VERSIONS));
        }
    }

    private void checkSnpEffCommandLine(VCFHeaderLine snpEffCommandLine) {
        if (snpEffCommandLine == null || snpEffCommandLine.getValue() == null || snpEffCommandLine.getValue().trim().length() == 0) {
            throw new UserException("Could not find a SnpEffCmd entry in the VCF header for the SnpEff input file, which should be added by all supported versions of SnpEff (" + Arrays.toString(SUPPORTED_SNPEFF_VERSIONS) + ")");
        }
    }

    private boolean isSupportedSnpEffVersion(String versionString) {
        for (String supportedVersion : SUPPORTED_SNPEFF_VERSIONS) {
            if (!supportedVersion.equals(versionString)) continue;
            return true;
        }
        return false;
    }

    private VariantContext getMatchingSnpEffRecord(List<VariantContext> snpEffRecords, VariantContext vc) {
        for (VariantContext snpEffRecord : snpEffRecords) {
            if (!snpEffRecord.hasSameAlternateAllelesAs(vc) || !snpEffRecord.getReference().equals(vc.getReference())) continue;
            return snpEffRecord;
        }
        return null;
    }

    private List<SnpEffEffect> parseSnpEffRecord(VariantContext snpEffRecord) {
        ArrayList<SnpEffEffect> parsedEffects = new ArrayList<SnpEffEffect>();
        Object effectFieldValue = snpEffRecord.getAttribute(SNPEFF_INFO_FIELD_KEY);
        if (effectFieldValue == null) {
            return parsedEffects;
        }
        List<String> individualEffects = effectFieldValue instanceof List ? (List<String>)effectFieldValue : Arrays.asList((String)effectFieldValue);
        for (String effectString : individualEffects) {
            String[] effectNameAndMetadata = effectString.split(SNPEFF_EFFECT_METADATA_DELIMITER);
            if (effectNameAndMetadata.length != 2) {
                logger.warn(String.format("Malformed SnpEff effect field at %s:%d, skipping: %s", snpEffRecord.getChr(), snpEffRecord.getStart(), effectString));
                continue;
            }
            String effectName = effectNameAndMetadata[0];
            String[] effectMetadata = effectNameAndMetadata[1].split(SNPEFF_EFFECT_METADATA_SUBFIELD_DELIMITER, -1);
            SnpEffEffect parsedEffect = new SnpEffEffect(effectName, effectMetadata);
            if (parsedEffect.isWellFormed()) {
                parsedEffects.add(parsedEffect);
                continue;
            }
            logger.warn(String.format("Skipping malformed SnpEff effect field at %s:%d. Error was: \"%s\". Field was: \"%s\"", snpEffRecord.getChr(), snpEffRecord.getStart(), parsedEffect.getParseError(), effectString));
        }
        return parsedEffects;
    }

    private SnpEffEffect getMostSignificantEffect(List<SnpEffEffect> effects) {
        SnpEffEffect mostSignificantEffect = null;
        for (SnpEffEffect effect : effects) {
            if (mostSignificantEffect != null && !effect.isHigherImpactThan(mostSignificantEffect)) continue;
            mostSignificantEffect = effect;
        }
        return mostSignificantEffect;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList(InfoFieldKey.EFFECT_KEY.getKeyName(), InfoFieldKey.IMPACT_KEY.getKeyName(), InfoFieldKey.CODON_CHANGE_KEY.getKeyName(), InfoFieldKey.AMINO_ACID_CHANGE_KEY.getKeyName(), InfoFieldKey.GENE_NAME_KEY.getKeyName(), InfoFieldKey.GENE_BIOTYPE_KEY.getKeyName(), InfoFieldKey.TRANSCRIPT_ID_KEY.getKeyName(), InfoFieldKey.EXON_ID_KEY.getKeyName(), InfoFieldKey.FUNCTIONAL_CLASS_KEY.getKeyName());
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine(InfoFieldKey.EFFECT_KEY.getKeyName(), 1, VCFHeaderLineType.String, "The highest-impact effect resulting from the current variant (or one of the highest-impact effects, if there is a tie)"), new VCFInfoHeaderLine(InfoFieldKey.IMPACT_KEY.getKeyName(), 1, VCFHeaderLineType.String, "Impact of the highest-impact effect resulting from the current variant " + Arrays.toString((Object[])EffectImpact.values())), new VCFInfoHeaderLine(InfoFieldKey.CODON_CHANGE_KEY.getKeyName(), 1, VCFHeaderLineType.String, "Old/New codon for the highest-impact effect resulting from the current variant"), new VCFInfoHeaderLine(InfoFieldKey.AMINO_ACID_CHANGE_KEY.getKeyName(), 1, VCFHeaderLineType.String, "Old/New amino acid for the highest-impact effect resulting from the current variant"), new VCFInfoHeaderLine(InfoFieldKey.GENE_NAME_KEY.getKeyName(), 1, VCFHeaderLineType.String, "Gene name for the highest-impact effect resulting from the current variant"), new VCFInfoHeaderLine(InfoFieldKey.GENE_BIOTYPE_KEY.getKeyName(), 1, VCFHeaderLineType.String, "Gene biotype for the highest-impact effect resulting from the current variant"), new VCFInfoHeaderLine(InfoFieldKey.TRANSCRIPT_ID_KEY.getKeyName(), 1, VCFHeaderLineType.String, "Transcript ID for the highest-impact effect resulting from the current variant"), new VCFInfoHeaderLine(InfoFieldKey.EXON_ID_KEY.getKeyName(), 1, VCFHeaderLineType.String, "Exon ID for the highest-impact effect resulting from the current variant"), new VCFInfoHeaderLine(InfoFieldKey.FUNCTIONAL_CLASS_KEY.getKeyName(), 1, VCFHeaderLineType.String, "Functional class of the highest-impact effect resulting from the current variant: " + Arrays.toString((Object[])EffectFunctionalClass.values())));
    }

    protected static class SnpEffEffect {
        private EffectType effect;
        private EffectImpact impact;
        private String codonChange;
        private String aminoAcidChange;
        private String geneName;
        private String geneBiotype;
        private EffectCoding coding;
        private String transcriptID;
        private String exonID;
        private String parseError = null;
        private boolean isWellFormed = true;
        private static final int EXPECTED_NUMBER_OF_METADATA_FIELDS = 8;
        private static final int NUMBER_OF_METADATA_FIELDS_UPON_WARNING = 9;
        private static final int NUMBER_OF_METADATA_FIELDS_UPON_ERROR = 10;
        private static final int SNPEFF_WARNING_FIELD_INDEX = 8;
        private static final int SNPEFF_ERROR_FIELD_INDEX = 9;
        private static final int SNPEFF_CODING_FIELD_INDEX = 5;

        public SnpEffEffect(String effectName, String[] effectMetadata) {
            this.parseEffectName(effectName);
            this.parseEffectMetadata(effectMetadata);
        }

        private void parseEffectName(String effectName) {
            try {
                this.effect = EffectType.valueOf(effectName);
            }
            catch (IllegalArgumentException e) {
                this.parseError(String.format("%s is not a recognized effect type", effectName));
            }
        }

        private void parseEffectMetadata(String[] effectMetadata) {
            if (effectMetadata.length != 8) {
                if (effectMetadata.length == 9) {
                    this.parseError(String.format("SnpEff issued the following warning: %s", effectMetadata[8]));
                } else if (effectMetadata.length == 10) {
                    this.parseError(String.format("SnpEff issued the following error: %s", effectMetadata[9]));
                } else {
                    this.parseError(String.format("Wrong number of effect metadata fields. Expected %d but found %d", 8, effectMetadata.length));
                }
                return;
            }
            if (this.effect != null && this.effect.isModifier()) {
                this.impact = EffectImpact.MODIFIER;
            } else {
                try {
                    this.impact = EffectImpact.valueOf(effectMetadata[InfoFieldKey.IMPACT_KEY.getFieldIndex()]);
                }
                catch (IllegalArgumentException e) {
                    this.parseError(String.format("Unrecognized value for effect impact: %s", effectMetadata[InfoFieldKey.IMPACT_KEY.getFieldIndex()]));
                }
            }
            this.codonChange = effectMetadata[InfoFieldKey.CODON_CHANGE_KEY.getFieldIndex()];
            this.aminoAcidChange = effectMetadata[InfoFieldKey.AMINO_ACID_CHANGE_KEY.getFieldIndex()];
            this.geneName = effectMetadata[InfoFieldKey.GENE_NAME_KEY.getFieldIndex()];
            this.geneBiotype = effectMetadata[InfoFieldKey.GENE_BIOTYPE_KEY.getFieldIndex()];
            if (effectMetadata[5].trim().length() > 0) {
                try {
                    this.coding = EffectCoding.valueOf(effectMetadata[5]);
                }
                catch (IllegalArgumentException e) {
                    this.parseError(String.format("Unrecognized value for effect coding: %s", effectMetadata[5]));
                }
            } else {
                this.coding = EffectCoding.UNKNOWN;
            }
            this.transcriptID = effectMetadata[InfoFieldKey.TRANSCRIPT_ID_KEY.getFieldIndex()];
            this.exonID = effectMetadata[InfoFieldKey.EXON_ID_KEY.getFieldIndex()];
        }

        private void parseError(String message) {
            this.isWellFormed = false;
            if (this.parseError == null) {
                this.parseError = message;
            }
        }

        public boolean isWellFormed() {
            return this.isWellFormed;
        }

        public String getParseError() {
            return this.parseError == null ? "" : this.parseError;
        }

        public boolean isCoding() {
            return this.coding == EffectCoding.CODING;
        }

        public boolean isHigherImpactThan(SnpEffEffect other) {
            if (this.isCoding() && !other.isCoding()) {
                return true;
            }
            if (!this.isCoding() && other.isCoding()) {
                return false;
            }
            if (this.impact.isHigherImpactThan(other.impact)) {
                return true;
            }
            if (this.impact.isSameImpactAs(other.impact)) {
                return this.effect.getFunctionalClass().isHigherPriorityThan(other.effect.getFunctionalClass());
            }
            return false;
        }

        public Map<String, Object> getAnnotations() {
            LinkedHashMap<String, Object> annotations = new LinkedHashMap<String, Object>(Utils.optimumHashSize(InfoFieldKey.values().length));
            this.addAnnotation(annotations, InfoFieldKey.EFFECT_KEY.getKeyName(), this.effect.toString());
            this.addAnnotation(annotations, InfoFieldKey.IMPACT_KEY.getKeyName(), this.impact.toString());
            this.addAnnotation(annotations, InfoFieldKey.CODON_CHANGE_KEY.getKeyName(), this.codonChange);
            this.addAnnotation(annotations, InfoFieldKey.AMINO_ACID_CHANGE_KEY.getKeyName(), this.aminoAcidChange);
            this.addAnnotation(annotations, InfoFieldKey.GENE_NAME_KEY.getKeyName(), this.geneName);
            this.addAnnotation(annotations, InfoFieldKey.GENE_BIOTYPE_KEY.getKeyName(), this.geneBiotype);
            this.addAnnotation(annotations, InfoFieldKey.TRANSCRIPT_ID_KEY.getKeyName(), this.transcriptID);
            this.addAnnotation(annotations, InfoFieldKey.EXON_ID_KEY.getKeyName(), this.exonID);
            this.addAnnotation(annotations, InfoFieldKey.FUNCTIONAL_CLASS_KEY.getKeyName(), this.effect.getFunctionalClass().toString());
            return annotations;
        }

        private void addAnnotation(Map<String, Object> annotations, String keyName, String keyValue) {
            if (keyValue != null && keyValue.trim().length() > 0) {
                annotations.put(keyName, keyValue);
            }
        }
    }

    public static enum EffectFunctionalClass {
        NONE(0),
        SILENT(1),
        MISSENSE(2),
        NONSENSE(3);

        private final int priority;

        private EffectFunctionalClass(int priority) {
            this.priority = priority;
        }

        public boolean isHigherPriorityThan(EffectFunctionalClass other) {
            return this.priority > other.priority;
        }
    }

    public static enum EffectCoding {
        CODING,
        NON_CODING,
        UNKNOWN;

    }

    public static enum EffectImpact {
        MODIFIER(0),
        LOW(1),
        MODERATE(2),
        HIGH(3);

        private final int severityRating;

        private EffectImpact(int severityRating) {
            this.severityRating = severityRating;
        }

        public boolean isHigherImpactThan(EffectImpact other) {
            return this.severityRating > other.severityRating;
        }

        public boolean isSameImpactAs(EffectImpact other) {
            return this.severityRating == other.severityRating;
        }
    }

    public static enum EffectType {
        FRAME_SHIFT(EffectFunctionalClass.NONE, false),
        STOP_GAINED(EffectFunctionalClass.NONSENSE, false),
        START_LOST(EffectFunctionalClass.NONE, false),
        SPLICE_SITE_ACCEPTOR(EffectFunctionalClass.NONE, false),
        SPLICE_SITE_DONOR(EffectFunctionalClass.NONE, false),
        EXON_DELETED(EffectFunctionalClass.NONE, false),
        STOP_LOST(EffectFunctionalClass.NONE, false),
        NON_SYNONYMOUS_CODING(EffectFunctionalClass.MISSENSE, false),
        CODON_CHANGE(EffectFunctionalClass.NONE, false),
        CODON_INSERTION(EffectFunctionalClass.NONE, false),
        CODON_CHANGE_PLUS_CODON_INSERTION(EffectFunctionalClass.NONE, false),
        CODON_DELETION(EffectFunctionalClass.NONE, false),
        CODON_CHANGE_PLUS_CODON_DELETION(EffectFunctionalClass.NONE, false),
        UTR_5_DELETED(EffectFunctionalClass.NONE, false),
        UTR_3_DELETED(EffectFunctionalClass.NONE, false),
        SYNONYMOUS_CODING(EffectFunctionalClass.SILENT, false),
        SYNONYMOUS_START(EffectFunctionalClass.SILENT, false),
        NON_SYNONYMOUS_START(EffectFunctionalClass.SILENT, false),
        SYNONYMOUS_STOP(EffectFunctionalClass.SILENT, false),
        NON_SYNONYMOUS_STOP(EffectFunctionalClass.SILENT, false),
        START_GAINED(EffectFunctionalClass.NONE, false),
        NONE(EffectFunctionalClass.NONE, true),
        CHROMOSOME(EffectFunctionalClass.NONE, true),
        INTERGENIC(EffectFunctionalClass.NONE, true),
        UPSTREAM(EffectFunctionalClass.NONE, true),
        UTR_5_PRIME(EffectFunctionalClass.NONE, true),
        CDS(EffectFunctionalClass.NONE, true),
        GENE(EffectFunctionalClass.NONE, true),
        TRANSCRIPT(EffectFunctionalClass.NONE, true),
        EXON(EffectFunctionalClass.NONE, true),
        INTRON(EffectFunctionalClass.NONE, true),
        UTR_3_PRIME(EffectFunctionalClass.NONE, true),
        DOWNSTREAM(EffectFunctionalClass.NONE, true),
        INTRON_CONSERVED(EffectFunctionalClass.NONE, true),
        INTERGENIC_CONSERVED(EffectFunctionalClass.NONE, true),
        REGULATION(EffectFunctionalClass.NONE, true),
        CUSTOM(EffectFunctionalClass.NONE, true),
        WITHIN_NON_CODING_GENE(EffectFunctionalClass.NONE, true);

        private final EffectFunctionalClass functionalClass;
        private final boolean isModifier;

        private EffectType(EffectFunctionalClass functionalClass, boolean isModifier) {
            this.functionalClass = functionalClass;
            this.isModifier = isModifier;
        }

        public EffectFunctionalClass getFunctionalClass() {
            return this.functionalClass;
        }

        public boolean isModifier() {
            return this.isModifier;
        }
    }

    public static enum InfoFieldKey {
        EFFECT_KEY("SNPEFF_EFFECT", -1),
        IMPACT_KEY("SNPEFF_IMPACT", 0),
        CODON_CHANGE_KEY("SNPEFF_CODON_CHANGE", 1),
        AMINO_ACID_CHANGE_KEY("SNPEFF_AMINO_ACID_CHANGE", 2),
        GENE_NAME_KEY("SNPEFF_GENE_NAME", 3),
        GENE_BIOTYPE_KEY("SNPEFF_GENE_BIOTYPE", 4),
        TRANSCRIPT_ID_KEY("SNPEFF_TRANSCRIPT_ID", 6),
        EXON_ID_KEY("SNPEFF_EXON_ID", 7),
        FUNCTIONAL_CLASS_KEY("SNPEFF_FUNCTIONAL_CLASS", -1);

        private final String keyName;
        private final int fieldIndex;

        private InfoFieldKey(String keyName, int fieldIndex) {
            this.keyName = keyName;
            this.fieldIndex = fieldIndex;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public int getFieldIndex() {
            return this.fieldIndex;
        }
    }
}

