/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.AnnotationByDepth;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class QualByDepth
extends AnnotationByDepth
implements StandardAnnotation {
    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatibleWalker walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        if (stratifiedContexts.size() == 0) {
            return null;
        }
        Map<String, Genotype> genotypes = vc.getGenotypes();
        if (genotypes == null || genotypes.size() == 0) {
            return null;
        }
        int depth = 0;
        for (Map.Entry<String, Genotype> genotype : genotypes.entrySet()) {
            AlignmentContext context;
            if (genotype.getValue().isHomRef() || (context = stratifiedContexts.get(genotype.getKey())) == null) continue;
            depth += context.size();
        }
        if (depth == 0) {
            return null;
        }
        int qDepth = this.annotationByVariantDepth(genotypes, stratifiedContexts);
        double QD = 10.0 * vc.getNegLog10PError() / (double)qDepth;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), String.format("%.2f", QD));
        return map;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("QD");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine(this.getKeyNames().get(0), 1, VCFHeaderLineType.Float, "Variant Confidence/Quality by Depth"));
    }
}

