/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.report;

import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ObjectUtils;
import org.broadinstitute.sting.gatk.report.GATKReportColumn;
import org.broadinstitute.sting.gatk.report.GATKReportColumns;
import org.broadinstitute.sting.gatk.report.GATKReportVersion;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class GATKReportTable {
    public static final String INVALID_TABLE_NAME_REGEX = "[^a-zA-Z0-9_\\-\\.]";
    private static final GATKReportVersion LATEST_REPORT_VERSION = GATKReportVersion.V0_2;
    private String tableName;
    private String tableDescription;
    private GATKReportVersion version = LATEST_REPORT_VERSION;
    private String primaryKeyName;
    private Collection<Object> primaryKeyColumn;
    private boolean primaryKeyDisplay;
    private boolean sortByPrimaryKey = true;
    private GATKReportColumns columns;

    private boolean isValidName(String name) {
        Pattern p = Pattern.compile(INVALID_TABLE_NAME_REGEX);
        Matcher m = p.matcher(name);
        return !m.find();
    }

    private boolean isValidDescription(String description) {
        Pattern p = Pattern.compile("\\r|\\n");
        Matcher m = p.matcher(description);
        return !m.find();
    }

    public GATKReportTable(String tableName, String tableDescription) {
        this(tableName, tableDescription, true);
    }

    public GATKReportTable(String tableName, String tableDescription, boolean sortByPrimaryKey) {
        if (!this.isValidName(tableName)) {
            throw new ReviewedStingException("Attempted to set a GATKReportTable name of '" + tableName + "'.  GATKReportTable names must be purely alphanumeric - no spaces or special characters are allowed.");
        }
        if (!this.isValidDescription(tableDescription)) {
            throw new ReviewedStingException("Attempted to set a GATKReportTable description of '" + tableDescription + "'.  GATKReportTable descriptions must not contain newlines.");
        }
        this.tableName = tableName;
        this.tableDescription = tableDescription;
        this.sortByPrimaryKey = sortByPrimaryKey;
        this.columns = new GATKReportColumns();
    }

    public GATKReportVersion getVersion() {
        return this.version;
    }

    protected void setVersion(GATKReportVersion version) {
        this.version = version;
    }

    public void addPrimaryKey(String primaryKeyName) {
        this.addPrimaryKey(primaryKeyName, true);
    }

    public void addPrimaryKey(String primaryKeyName, boolean display) {
        if (!this.isValidName(primaryKeyName)) {
            throw new ReviewedStingException("Attempted to set a GATKReportTable primary key name of '" + primaryKeyName + "'.  GATKReportTable primary key names must be purely alphanumeric - no spaces or special characters are allowed.");
        }
        this.primaryKeyName = primaryKeyName;
        this.primaryKeyColumn = this.sortByPrimaryKey ? new TreeSet() : new LinkedList();
        this.primaryKeyDisplay = display;
    }

    public Object getPrimaryKey(String dottedColumnValues) {
        Object key = this.findPrimaryKey(dottedColumnValues);
        if (key == null) {
            throw new ReviewedStingException("Attempted to get non-existent GATKReportTable key for values: " + dottedColumnValues);
        }
        return key;
    }

    public boolean containsPrimaryKey(String dottedColumnValues) {
        return this.findPrimaryKey(dottedColumnValues) != null;
    }

    private Object findPrimaryKey(String dottedColumnValues) {
        return this.findPrimaryKey(dottedColumnValues.split("\\."));
    }

    private Object findPrimaryKey(Object[] columnValues) {
        for (Object primaryKey : this.primaryKeyColumn) {
            boolean matching = true;
            for (int i = 0; matching && i < columnValues.length; ++i) {
                matching = ObjectUtils.equals(columnValues[i], this.get(primaryKey, i + 1));
            }
            if (!matching) continue;
            return primaryKey;
        }
        return null;
    }

    public void addColumn(String columnName, Object defaultValue) {
        if (!this.isValidName(columnName)) {
            throw new ReviewedStingException("Attempted to set a GATKReportTable column name of '" + columnName + "'.  GATKReportTable column names must be purely alphanumeric - no spaces or special characters are allowed.");
        }
        this.addColumn(columnName, defaultValue, true);
    }

    public void addColumn(String columnName, Object defaultValue, boolean display) {
        this.columns.put(columnName, new GATKReportColumn(columnName, defaultValue, display));
    }

    private void verifyEntry(Object primaryKey, String columnName) {
        if (!this.columns.containsKey(columnName)) {
            throw new ReviewedStingException("Attempted to access column '" + columnName + "' that does not exist in table '" + this.tableName + "'.");
        }
        this.primaryKeyColumn.add(primaryKey);
        if (!((GATKReportColumn)this.columns.get(columnName)).containsKey(primaryKey)) {
            ((GATKReportColumn)this.columns.get(columnName)).initialize(primaryKey);
        }
    }

    public void set(Object primaryKey, String columnName, Object value) {
        this.verifyEntry(primaryKey, columnName);
        ((GATKReportColumn)this.columns.get(columnName)).put(primaryKey, value);
    }

    public Object get(Object primaryKey, String columnName) {
        this.verifyEntry(primaryKey, columnName);
        return ((GATKReportColumn)this.columns.get(columnName)).get(primaryKey);
    }

    private Object get(Object primaryKey, int columnIndex) {
        return this.columns.getByIndex(columnIndex).get(primaryKey);
    }

    public void increment(Object primaryKey, String columnName) {
        Number newValue;
        Object oldValue = this.get(primaryKey, columnName);
        if (oldValue instanceof Byte) {
            newValue = (Byte)oldValue + 1;
        } else if (oldValue instanceof Short) {
            newValue = (Short)oldValue + 1;
        } else if (oldValue instanceof Integer) {
            newValue = (Integer)oldValue + 1;
        } else if (oldValue instanceof Long) {
            newValue = (Long)oldValue + 1L;
        } else if (oldValue instanceof Float) {
            newValue = Float.valueOf(((Float)oldValue).floatValue() + 1.0f);
        } else if (oldValue instanceof Double) {
            newValue = (Double)oldValue + 1.0;
        } else {
            throw new UnsupportedOperationException("Can't increment value: object " + oldValue + " is not an instance of one of the numerical Java primitive wrapper classes (Byte, Short, Integer, Long, Float, Double)");
        }
        this.set(primaryKey, columnName, newValue);
    }

    public void decrement(Object primaryKey, String columnName) {
        Number newValue;
        Object oldValue = this.get(primaryKey, columnName);
        if (oldValue instanceof Byte) {
            newValue = (Byte)oldValue - 1;
        } else if (oldValue instanceof Short) {
            newValue = (Short)oldValue - 1;
        } else if (oldValue instanceof Integer) {
            newValue = (Integer)oldValue - 1;
        } else if (oldValue instanceof Long) {
            newValue = (Long)oldValue - 1L;
        } else if (oldValue instanceof Float) {
            newValue = Float.valueOf(((Float)oldValue).floatValue() - 1.0f);
        } else if (oldValue instanceof Double) {
            newValue = (Double)oldValue - 1.0;
        } else {
            throw new UnsupportedOperationException("Can't decrement value: object " + oldValue + " is not an instance of one of the numerical Java primitive wrapper classes (Byte, Short, Integer, Long, Float, Double)");
        }
        this.set(primaryKey, columnName, newValue);
    }

    public void add(Object primaryKey, String columnName, Object valueToAdd) {
        Number newValue;
        Object oldValue = this.get(primaryKey, columnName);
        if (oldValue instanceof Byte) {
            newValue = (Byte)oldValue + (Byte)valueToAdd;
        } else if (oldValue instanceof Short) {
            newValue = (Short)oldValue + (Short)valueToAdd;
        } else if (oldValue instanceof Integer) {
            newValue = (Integer)oldValue + (Integer)valueToAdd;
        } else if (oldValue instanceof Long) {
            newValue = (Long)oldValue + (Long)valueToAdd;
        } else if (oldValue instanceof Float) {
            newValue = Float.valueOf(((Float)oldValue).floatValue() + ((Float)valueToAdd).floatValue());
        } else if (oldValue instanceof Double) {
            newValue = (Double)oldValue + (Double)valueToAdd;
        } else {
            throw new UnsupportedOperationException("Can't add values: object " + oldValue + " is not an instance of one of the numerical Java primitive wrapper classes (Byte, Short, Integer, Long, Float, Double)");
        }
        this.set(primaryKey, columnName, newValue);
    }

    public void subtract(Object primaryKey, String columnName, Object valueToSubtract) {
        Number newValue;
        Object oldValue = this.get(primaryKey, columnName);
        if (oldValue instanceof Byte) {
            newValue = (Byte)oldValue - (Byte)valueToSubtract;
        } else if (oldValue instanceof Short) {
            newValue = (Short)oldValue - (Short)valueToSubtract;
        } else if (oldValue instanceof Integer) {
            newValue = (Integer)oldValue - (Integer)valueToSubtract;
        } else if (oldValue instanceof Long) {
            newValue = (Long)oldValue - (Long)valueToSubtract;
        } else if (oldValue instanceof Float) {
            newValue = Float.valueOf(((Float)oldValue).floatValue() - ((Float)valueToSubtract).floatValue());
        } else if (oldValue instanceof Double) {
            newValue = (Double)oldValue - (Double)valueToSubtract;
        } else {
            throw new UnsupportedOperationException("Can't subtract values: object " + oldValue + " is not an instance of one of the numerical Java primitive wrapper classes (Byte, Short, Integer, Long, Float, Double)");
        }
        this.set(primaryKey, columnName, newValue);
    }

    public void multiply(Object primaryKey, String columnName, Object valueToMultiply) {
        Number newValue;
        Object oldValue = this.get(primaryKey, columnName);
        if (oldValue instanceof Byte) {
            newValue = (Byte)oldValue * (Byte)valueToMultiply;
        } else if (oldValue instanceof Short) {
            newValue = (Short)oldValue * (Short)valueToMultiply;
        } else if (oldValue instanceof Integer) {
            newValue = (Integer)oldValue * (Integer)valueToMultiply;
        } else if (oldValue instanceof Long) {
            newValue = (Long)oldValue * (Long)valueToMultiply;
        } else if (oldValue instanceof Float) {
            newValue = Float.valueOf(((Float)oldValue).floatValue() * ((Float)valueToMultiply).floatValue());
        } else if (oldValue instanceof Double) {
            newValue = (Double)oldValue * (Double)valueToMultiply;
        } else {
            throw new UnsupportedOperationException("Can't multiply values: object " + oldValue + " is not an instance of one of the numerical Java primitive wrapper classes (Byte, Short, Integer, Long, Float, Double)");
        }
        this.set(primaryKey, columnName, newValue);
    }

    public void divide(Object primaryKey, String columnName, Object valueToDivide) {
        Number newValue;
        Object oldValue = this.get(primaryKey, columnName);
        if (oldValue instanceof Byte) {
            newValue = (Byte)oldValue * (Byte)valueToDivide;
        } else if (oldValue instanceof Short) {
            newValue = (Short)oldValue * (Short)valueToDivide;
        } else if (oldValue instanceof Integer) {
            newValue = (Integer)oldValue * (Integer)valueToDivide;
        } else if (oldValue instanceof Long) {
            newValue = (Long)oldValue * (Long)valueToDivide;
        } else if (oldValue instanceof Float) {
            newValue = Float.valueOf(((Float)oldValue).floatValue() * ((Float)valueToDivide).floatValue());
        } else if (oldValue instanceof Double) {
            newValue = (Double)oldValue * (Double)valueToDivide;
        } else {
            throw new UnsupportedOperationException("Can't divide values: object " + oldValue + " is not an instance of one of the numerical Java primitive wrapper classes (Byte, Short, Integer, Long, Float, Double)");
        }
        this.set(primaryKey, columnName, newValue);
    }

    public void addColumns(String columnToSet, String augend, String addend) {
        for (Object primaryKey : this.primaryKeyColumn) {
            Number firstColumnValue = (Number)this.get(primaryKey, augend);
            Number secondColumnValue = (Number)this.get(primaryKey, addend);
            Double value = firstColumnValue.doubleValue() + secondColumnValue.doubleValue();
            this.set(primaryKey, columnToSet, value);
        }
    }

    public void subtractColumns(String columnToSet, String minuend, String subtrahend) {
        for (Object primaryKey : this.primaryKeyColumn) {
            Number firstColumnValue = (Number)this.get(primaryKey, minuend);
            Number secondColumnValue = (Number)this.get(primaryKey, subtrahend);
            Double value = firstColumnValue.doubleValue() - secondColumnValue.doubleValue();
            this.set(primaryKey, columnToSet, value);
        }
    }

    public void multiplyColumns(String columnToSet, String multiplier, String multiplicand) {
        for (Object primaryKey : this.primaryKeyColumn) {
            Number firstColumnValue = (Number)this.get(primaryKey, multiplier);
            Number secondColumnValue = (Number)this.get(primaryKey, multiplicand);
            Double value = firstColumnValue.doubleValue() * secondColumnValue.doubleValue();
            this.set(primaryKey, columnToSet, value);
        }
    }

    public void divideColumns(String columnToSet, String numeratorColumn, String denominatorColumn) {
        for (Object primaryKey : this.primaryKeyColumn) {
            Number firstColumnValue = (Number)this.get(primaryKey, numeratorColumn);
            Number secondColumnValue = (Number)this.get(primaryKey, denominatorColumn);
            Double value = firstColumnValue.doubleValue() / secondColumnValue.doubleValue();
            this.set(primaryKey, columnToSet, value);
        }
    }

    public int getPrimaryKeyColumnWidth() {
        int maxWidth = this.primaryKeyName.length();
        for (Object primaryKey : this.primaryKeyColumn) {
            int width = primaryKey.toString().length();
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    public void write(PrintStream out) {
        HashMap<String, String> columnWidths = new HashMap<String, String>();
        for (String columnName : this.columns.keySet()) {
            int width = ((GATKReportColumn)this.columns.get(columnName)).getColumnWidth();
            String format = "%-" + String.valueOf(width) + "s";
            columnWidths.put(columnName, format);
        }
        String primaryKeyFormat = "%-" + this.getPrimaryKeyColumnWidth() + "s";
        out.printf("##:GATKReport.%s %s : %s%n", GATKReportTable.LATEST_REPORT_VERSION.versionString, this.tableName, this.tableDescription);
        boolean needsPadding = false;
        if (this.primaryKeyDisplay) {
            out.printf(primaryKeyFormat, this.primaryKeyName);
            needsPadding = true;
        }
        for (String columnName : this.columns.keySet()) {
            if (!((GATKReportColumn)this.columns.get(columnName)).isDisplayable()) continue;
            if (needsPadding) {
                out.printf("  ", new Object[0]);
            }
            out.printf((String)columnWidths.get(columnName), columnName);
            needsPadding = true;
        }
        out.printf("%n", new Object[0]);
        for (Object primaryKey : this.primaryKeyColumn) {
            needsPadding = false;
            if (this.primaryKeyDisplay) {
                out.printf(primaryKeyFormat, primaryKey);
                needsPadding = true;
            }
            for (String columnName : this.columns.keySet()) {
                if (!((GATKReportColumn)this.columns.get(columnName)).isDisplayable()) continue;
                if (needsPadding) {
                    out.printf("  ", new Object[0]);
                }
                String value = ((GATKReportColumn)this.columns.get(columnName)).getStringValue(primaryKey);
                out.printf((String)columnWidths.get(columnName), value);
                needsPadding = true;
            }
            out.printf("%n", new Object[0]);
        }
        out.printf("%n", new Object[0]);
    }

    public int getNumRows() {
        return this.primaryKeyColumn.size();
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableDescription() {
        return this.tableDescription;
    }

    public GATKReportColumns getColumns() {
        return this.columns;
    }
}

