/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.executive;

import java.lang.management.ManagementFactory;
import java.util.Collection;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.datasources.reads.SAMDataSource;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.datasources.reads.ShardStrategy;
import org.broadinstitute.sting.gatk.datasources.rmd.ReferenceOrderedDataSource;
import org.broadinstitute.sting.gatk.executive.HierarchicalMicroScheduler;
import org.broadinstitute.sting.gatk.executive.LinearMicroScheduler;
import org.broadinstitute.sting.gatk.executive.MicroSchedulerMBean;
import org.broadinstitute.sting.gatk.io.OutputTracker;
import org.broadinstitute.sting.gatk.iterators.NullSAMIterator;
import org.broadinstitute.sting.gatk.iterators.StingSAMIterator;
import org.broadinstitute.sting.gatk.traversals.TraversalEngine;
import org.broadinstitute.sting.gatk.traversals.TraverseDuplicates;
import org.broadinstitute.sting.gatk.traversals.TraverseLoci;
import org.broadinstitute.sting.gatk.traversals.TraverseReadPairs;
import org.broadinstitute.sting.gatk.traversals.TraverseReads;
import org.broadinstitute.sting.gatk.walkers.DuplicateWalker;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.ReadPairWalker;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

public abstract class MicroScheduler
implements MicroSchedulerMBean {
    protected static Logger logger = Logger.getLogger(MicroScheduler.class);
    private static int instanceNumber = 0;
    protected final GenomeAnalysisEngine engine;
    protected final TraversalEngine traversalEngine;
    protected final IndexedFastaSequenceFile reference;
    private final SAMDataSource reads;
    protected final Collection<ReferenceOrderedDataSource> rods;
    private final MBeanServer mBeanServer;
    private final ObjectName mBeanName;

    public static MicroScheduler create(GenomeAnalysisEngine engine, Walker walker, SAMDataSource reads, IndexedFastaSequenceFile reference, Collection<ReferenceOrderedDataSource> rods, int nThreadsToUse) {
        if (walker instanceof TreeReducible && nThreadsToUse > 1) {
            if (walker.isReduceByInterval()) {
                throw new UserException.BadArgumentValue("nt", String.format("The analysis %s aggregates results by interval.  Due to a current limitation of the GATK, analyses of this type do not currently support parallel execution.  Please run your analysis without the -nt option.", engine.getWalkerName(walker.getClass())));
            }
            if (walker instanceof ReadWalker) {
                throw new UserException.BadArgumentValue("nt", String.format("The analysis %s is a read walker.  Due to a current limitation of the GATK, analyses of this type do not currently support parallel execution.  Please run your analysis without the -nt option.", engine.getWalkerName(walker.getClass())));
            }
            logger.info(String.format("Running the GATK in parallel mode with %d concurrent threads", nThreadsToUse));
            return new HierarchicalMicroScheduler(engine, walker, reads, reference, rods, nThreadsToUse);
        }
        if (nThreadsToUse > 1) {
            throw new UserException.BadArgumentValue("nt", String.format("The analysis %s currently does not support parallel execution.  Please run your analysis without the -nt option.", engine.getWalkerName(walker.getClass())));
        }
        return new LinearMicroScheduler(engine, walker, reads, reference, rods);
    }

    protected MicroScheduler(GenomeAnalysisEngine engine, Walker walker, SAMDataSource reads, IndexedFastaSequenceFile reference, Collection<ReferenceOrderedDataSource> rods) {
        this.engine = engine;
        this.reads = reads;
        this.reference = reference;
        this.rods = rods;
        if (walker instanceof ReadWalker) {
            this.traversalEngine = new TraverseReads();
        } else if (walker instanceof LocusWalker) {
            this.traversalEngine = new TraverseLoci();
        } else if (walker instanceof DuplicateWalker) {
            this.traversalEngine = new TraverseDuplicates();
        } else if (walker instanceof ReadPairWalker) {
            this.traversalEngine = new TraverseReadPairs();
        } else {
            throw new UnsupportedOperationException("Unable to determine traversal type, the walker is an unknown type.");
        }
        this.traversalEngine.initialize(engine);
        int thisInstance = instanceNumber++;
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            this.mBeanName = new ObjectName("org.broadinstitute.sting.gatk.executive:type=MicroScheduler,instanceNumber=" + thisInstance);
            this.mBeanServer.registerMBean(this, this.mBeanName);
        }
        catch (JMException ex) {
            throw new ReviewedStingException("Unable to register microscheduler with JMX", ex);
        }
    }

    public abstract Object execute(Walker var1, ShardStrategy var2);

    public abstract OutputTracker getOutputTracker();

    protected StingSAMIterator getReadIterator(Shard shard) {
        return !this.reads.isEmpty() ? this.reads.seek(shard) : new NullSAMIterator();
    }

    protected void printOnTraversalDone(Object sum) {
        this.traversalEngine.printOnTraversalDone();
    }

    public GenomeAnalysisEngine getEngine() {
        return this.engine;
    }

    public SAMDataSource getSAMDataSource() {
        return this.reads;
    }

    public IndexedFastaSequenceFile getReference() {
        return this.reference;
    }

    @Override
    public String getPerformanceLogFileName() {
        return this.traversalEngine.getPerformanceLogFileName();
    }

    @Override
    public void setPerformanceLogFileName(String fileName) {
        this.traversalEngine.setPerformanceLogFileName(fileName);
    }

    @Override
    public long getPerformanceProgressPrintFrequencySeconds() {
        return this.traversalEngine.getPerformanceProgressPrintFrequencySeconds();
    }

    @Override
    public void setPerformanceProgressPrintFrequencySeconds(long seconds) {
        this.traversalEngine.setPerformanceProgressPrintFrequencySeconds(seconds);
    }

    protected void cleanup() {
        try {
            this.mBeanServer.unregisterMBean(this.mBeanName);
        }
        catch (JMException ex) {
            throw new ReviewedStingException("Unable to unregister microscheduler with JMX", ex);
        }
    }
}

