/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.GATKBAMFileSpan;
import net.sf.samtools.SAMFileSpan;
import org.broadinstitute.sting.gatk.datasources.reads.BAMOverlap;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.interval.IntervalMergingRule;
import org.broadinstitute.sting.utils.interval.IntervalUtils;

public class FilePointer {
    protected final SortedMap<SAMReaderID, SAMFileSpan> fileSpans = new TreeMap<SAMReaderID, SAMFileSpan>();
    protected final BAMOverlap overlap;
    protected final List<GenomeLoc> locations;
    protected final boolean isRegionUnmapped;

    public FilePointer() {
        this((BAMOverlap)null);
    }

    public FilePointer(GenomeLoc location) {
        this.overlap = null;
        this.locations = Collections.singletonList(location);
        this.isRegionUnmapped = GenomeLoc.isUnmapped(location);
    }

    public FilePointer(BAMOverlap overlap) {
        this.overlap = overlap;
        this.locations = new ArrayList<GenomeLoc>();
        this.isRegionUnmapped = false;
    }

    public List<GenomeLoc> getLocations() {
        return Collections.unmodifiableList(this.locations);
    }

    public boolean equals(Object other) {
        if (!(other instanceof FilePointer)) {
            return false;
        }
        FilePointer otherFilePointer = (FilePointer)other;
        if (this.locations.size() != otherFilePointer.locations.size()) {
            return false;
        }
        for (int i = 0; i < this.locations.size(); ++i) {
            if (this.locations.get(i).equals(otherFilePointer.locations.get(i))) continue;
            return false;
        }
        if (this.fileSpans.size() != otherFilePointer.fileSpans.size()) {
            return false;
        }
        Iterator<Map.Entry<SAMReaderID, SAMFileSpan>> thisEntries = this.fileSpans.entrySet().iterator();
        Iterator<Map.Entry<SAMReaderID, SAMFileSpan>> otherEntries = otherFilePointer.fileSpans.entrySet().iterator();
        while (thisEntries.hasNext() || otherEntries.hasNext()) {
            if (((Object)thisEntries.next()).equals(otherEntries.next())) continue;
            return false;
        }
        return true;
    }

    public void addLocation(GenomeLoc location) {
        this.locations.add(location);
    }

    public void addFileSpans(SAMReaderID id, SAMFileSpan fileSpan) {
        this.fileSpans.put(id, fileSpan);
    }

    public void addFileSpans(Map<SAMReaderID, GATKBAMFileSpan> fileSpans) {
        this.fileSpans.putAll(fileSpans);
    }

    public long size() {
        long size = 0L;
        for (SAMFileSpan fileSpan : this.fileSpans.values()) {
            size += ((GATKBAMFileSpan)fileSpan).size();
        }
        return size;
    }

    public long minus(FilePointer other) {
        long difference = 0L;
        PeekableIterator<Map.Entry<SAMReaderID, SAMFileSpan>> thisIterator = new PeekableIterator<Map.Entry<SAMReaderID, SAMFileSpan>>(this.fileSpans.entrySet().iterator());
        PeekableIterator<Map.Entry<SAMReaderID, SAMFileSpan>> otherIterator = new PeekableIterator<Map.Entry<SAMReaderID, SAMFileSpan>>(other.fileSpans.entrySet().iterator());
        while (thisIterator.hasNext()) {
            if (!otherIterator.hasNext()) {
                GATKBAMFileSpan nextSpan = (GATKBAMFileSpan)thisIterator.next().getValue();
                difference += nextSpan.size();
                continue;
            }
            int compareValue = thisIterator.peek().getKey().compareTo(otherIterator.peek().getKey());
            if (compareValue < 0) {
                difference += ((GATKBAMFileSpan)thisIterator.next().getValue()).size();
                continue;
            }
            if (compareValue > 0) {
                difference += ((GATKBAMFileSpan)otherIterator.next().getValue()).size();
                continue;
            }
            GATKBAMFileSpan thisRegion = (GATKBAMFileSpan)thisIterator.next().getValue();
            GATKBAMFileSpan otherRegion = (GATKBAMFileSpan)otherIterator.next().getValue();
            difference += Math.abs(thisRegion.minus(otherRegion).size());
        }
        return difference;
    }

    public FilePointer combine(GenomeLocParser parser, FilePointer other) {
        FilePointer combined = new FilePointer();
        ArrayList<GenomeLoc> intervals = new ArrayList<GenomeLoc>();
        intervals.addAll(this.locations);
        intervals.addAll(other.locations);
        for (GenomeLoc interval : IntervalUtils.sortAndMergeIntervals(parser, intervals, IntervalMergingRule.ALL)) {
            combined.addLocation(interval);
        }
        PeekableIterator<Map.Entry<SAMReaderID, SAMFileSpan>> thisIterator = new PeekableIterator<Map.Entry<SAMReaderID, SAMFileSpan>>(this.fileSpans.entrySet().iterator());
        PeekableIterator<Map.Entry<SAMReaderID, SAMFileSpan>> otherIterator = new PeekableIterator<Map.Entry<SAMReaderID, SAMFileSpan>>(other.fileSpans.entrySet().iterator());
        while (thisIterator.hasNext() || otherIterator.hasNext()) {
            int compareValue = !otherIterator.hasNext() ? -1 : (!thisIterator.hasNext() ? 1 : thisIterator.peek().getKey().compareTo(otherIterator.peek().getKey()));
            if (compareValue < 0) {
                this.mergeElementsInto(combined, thisIterator);
                continue;
            }
            if (compareValue > 0) {
                this.mergeElementsInto(combined, otherIterator);
                continue;
            }
            this.mergeElementsInto(combined, thisIterator, otherIterator);
        }
        return combined;
    }

    private void mergeElementsInto(FilePointer combined, Iterator<Map.Entry<SAMReaderID, SAMFileSpan>> ... iterators) {
        if (iterators.length == 0) {
            throw new ReviewedStingException("Tried to add zero elements to an existing file pointer.");
        }
        Map.Entry<SAMReaderID, SAMFileSpan> initialElement = iterators[0].next();
        GATKBAMFileSpan fileSpan = (GATKBAMFileSpan)initialElement.getValue();
        for (int i = 1; i < iterators.length; ++i) {
            fileSpan = fileSpan.union((GATKBAMFileSpan)iterators[i].next().getValue());
        }
        combined.addFileSpans(initialElement.getKey(), fileSpan);
    }
}

