/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.arguments;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.SAMFileReader;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.gatk.DownsampleType;
import org.broadinstitute.sting.gatk.DownsamplingMethod;
import org.broadinstitute.sting.gatk.arguments.ValidationExclusion;
import org.broadinstitute.sting.gatk.phonehome.GATKRunReport;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.interval.IntervalMergingRule;
import org.broadinstitute.sting.utils.interval.IntervalSetRule;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.stream.Format;
import org.simpleframework.xml.stream.HyphenStyle;

@Root
public class GATKArgumentCollection {
    private float versionNumber = 1.0f;
    private String description = "GATK Arguments";
    @ElementMap(entry="analysis_argument", key="key", attribute=true, inline=true, required=false)
    public Map<String, String> walkerArgs = new HashMap<String, String>();
    @ElementList(required=false)
    @Input(fullName="input_file", shortName="I", doc="SAM or BAM file(s)", required=false)
    public List<String> samFiles = new ArrayList<String>();
    @ElementList(required=false)
    @Argument(fullName="sample_metadata", shortName="SM", doc="Sample file(s) in JSON format", required=false)
    public List<File> sampleFiles = new ArrayList<File>();
    @Element(required=false)
    @Argument(fullName="read_buffer_size", shortName="rbs", doc="Number of reads per SAM file to buffer in memory", required=false)
    public Integer readBufferSize = null;
    @Element(required=false)
    @Argument(fullName="phone_home", shortName="et", doc="What kind of GATK run report should we generate?  Standard is the default, can be verbose or NO_ET so nothing is posted to the run repository", required=false)
    public GATKRunReport.PhoneHomeOption phoneHomeType = GATKRunReport.PhoneHomeOption.STANDARD;
    @ElementList(required=false)
    @Argument(fullName="read_filter", shortName="rf", doc="Specify filtration criteria to apply to each read individually.", required=false)
    public List<String> readFilters = new ArrayList<String>();
    @ElementList(required=false)
    @Input(fullName="intervals", shortName="L", doc="A list of genomic intervals over which to operate. Can be explicitly specified on the command line or in a file.", required=false)
    public List<String> intervals = null;
    @ElementList(required=false)
    @Input(fullName="excludeIntervals", shortName="XL", doc="A list of genomic intervals to exclude from processing. Can be explicitly specified on the command line or in a file.", required=false)
    public List<String> excludeIntervals = null;
    @Element(required=false)
    @Input(fullName="reference_sequence", shortName="R", doc="Reference sequence file", required=false)
    public File referenceFile = null;
    @Deprecated
    @Hidden
    @ElementList(required=false)
    @Input(fullName="rodBind", shortName="B", doc="Bindings for reference-ordered data, in the form :<name>,<type> <file>", required=false)
    public ArrayList<String> RODBindings = new ArrayList();
    @Element(required=false)
    @Argument(fullName="rodToIntervalTrackName", shortName="BTI", doc="Indicates that the named track should be converted into an interval list, to drive the traversal", required=false)
    public String RODToInterval = null;
    @Element(required=false)
    @Argument(fullName="BTI_merge_rule", shortName="BTIMR", doc="Indicates the merging approach the interval parser should use to combine the BTI track with other -L options", required=false)
    public IntervalSetRule BTIMergeRule = IntervalSetRule.UNION;
    @Element(required=false)
    @Argument(fullName="nonDeterministicRandomSeed", shortName="ndrs", doc="Makes the GATK behave non deterministically, that is, the random numbers generated will be different in every run", required=false)
    public boolean nonDeterministicRandomSeed = false;
    private static DownsampleType DEFAULT_DOWNSAMPLING_TYPE = DownsampleType.BY_SAMPLE;
    private static int DEFAULT_DOWNSAMPLING_COVERAGE = 1000;
    @Element(required=false)
    @Argument(fullName="downsampling_type", shortName="dt", doc="Type of reads downsampling to employ at a given locus.  Reads will be selected randomly to be removed from the pile based on the method described here.", required=false)
    public DownsampleType downsamplingType = null;
    @Element(required=false)
    @Argument(fullName="downsample_to_fraction", shortName="dfrac", doc="Fraction [0.0-1.0] of reads to downsample to", required=false)
    public Double downsampleFraction = null;
    @Element(required=false)
    @Argument(fullName="downsample_to_coverage", shortName="dcov", doc="Coverage [integer] to downsample to at any given locus; note that downsampled reads are randomly selected from all possible reads at a locus", required=false)
    public Integer downsampleCoverage = null;
    @Element(required=false)
    @Argument(fullName="baq", shortName="baq", doc="Type of BAQ calculation to apply in the engine", required=false)
    public BAQ.CalculationMode BAQMode = BAQ.CalculationMode.OFF;
    @Element(required=false)
    @Argument(fullName="baqGapOpenPenalty", shortName="baqGOP", doc="BAQ gap open penalty (Phred Scaled).  Default value is 40.  30 is perhaps better for whole genome call sets", required=false)
    public double BAQGOP = BAQ.DEFAULT_GOP;
    @Element(required=false)
    @Argument(fullName="performanceLog", shortName="PF", doc="If provided, a GATK runtime performance log will be written to this file", required=false)
    public File performanceLog = null;
    @Element(required=false)
    @Argument(fullName="useOriginalQualities", shortName="OQ", doc="If set, use the original base quality scores from the OQ tag when present instead of the standard scores", required=false)
    public Boolean useOriginalBaseQualities = false;
    @Argument(fullName="defaultBaseQualities", shortName="DBQ", doc="If reads are missing some or all base quality scores, this value will be used for all base quality scores", required=false)
    public byte defaultBaseQualities = (byte)-1;
    @Element(required=false)
    @Argument(fullName="validation_strictness", shortName="S", doc="How strict should we be with validation", required=false)
    public SAMFileReader.ValidationStringency strictnessLevel = SAMFileReader.ValidationStringency.SILENT;
    @Element(required=false)
    @Argument(fullName="unsafe", shortName="U", doc="If set, enables unsafe operations: nothing will be checked at runtime.  For expert users only who know what they are doing.  We do not support usage of this argument.", required=false)
    public ValidationExclusion.TYPE unsafe;
    @Element(required=false)
    @Argument(fullName="num_threads", shortName="nt", doc="How many threads should be allocated to running this analysis.", required=false)
    public int numberOfThreads = 1;
    @Element(required=false)
    @Argument(fullName="interval_merging", shortName="im", doc="What interval merging rule should we use.", required=false)
    public IntervalMergingRule intervalMerging = IntervalMergingRule.ALL;
    @ElementList(required=false)
    @Input(fullName="read_group_black_list", shortName="rgbl", doc="Filters out read groups matching <TAG>:<STRING> or a .txt file containing the filter strings one per line.", required=false)
    public List<String> readGroupBlackList = null;
    @Element(required=false)
    @Argument(fullName="processingTracker", shortName="C", doc="A lockable, shared file for coordinating distributed GATK runs", required=false)
    @Hidden
    public File processingTrackerFile = null;
    @Element(required=false)
    @Argument(fullName="restartProcessingTracker", shortName="RPT", doc="Should we delete the processing tracker file at startup?", required=false)
    @Hidden
    public boolean restartProcessingTracker = false;
    @Element(required=false)
    @Argument(fullName="processingTrackerStatusFile", shortName="CSF", doc="If provided, a detailed accounting of the state of the process tracker is written to this file.  For debugging, only", required=false)
    @Hidden
    public File processingTrackerStatusFile = null;
    @Element(required=false)
    @Argument(fullName="processingTrackerID", shortName="CID", doc="If provided, an integer ID (starting at 1) indicating a unique id for this process within the distributed GATK group", required=false)
    @Hidden
    public int processTrackerID = -1;
    @Element(required=false)
    @Argument(fullName="allow_intervals_with_unindexed_bam", doc="Allow interval processing with an unsupported BAM.  NO INTEGRATION TESTS are available.  Use at your own risk.", required=false)
    @Hidden
    public boolean allowIntervalsWithUnindexedBAM = false;
    @Element(required=false)
    @Argument(fullName="disable_experimental_low_memory_sharding", doc="Disable experimental low-memory sharding functionality.", required=false)
    public boolean disableLowMemorySharding = false;

    public DownsamplingMethod getDownsamplingMethod() {
        if (this.downsamplingType == null && this.downsampleFraction == null && this.downsampleCoverage == null) {
            return null;
        }
        if (this.downsamplingType == null && this.downsampleCoverage != null) {
            return new DownsamplingMethod(DEFAULT_DOWNSAMPLING_TYPE, this.downsampleCoverage, null);
        }
        return new DownsamplingMethod(this.downsamplingType, this.downsampleCoverage, this.downsampleFraction);
    }

    public static DownsamplingMethod getDefaultDownsamplingMethod() {
        return new DownsamplingMethod(DEFAULT_DOWNSAMPLING_TYPE, DEFAULT_DOWNSAMPLING_COVERAGE, null);
    }

    public static void marshal(GATKArgumentCollection collection, String outputFile) {
        Persister serializer = new Persister(new Format(new HyphenStyle()));
        File result = new File(outputFile);
        try {
            serializer.write((Object)collection, result);
        }
        catch (Exception e) {
            throw new ReviewedStingException("Failed to marshal the data to the file " + outputFile, e);
        }
    }

    public static void marshal(GATKArgumentCollection collection, PrintStream outputFile) {
        Persister serializer = new Persister(new Format(new HyphenStyle()));
        try {
            serializer.write((Object)collection, outputFile);
        }
        catch (Exception e) {
            throw new ReviewedStingException("Failed to marshal the data to the file " + outputFile, e);
        }
    }

    public static GATKArgumentCollection unmarshal(String filename) {
        Persister serializer = new Persister(new Format(new HyphenStyle()));
        File source = new File(filename);
        try {
            GATKArgumentCollection example = (GATKArgumentCollection)((Object)serializer.read(GATKArgumentCollection.class, source));
            return example;
        }
        catch (Exception e) {
            throw new ReviewedStingException("Failed to marshal the data from file " + filename, e);
        }
    }

    public static GATKArgumentCollection unmarshal(InputStream file) {
        Persister serializer = new Persister(new Format(new HyphenStyle()));
        try {
            GATKArgumentCollection example = (GATKArgumentCollection)((Object)serializer.read(GATKArgumentCollection.class, file));
            return example;
        }
        catch (Exception e) {
            throw new ReviewedStingException("Failed to marshal the data from file " + file.toString(), e);
        }
    }

    public boolean equals(GATKArgumentCollection other) {
        if (other == null) {
            return false;
        }
        if (other.samFiles.size() != this.samFiles.size()) {
            return false;
        }
        for (int x = 0; x < this.samFiles.size(); ++x) {
            if (this.samFiles.get(x).equals(other.samFiles.get(x))) continue;
            return false;
        }
        if (other.walkerArgs.size() != this.walkerArgs.size()) {
            return false;
        }
        for (String s : this.walkerArgs.keySet()) {
            if (other.walkerArgs.containsKey(s)) continue;
            return false;
        }
        if (!((Object)other.samFiles).equals(this.samFiles)) {
            return false;
        }
        if (other.readBufferSize == null || this.readBufferSize == null ? other.readBufferSize != null || this.readBufferSize != null : !other.readBufferSize.equals(this.readBufferSize)) {
            return false;
        }
        if (!(other.readBufferSize == null && this.readBufferSize == null || other.readBufferSize != null && this.readBufferSize != null)) {
            return false;
        }
        if (!other.strictnessLevel.equals((Object)this.strictnessLevel)) {
            return false;
        }
        if (!other.referenceFile.equals(this.referenceFile)) {
            return false;
        }
        if (!((Object)other.intervals).equals(this.intervals)) {
            return false;
        }
        if (!((Object)other.excludeIntervals).equals(this.excludeIntervals)) {
            return false;
        }
        if (!other.unsafe.equals((Object)this.unsafe)) {
            return false;
        }
        if (other.downsampleFraction == null && this.downsampleFraction != null || other.downsampleFraction != null && !other.downsampleFraction.equals(this.downsampleFraction)) {
            return false;
        }
        if (other.downsampleCoverage == null && this.downsampleCoverage != null || other.downsampleCoverage != null && !other.downsampleCoverage.equals(this.downsampleCoverage)) {
            return false;
        }
        if (other.numberOfThreads != this.numberOfThreads) {
            return false;
        }
        if (other.intervalMerging != this.intervalMerging) {
            return false;
        }
        if (other.RODToInterval == null && this.RODToInterval != null || other.RODToInterval != null && !other.RODToInterval.equals(this.RODToInterval)) {
            return false;
        }
        if (other.phoneHomeType != this.phoneHomeType) {
            return false;
        }
        if (this.BTIMergeRule != other.BTIMergeRule) {
            return false;
        }
        if (this.BAQMode != other.BAQMode) {
            return false;
        }
        if (this.BAQGOP != other.BAQGOP) {
            return false;
        }
        if (other.performanceLog == null && this.performanceLog != null || other.performanceLog != null && !other.performanceLog.equals(this.performanceLog)) {
            return false;
        }
        if (other.processingTrackerFile == null && this.processingTrackerFile != null || other.processingTrackerFile != null && !other.processingTrackerFile.equals(this.processingTrackerFile)) {
            return false;
        }
        if (other.processingTrackerStatusFile == null && this.processingTrackerStatusFile != null || other.processingTrackerStatusFile != null && !other.processingTrackerStatusFile.equals(this.processingTrackerStatusFile)) {
            return false;
        }
        if (this.restartProcessingTracker != other.restartProcessingTracker) {
            return false;
        }
        if (this.processTrackerID != other.processTrackerID) {
            return false;
        }
        if (this.allowIntervalsWithUnindexedBAM != other.allowIntervalsWithUnindexedBAM) {
            return false;
        }
        return this.disableLowMemorySharding == other.disableLowMemorySharding;
    }
}

