/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.commandline;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import org.broadinstitute.sting.commandline.ArgumentDefinition;
import org.broadinstitute.sting.commandline.ArgumentMatches;
import org.broadinstitute.sting.commandline.ArgumentSource;
import org.broadinstitute.sting.commandline.ArgumentTypeDescriptor;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.commandline.Tags;
import org.broadinstitute.sting.gatk.refdata.tracks.FeatureManager;
import org.broadinstitute.sting.utils.classloader.JVMUtils;
import org.broadinstitute.sting.utils.exceptions.UserException;

class RodBindingArgumentTypeDescriptor
extends ArgumentTypeDescriptor {
    RodBindingArgumentTypeDescriptor() {
    }

    @Override
    public boolean supports(Class type) {
        return RodBindingArgumentTypeDescriptor.isRodBinding(type);
    }

    public static boolean isRodBinding(Class type) {
        return RodBinding.class.isAssignableFrom(type);
    }

    @Override
    public boolean createsTypeDefault(ArgumentSource source) {
        return !source.isRequired();
    }

    @Override
    public Object createTypeDefault(ParsingEngine parsingEngine, ArgumentSource source, Type type) {
        Class parameterType = JVMUtils.getParameterizedTypeClass(type);
        return RodBinding.makeUnbound(parameterType);
    }

    @Override
    public String typeDefaultDocString(ArgumentSource source) {
        return "none";
    }

    @Override
    public Object parse(ParsingEngine parsingEngine, ArgumentSource source, Type type, ArgumentMatches matches) {
        ArgumentDefinition defaultDefinition = this.createDefaultArgumentDefinition(source);
        String value = this.getArgumentValue(defaultDefinition, matches);
        Class parameterType = JVMUtils.getParameterizedTypeClass(type);
        try {
            String name = defaultDefinition.fullName;
            String tribbleType = null;
            Tags tags = this.getArgumentTags(matches);
            if (tags.getPositionalTags().size() > 2) {
                throw new UserException.CommandLineException(String.format("Unexpected number of positional tags for argument %s : %s. Rod bindings only suport -X:type and -X:name,type argument styles", value, source.field.getName()));
            }
            if (tags.getPositionalTags().size() == 2) {
                name = tags.getPositionalTags().get(0);
                tribbleType = tags.getPositionalTags().get(1);
            } else {
                String tag1;
                FeatureManager manager = new FeatureManager();
                String string = tag1 = tags.getPositionalTags().size() == 1 ? tags.getPositionalTags().get(0) : null;
                if (tag1 != null) {
                    if (manager.getByName(tag1) != null) {
                        tribbleType = tag1;
                    } else {
                        name = tag1;
                    }
                }
                if (tribbleType == null) {
                    FeatureManager.FeatureDescriptor featureDescriptor;
                    File file = new File(value);
                    if (file.canRead() && file.isFile() && (featureDescriptor = manager.getByFiletype(file)) != null) {
                        tribbleType = featureDescriptor.getName();
                        logger.info("Dynamically determined type of " + file + " to be " + tribbleType);
                    }
                    if (tribbleType == null) {
                        if (!file.canRead() | !file.isFile()) {
                            throw new UserException.BadArgumentValue(name, "Couldn't read file to determine type: " + file);
                        }
                        throw new UserException.CommandLineException(String.format("No tribble type was provided on the command line and the type of the file could not be determined dynamically. Please add an explicit type tag :NAME listing the correct type from among the supported types:%n%s", manager.userFriendlyListOfAvailableFeatures(parameterType)));
                    }
                }
            }
            Constructor ctor = this.makeRawTypeIfNecessary(type).getConstructor(Class.class, String.class, String.class, String.class, Tags.class);
            RodBinding result = (RodBinding)ctor.newInstance(parameterType, name, value, tribbleType, tags);
            parsingEngine.addTags(result, tags);
            parsingEngine.addRodBinding(result);
            return result;
        }
        catch (InvocationTargetException e) {
            throw new UserException.CommandLineException(String.format("Failed to parse value %s for argument %s.", value, source.field.getName()));
        }
        catch (Exception e) {
            throw new UserException.CommandLineException(String.format("Failed to parse value %s for argument %s. Message: %s", value, source.field.getName(), e.getMessage()));
        }
    }
}

