/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pileup;

import java.util.Arrays;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.utils.pileup.PileupElement;

public class ExtendedEventPileupElement
extends PileupElement {
    private Type type = null;
    private int eventLength = -1;
    private String eventBases = null;
    private SAMRecord read;
    private int offset;

    public ExtendedEventPileupElement(SAMRecord read, int offset, int length, byte[] eventBases) {
        super(read, offset);
        this.eventLength = length;
        if (length <= 0) {
            this.type = Type.NOEVENT;
        } else if (eventBases != null) {
            this.eventBases = new String(eventBases).toUpperCase();
            this.type = Type.INSERTION;
        } else {
            this.type = Type.DELETION;
        }
    }

    public ExtendedEventPileupElement(SAMRecord read, int offset, int length) {
        this(read, offset, length, null);
    }

    @Override
    public boolean isDeletion() {
        return this.type == Type.DELETION;
    }

    public boolean isInsertion() {
        return this.type == Type.INSERTION;
    }

    public boolean isIndel() {
        return this.isDeletion() || this.isInsertion();
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public byte getBase() {
        return this.getBase(this.offset >= 0 ? this.offset : this.offset + this.eventLength);
    }

    @Override
    public int getBaseIndex() {
        return this.getBaseIndex(this.offset >= 0 ? this.offset : this.offset + this.eventLength);
    }

    @Override
    public byte getQual() {
        return this.getQual(this.offset >= 0 ? this.offset : this.offset + this.eventLength);
    }

    public int getEventLength() {
        return this.eventLength;
    }

    public String getEventBases() {
        return this.eventBases;
    }

    @Override
    public String toString() {
        char c = '.';
        String fillStr = null;
        if (this.isDeletion()) {
            c = '-';
            char[] filler = new char[this.eventLength];
            Arrays.fill(filler, 'D');
            fillStr = new String(filler);
        } else if (this.isInsertion()) {
            c = '+';
        }
        Object[] objectArray = new Object[5];
        objectArray[0] = this.getRead().getReadName();
        objectArray[1] = this.getOffset();
        objectArray[2] = Character.valueOf(c);
        objectArray[3] = this.isIndel() ? (this.isInsertion() ? this.eventBases : fillStr) : "";
        objectArray[4] = this.getMappingQual();
        return String.format("%s @ %d = %c%s MQ%d", objectArray);
    }

    public static enum Type {
        NOEVENT,
        DELETION,
        INSERTION;

    }
}

