/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.vcf;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.broad.tribble.Tribble;
import org.broad.tribble.TribbleException;
import org.broad.tribble.index.DynamicIndexCreator;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.util.LittleEndianOutputStream;
import org.broad.tribble.util.ParsingUtils;
import org.broad.tribble.util.PositionalStream;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFilterHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFFormatHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineCount;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderVersion;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class StandardVCFWriter
implements VCFWriter {
    protected VCFHeader mHeader = null;
    protected BufferedWriter mWriter;
    protected PositionalStream positionalStream = null;
    protected boolean filtersWereAppliedToContext = false;
    protected boolean doNotWriteGenotypes = false;
    protected DynamicIndexCreator indexer = null;
    protected File indexFile = null;
    LittleEndianOutputStream idxStream = null;
    File location = null;

    public StandardVCFWriter(File location) {
        this(location, StandardVCFWriter.openOutputStream(location), true, false);
    }

    public StandardVCFWriter(File location, boolean enableOnTheFlyIndexing) {
        this(location, StandardVCFWriter.openOutputStream(location), enableOnTheFlyIndexing, false);
    }

    public StandardVCFWriter(OutputStream output) {
        this(output, false);
    }

    public StandardVCFWriter(OutputStream output, boolean doNotWriteGenotypes) {
        this.mWriter = new BufferedWriter(new OutputStreamWriter(output));
        this.doNotWriteGenotypes = doNotWriteGenotypes;
    }

    public StandardVCFWriter(File location, OutputStream output, boolean enableOnTheFlyIndexing, boolean doNotWriteGenotypes) {
        this.location = location;
        if (enableOnTheFlyIndexing) {
            this.indexFile = Tribble.indexFile(location);
            try {
                this.idxStream = new LittleEndianOutputStream(new FileOutputStream(this.indexFile));
                this.indexer = new DynamicIndexCreator(IndexFactory.IndexBalanceApproach.FOR_SEEK_TIME);
                this.indexer.initialize(location, this.indexer.defaultBinSize());
                this.positionalStream = new PositionalStream(output);
                output = this.positionalStream;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        this.mWriter = new BufferedWriter(new OutputStreamWriter(output));
        this.doNotWriteGenotypes = doNotWriteGenotypes;
    }

    @Override
    public void writeHeader(VCFHeader header) {
        this.mHeader = this.doNotWriteGenotypes ? new VCFHeader(header.getMetaData()) : header;
        try {
            this.mWriter.write("##" + VCFHeaderVersion.VCF4_1.getFormatString() + "=" + VCFHeaderVersion.VCF4_1.getVersionString() + "\n");
            for (VCFHeaderLine line : this.mHeader.getMetaData()) {
                if (VCFHeaderVersion.isFormatString(line.getKey())) continue;
                if (line instanceof VCFFilterHeaderLine) {
                    this.filtersWereAppliedToContext = true;
                }
                this.mWriter.write("##");
                this.mWriter.write(line.toString());
                this.mWriter.write("\n");
            }
            this.mWriter.write("#");
            for (VCFHeader.HEADER_FIELDS field : this.mHeader.getHeaderFields()) {
                this.mWriter.write(field.toString());
                this.mWriter.write("\t");
            }
            if (this.mHeader.hasGenotypingData()) {
                this.mWriter.write("FORMAT");
                for (String sample : this.mHeader.getGenotypeSamples()) {
                    this.mWriter.write("\t");
                    this.mWriter.write(sample);
                }
            }
            this.mWriter.write("\n");
            this.mWriter.flush();
        }
        catch (IOException e) {
            throw new TribbleException("IOException writing the VCF header to " + this.locationString(), e);
        }
    }

    private String locationString() {
        return this.location == null ? this.mWriter.toString() : this.location.getAbsolutePath();
    }

    @Override
    public void close() {
        try {
            this.mWriter.flush();
            this.mWriter.close();
        }
        catch (IOException e) {
            throw new TribbleException("Unable to close " + this.locationString() + " because of " + e.getMessage());
        }
        if (this.indexer != null) {
            try {
                Index index = this.indexer.finalizeIndex(this.positionalStream.getPosition());
                index.write(this.idxStream);
                this.idxStream.close();
            }
            catch (IOException e) {
                throw new TribbleException("Unable to close index for " + this.locationString() + " because of " + e.getMessage());
            }
        }
    }

    protected static OutputStream openOutputStream(File location) {
        try {
            return new FileOutputStream(location);
        }
        catch (FileNotFoundException e) {
            throw new TribbleException("Unable to create VCF file at location: " + location);
        }
    }

    @Override
    public void add(VariantContext vc) {
        this.add(vc, false);
    }

    public void add(VariantContext vc, boolean refBaseShouldBeAppliedToEndOfAlleles) {
        if (this.mHeader == null) {
            throw new IllegalStateException("The VCF Header must be written before records can be added: " + this.locationString());
        }
        if (this.doNotWriteGenotypes) {
            vc = VariantContext.modifyGenotypes(vc, null);
        }
        try {
            vc = VariantContext.createVariantContextWithPaddedAlleles(vc, refBaseShouldBeAppliedToEndOfAlleles);
            if (this.indexer != null) {
                this.indexer.addFeature(vc, this.positionalStream.getPosition());
            }
            HashMap<Allele, String> alleleMap = new HashMap<Allele, String>(vc.getAlleles().size());
            alleleMap.put(Allele.NO_CALL, ".");
            this.mWriter.write(vc.getChr());
            this.mWriter.write("\t");
            this.mWriter.write(String.valueOf(vc.getStart()));
            this.mWriter.write("\t");
            String ID2 = vc.hasID() ? vc.getID() : ".";
            this.mWriter.write(ID2);
            this.mWriter.write("\t");
            alleleMap.put(vc.getReference(), "0");
            String refString = vc.getReference().getDisplayString();
            this.mWriter.write(refString);
            this.mWriter.write("\t");
            if (vc.isVariant()) {
                Allele altAllele = vc.getAlternateAllele(0);
                alleleMap.put(altAllele, "1");
                String alt = altAllele.getDisplayString();
                this.mWriter.write(alt);
                for (int i = 1; i < vc.getAlternateAlleles().size(); ++i) {
                    altAllele = vc.getAlternateAllele(i);
                    alleleMap.put(altAllele, String.valueOf(i + 1));
                    alt = altAllele.getDisplayString();
                    this.mWriter.write(",");
                    this.mWriter.write(alt);
                }
            } else {
                this.mWriter.write(".");
            }
            this.mWriter.write("\t");
            if (!vc.hasNegLog10PError()) {
                this.mWriter.write(".");
            } else {
                this.mWriter.write(this.getQualValue(vc.getPhredScaledQual()));
            }
            this.mWriter.write("\t");
            String filters = vc.isFiltered() ? ParsingUtils.join(";", ParsingUtils.sortList(vc.getFilters())) : (this.filtersWereAppliedToContext || vc.filtersWereApplied() ? "PASS" : ".");
            this.mWriter.write(filters);
            this.mWriter.write("\t");
            TreeMap<String, String> infoFields = new TreeMap<String, String>();
            for (Map.Entry<String, Object> field : vc.getAttributes().entrySet()) {
                String outputValue;
                String key = field.getKey();
                if (key.equals("ID") || key.equals("_UNPARSED_GENOTYPE_MAP_") || key.equals("_UNPARSED_GENOTYPE_PARSER_") || (outputValue = StandardVCFWriter.formatVCFField(field.getValue())) == null) continue;
                infoFields.put(key, outputValue);
            }
            this.writeInfoString(infoFields);
            if (vc.hasAttribute("_UNPARSED_GENOTYPE_MAP_")) {
                this.mWriter.write("\t");
                this.mWriter.write(vc.getAttributeAsString("_UNPARSED_GENOTYPE_MAP_", ""));
            } else {
                ArrayList<String> genotypeAttributeKeys = new ArrayList<String>();
                if (vc.hasGenotypes()) {
                    genotypeAttributeKeys.addAll(StandardVCFWriter.calcVCFGenotypeKeys(vc));
                } else if (this.mHeader.hasGenotypingData()) {
                    genotypeAttributeKeys.add("GT");
                }
                if (genotypeAttributeKeys.size() > 0) {
                    String genotypeFormatString = ParsingUtils.join(":", genotypeAttributeKeys);
                    this.mWriter.write("\t");
                    this.mWriter.write(genotypeFormatString);
                    this.addGenotypeData(vc, alleleMap, genotypeAttributeKeys);
                }
            }
            this.mWriter.write("\n");
            this.mWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write the VCF object to " + this.locationString());
        }
    }

    private String getQualValue(double qual) {
        String s = String.format("%.2f", qual);
        if (s.endsWith(".00")) {
            s = s.substring(0, s.length() - ".00".length());
        }
        return s;
    }

    private void writeInfoString(Map<String, String> infoFields) throws IOException {
        if (infoFields.isEmpty()) {
            this.mWriter.write(".");
            return;
        }
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : infoFields.entrySet()) {
            VCFInfoHeaderLine metaData;
            if (isFirst) {
                isFirst = false;
            } else {
                this.mWriter.write(";");
            }
            String key = entry.getKey();
            this.mWriter.write(key);
            if (entry.getValue().equals("") || (metaData = this.mHeader.getInfoHeaderLine(key)) != null && metaData.getCountType() == VCFHeaderLineCount.INTEGER && metaData.getCount() == 0) continue;
            this.mWriter.write("=");
            this.mWriter.write(entry.getValue());
        }
    }

    private void addGenotypeData(VariantContext vc, Map<Allele, String> alleleMap, List<String> genotypeFormatKeys) throws IOException {
        for (String sample : this.mHeader.getGenotypeSamples()) {
            int i;
            this.mWriter.write("\t");
            Genotype g = vc.getGenotype(sample);
            if (g == null) {
                this.mWriter.write("./.");
                continue;
            }
            ArrayList<String> attrs = new ArrayList<String>(genotypeFormatKeys.size());
            for (String key : genotypeFormatKeys) {
                String outputValue;
                int numInFormatField;
                String val;
                if (key.equals("GT")) {
                    if (!g.isAvailable()) {
                        throw new ReviewedStingException("GTs cannot be missing for some samples if they are available for others in the record");
                    }
                    this.writeAllele(g.getAllele(0), alleleMap);
                    for (int i2 = 1; i2 < g.getPloidy(); ++i2) {
                        this.mWriter.write(g.isPhased() ? "|" : "/");
                        this.writeAllele(g.getAllele(i2), alleleMap);
                    }
                    continue;
                }
                String string = val = g.hasAttribute(key) ? g.getAttribute(key) : ".";
                if (key.equals("GQ")) {
                    val = Math.abs(g.getNegLog10PError() - -1.0) < 1.0E-6 ? "." : this.getQualValue(Math.min(g.getPhredScaledQual(), 99.0));
                } else if (key.equals("FT")) {
                    val = g.isFiltered() ? ParsingUtils.join(";", ParsingUtils.sortList(g.getFilters())) : (g.filtersWereApplied() ? "PASS" : ".");
                }
                VCFFormatHeaderLine metaData = this.mHeader.getFormatHeaderLine(key);
                if (metaData != null && (numInFormatField = metaData.getCount(vc.getAlternateAlleles().size())) > 1 && val.equals(".")) {
                    StringBuilder sb = new StringBuilder(".");
                    for (int i3 = 1; i3 < numInFormatField; ++i3) {
                        sb.append(",");
                        sb.append(".");
                    }
                    val = sb.toString();
                }
                if ((outputValue = StandardVCFWriter.formatVCFField(val)) == null) continue;
                attrs.add(outputValue);
            }
            for (i = attrs.size() - 1; i >= 0 && this.isMissingValue((String)attrs.get(i)); --i) {
                attrs.remove(i);
            }
            for (i = 0; i < attrs.size(); ++i) {
                if (i > 0 || genotypeFormatKeys.contains("GT")) {
                    this.mWriter.write(":");
                }
                this.mWriter.write((String)attrs.get(i));
            }
        }
    }

    private boolean isMissingValue(String s) {
        return StandardVCFWriter.countOccurrences(".".charAt(0), s) + StandardVCFWriter.countOccurrences(',', s) == s.length();
    }

    private void writeAllele(Allele allele, Map<Allele, String> alleleMap) throws IOException {
        String encoding = alleleMap.get(allele);
        if (encoding == null) {
            throw new TribbleException.InternalCodecException("Allele " + allele + " is not an allele in the variant context");
        }
        this.mWriter.write(encoding);
    }

    private static String formatVCFField(Object val) {
        String result;
        if (val == null) {
            result = ".";
        } else if (val instanceof Double) {
            result = String.format("%.2f", (Double)val);
        } else if (val instanceof Boolean) {
            result = (Boolean)val != false ? "" : null;
        } else if (val instanceof List) {
            result = StandardVCFWriter.formatVCFField(((List)val).toArray());
        } else if (val.getClass().isArray()) {
            int length = Array.getLength(val);
            if (length == 0) {
                return StandardVCFWriter.formatVCFField(null);
            }
            StringBuffer sb = new StringBuffer(StandardVCFWriter.formatVCFField(Array.get(val, 0)));
            for (int i = 1; i < length; ++i) {
                sb.append(",");
                sb.append(StandardVCFWriter.formatVCFField(Array.get(val, i)));
            }
            result = sb.toString();
        } else {
            result = val.toString();
        }
        return result;
    }

    private static List<String> calcVCFGenotypeKeys(VariantContext vc) {
        HashSet<String> keys = new HashSet<String>();
        boolean sawGoodGT = false;
        boolean sawGoodQual = false;
        boolean sawGenotypeFilter = false;
        for (Genotype g : vc.getGenotypes().values()) {
            keys.addAll(g.getAttributes().keySet());
            if (g.isAvailable()) {
                sawGoodGT = true;
            }
            if (g.hasNegLog10PError()) {
                sawGoodQual = true;
            }
            if (!g.isFiltered() || !g.isCalled()) continue;
            sawGenotypeFilter = true;
        }
        if (sawGoodQual) {
            keys.add("GQ");
        }
        if (sawGenotypeFilter) {
            keys.add("FT");
        }
        List<String> sortedList = ParsingUtils.sortList(new ArrayList(keys));
        if (sawGoodGT) {
            ArrayList<String> newList = new ArrayList<String>(sortedList.size() + 1);
            newList.add("GT");
            newList.addAll(sortedList);
            sortedList = newList;
        }
        return sortedList;
    }

    public static int countOccurrences(char c, String s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            count += s.charAt(i) == c ? 1 : 0;
        }
        return count;
    }
}

