/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantutils;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.commandline.Advanced;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.arguments.StandardVariantContextInputArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class VariantsToTable
extends RodWalker<Integer, Integer> {
    @ArgumentCollection
    protected StandardVariantContextInputArgumentCollection variantCollection = new StandardVariantContextInputArgumentCollection();
    @Output(doc="File to which results should be written", required=true)
    protected PrintStream out;
    @Argument(fullName="fields", shortName="F", doc="The name of each field to capture for output in the table", required=true)
    public List<String> fieldsToTake = new ArrayList<String>();
    @Advanced
    @Argument(fullName="showFiltered", shortName="raw", doc="If provided, field values from filtered records will be included in the output", required=false)
    public boolean showFiltered = false;
    @Advanced
    @Argument(fullName="maxRecords", shortName="M", doc="If provided, we will emit at most maxRecord records to the table", required=false)
    public int MAX_RECORDS = -1;
    int nRecords = 0;
    @Advanced
    @Argument(fullName="keepMultiAllelic", shortName="KMA", doc="If provided, we will not require the site to be biallelic", required=false)
    public boolean keepMultiAllelic = false;
    @Hidden
    @Argument(fullName="logACSum", shortName="logACSum", doc="Log sum of AC instead of max value in case of multiallelic variants", required=false)
    public boolean logACSum = false;
    @Advanced
    @Argument(fullName="allowMissingData", shortName="AMD", doc="If provided, we will not require every record to contain every field", required=false)
    public boolean ALLOW_MISSING_DATA = false;
    public static Map<String, Getter> getters = new HashMap<String, Getter>();

    @Override
    public void initialize() {
        this.out.println(Utils.join("\t", this.fieldsToTake));
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return 0;
        }
        for (VariantContext vc : tracker.getValues(this.variantCollection.variants, context.getLocation())) {
            if (!this.keepMultiAllelic && !vc.isBiallelic() || !this.showFiltered && !vc.isNotFiltered()) continue;
            List<String> vals = VariantsToTable.extractFields(vc, this.fieldsToTake, this.ALLOW_MISSING_DATA, this.keepMultiAllelic, this.logACSum);
            this.out.println(Utils.join("\t", vals));
        }
        return 1;
    }

    @Override
    public boolean isDone() {
        boolean done;
        boolean bl = done = this.MAX_RECORDS != -1 && this.nRecords >= this.MAX_RECORDS;
        if (done) {
            logger.warn("isDone() will return true to leave after " + this.nRecords + " records");
        }
        return done;
    }

    private static final boolean isWildCard(String s) {
        return s.endsWith("*");
    }

    private static List<String> extractFields(VariantContext vc, List<String> fields, boolean allowMissingData, boolean kma, boolean logsum) {
        ArrayList<String> vals = new ArrayList<String>();
        for (String field : fields) {
            String val = "NA";
            if (getters.containsKey(field)) {
                val = getters.get(field).get(vc);
            } else if (vc.hasAttribute(field)) {
                val = vc.getAttributeAsString(field);
            } else if (VariantsToTable.isWildCard(field)) {
                HashSet<String> wildVals = new HashSet<String>();
                for (Map.Entry<String, Object> elt : vc.getAttributes().entrySet()) {
                    if (!elt.getKey().startsWith(field.substring(0, field.length() - 1))) continue;
                    wildVals.add(elt.getValue().toString());
                }
                if (wildVals.size() > 0) {
                    ArrayList toVal = new ArrayList(wildVals);
                    Collections.sort(toVal);
                    val = Utils.join(",", toVal);
                }
            } else if (!allowMissingData) {
                throw new UserException(String.format("Missing field %s in vc %s at %s", field, vc.getSource(), vc));
            }
            if (field.equals("AF") || field.equals("AC")) {
                String afo = val;
                double af = 0.0;
                if (afo.contains(",")) {
                    String[] afs = afo.split(",");
                    afs[0] = afs[0].substring(1, afs[0].length());
                    afs[afs.length - 1] = afs[afs.length - 1].substring(0, afs[afs.length - 1].length() - 1);
                    double[] afd = new double[afs.length];
                    for (int k = 0; k < afd.length; ++k) {
                        afd[k] = Double.valueOf(afs[k]);
                    }
                    af = kma && logsum ? MathUtils.sum(afd) : MathUtils.arrayMax(afd);
                } else if (!afo.equals("NA")) {
                    af = Double.valueOf(afo);
                }
                val = Double.toString(af);
            }
            vals.add(val);
        }
        return vals;
    }

    public static List<String> extractFields(VariantContext vc, List<String> fields, boolean allowMissingData) {
        return VariantsToTable.extractFields(vc, fields, allowMissingData, false, false);
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer counter, Integer sum) {
        return counter + sum;
    }

    @Override
    public void onTraversalDone(Integer sum) {
    }

    static {
        getters.put("CHROM", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return vc.getChr();
            }
        });
        getters.put("POS", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getStart());
            }
        });
        getters.put("REF", new Getter(){

            @Override
            public String get(VariantContext vc) {
                String x = "";
                if (vc.hasReferenceBaseForIndel() && !vc.isSNP()) {
                    Byte refByte = vc.getReferenceBaseForIndel();
                    x = x + new String(new byte[]{refByte});
                }
                return x + vc.getReference().getDisplayString();
            }
        });
        getters.put("ALT", new Getter(){

            @Override
            public String get(VariantContext vc) {
                StringBuilder x = new StringBuilder();
                int n = vc.getAlternateAlleles().size();
                if (n == 0) {
                    return ".";
                }
                if (vc.hasReferenceBaseForIndel() && !vc.isSNP()) {
                    Byte refByte = vc.getReferenceBaseForIndel();
                    x.append(new String(new byte[]{refByte}));
                }
                for (int i = 0; i < n; ++i) {
                    if (i != 0) {
                        x.append(",");
                    }
                    x.append(vc.getAlternateAllele(i).getDisplayString());
                }
                return x.toString();
            }
        });
        getters.put("QUAL", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Double.toString(vc.getPhredScaledQual());
            }
        });
        getters.put("TRANSITION", new Getter(){

            @Override
            public String get(VariantContext vc) {
                if (vc.isSNP() && vc.isBiallelic()) {
                    return VariantContextUtils.isTransition(vc) ? "1" : "0";
                }
                return "-1";
            }
        });
        getters.put("FILTER", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return vc.isNotFiltered() ? "PASS" : Utils.join(",", vc.getFilters());
            }
        });
        getters.put("HET", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getHetCount());
            }
        });
        getters.put("HOM-REF", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getHomRefCount());
            }
        });
        getters.put("HOM-VAR", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getHomVarCount());
            }
        });
        getters.put("NO-CALL", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getNoCallCount());
            }
        });
        getters.put("VAR", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getHetCount() + vc.getHomVarCount());
            }
        });
        getters.put("NSAMPLES", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getNSamples());
            }
        });
        getters.put("NCALLED", new Getter(){

            @Override
            public String get(VariantContext vc) {
                return Integer.toString(vc.getNSamples() - vc.getNoCallCount());
            }
        });
        getters.put("GQ", new Getter(){

            @Override
            public String get(VariantContext vc) {
                if (vc.getNSamples() > 1) {
                    throw new UserException("Cannot get GQ values for multi-sample VCF");
                }
                return String.format("%.2f", 10.0 * vc.getGenotype(0).getNegLog10PError());
            }
        });
    }

    public static abstract class Getter {
        public abstract String get(VariantContext var1);
    }
}

