/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantrecalibration;

import java.util.List;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.walkers.variantrecalibration.GaussianMixtureModel;
import org.broadinstitute.sting.gatk.walkers.variantrecalibration.VariantDatum;
import org.broadinstitute.sting.gatk.walkers.variantrecalibration.VariantRecalibratorArgumentCollection;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class VariantRecalibratorEngine {
    protected static final Logger logger = Logger.getLogger(VariantRecalibratorEngine.class);
    public static final double MIN_ACCEPTABLE_LOD_SCORE = -20000.0;
    private final VariantRecalibratorArgumentCollection VRAC;
    private static final double MIN_PROB_CONVERGENCE = 0.02;

    public VariantRecalibratorEngine(VariantRecalibratorArgumentCollection VRAC) {
        this.VRAC = VRAC;
    }

    public GaussianMixtureModel generateModel(List<VariantDatum> data) {
        GaussianMixtureModel model = new GaussianMixtureModel(this.VRAC.MAX_GAUSSIANS, data.get((int)0).annotations.length, this.VRAC.SHRINKAGE, this.VRAC.DIRICHLET_PARAMETER, this.VRAC.PRIOR_COUNTS);
        this.variationalBayesExpectationMaximization(model, data);
        return model;
    }

    public void evaluateData(List<VariantDatum> data, GaussianMixtureModel model, boolean evaluateContrastively) {
        if (!model.isModelReadyForEvaluation) {
            model.precomputeDenominatorForEvaluation();
        }
        logger.info("Evaluating full set of " + data.size() + " variants...");
        for (VariantDatum datum : data) {
            double thisLod = this.evaluateDatum(datum, model);
            if (Double.isNaN(thisLod)) {
                throw new UserException("NaN LOD value assigned. Clustering with this few variants and these annotations is unsafe. Please consider raising the number of variants used to train the negative model (via --percentBadVariants 0.05, for example) or lowering the maximum number of Gaussians to use in the model (via --maxGaussians 4, for example)");
            }
            datum.lod = evaluateContrastively ? (Double.isInfinite(datum.lod) ? -20000.0 + GenomeAnalysisEngine.getRandomGenerator().nextDouble() * -20000.0 : datum.prior + datum.lod - thisLod) : thisLod;
        }
    }

    public void calculateWorstPerformingAnnotation(List<VariantDatum> data, GaussianMixtureModel goodModel, GaussianMixtureModel badModel) {
        for (VariantDatum datum : data) {
            int worstAnnotation = -1;
            double minProb = Double.MAX_VALUE;
            for (int iii = 0; iii < datum.annotations.length; ++iii) {
                double prob;
                Double goodProbLog10 = goodModel.evaluateDatumInOneDimension(datum, iii);
                Double badProbLog10 = badModel.evaluateDatumInOneDimension(datum, iii);
                if (goodProbLog10 == null || badProbLog10 == null || !((prob = goodProbLog10 - badProbLog10) < minProb)) continue;
                minProb = prob;
                worstAnnotation = iii;
            }
            datum.worstAnnotation = worstAnnotation;
        }
    }

    private void variationalBayesExpectationMaximization(GaussianMixtureModel model, List<VariantDatum> data) {
        model.initializeRandomModel(data, this.VRAC.NUM_KMEANS_ITERATIONS);
        model.normalizePMixtureLog10();
        model.expectationStep(data);
        int iteration = 0;
        logger.info("Finished iteration " + iteration + ".");
        while (iteration < this.VRAC.MAX_ITERATIONS) {
            model.maximizationStep(data);
            double currentChangeInMixtureCoefficients = model.normalizePMixtureLog10();
            model.expectationStep(data);
            if (++iteration % 5 == 0) {
                logger.info("Finished iteration " + iteration + ". \tCurrent change in mixture coefficients = " + String.format("%.5f", currentChangeInMixtureCoefficients));
            }
            if (iteration <= 2 || !(currentChangeInMixtureCoefficients < 0.02)) continue;
            logger.info("Convergence after " + iteration + " iterations!");
            break;
        }
        model.evaluateFinalModelParameters(data);
    }

    private double evaluateDatum(VariantDatum datum, GaussianMixtureModel model) {
        return model.evaluateDatum(datum);
    }
}

