/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantrecalibration;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.text.XReadLines;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class VQSRCalibrationCurve {
    private static final boolean DEBUG = false;
    List<VQSRRange> points;
    public static final double CERTAIN_FALSE_POSITIVE = -1.0;

    public static VQSRCalibrationCurve readFromFile(File source) {
        ArrayList<VQSRRange> points = new ArrayList<VQSRRange>();
        try {
            for (String line : new XReadLines(source).readLines()) {
                if (line.trim().isEmpty()) continue;
                String[] parts = line.split("\\s+");
                double fpRate = Double.parseDouble(parts[2]);
                double tpRate = fpRate >= 1.0 ? -1.0 : 1.0 - fpRate;
                points.add(new VQSRRange(Double.parseDouble(parts[0]), Double.parseDouble(parts[1]), tpRate));
            }
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotReadInputFile(source, (Exception)e);
        }
        ((VQSRRange)points.get((int)0)).start = Double.POSITIVE_INFINITY;
        ((VQSRRange)points.get((int)(points.size() - 1))).stop = Double.NEGATIVE_INFINITY;
        return new VQSRCalibrationCurve(points);
    }

    protected VQSRCalibrationCurve(List<VQSRRange> points) {
        this.points = points;
    }

    public boolean certainFalsePositive(String VQSRQualKey, VariantContext vc) {
        return this.probTrueVariant(VQSRQualKey, vc) == -1.0;
    }

    public double probTrueVariant(double VQSRqual) {
        for (VQSRRange r : this.points) {
            if (!(VQSRqual <= r.getStart()) || !(VQSRqual > r.getStop())) continue;
            return r.getTruePositiveRate();
        }
        throw new ReviewedStingException("BUG: should not be able to reach this code");
    }

    public double probTrueVariant(String VQSRQualKey, VariantContext vc) {
        if (vc.isFiltered()) {
            return 0.0;
        }
        if (vc.hasAttribute(VQSRQualKey)) {
            double qual = vc.getAttributeAsDouble(VQSRQualKey);
            return this.probTrueVariant(qual);
        }
        throw new UserException.VariantContextMissingRequiredField(VQSRQualKey, vc);
    }

    public double[] includeErrorRateInLikelihoods(String VQSRQualKey, VariantContext vc, double[] log10Likelihoods) {
        double[] updated = new double[log10Likelihoods.length];
        double alpha = this.probTrueVariant(VQSRQualKey, vc);
        if (alpha == -1.0) {
            return null;
        }
        double noInfoPr = 0.3333333333333333;
        for (int i = 0; i < log10Likelihoods.length; ++i) {
            double p = Math.pow(10.0, log10Likelihoods[i]);
            double q = alpha * p + (1.0 - alpha) * noInfoPr;
            updated[i] = Math.log10(q);
        }
        return updated;
    }

    public void printInfo(Logger logger) {
        for (VQSRRange r : this.points) {
            logger.info(String.format("  start=%f stop=%f TPrate=%.6e", r.getStart(), r.getStop(), r.getTruePositiveRate()));
        }
    }

    private static class VQSRRange {
        double start;
        double stop;
        double truePositiveRate;

        public double getStart() {
            return this.start;
        }

        public double getStop() {
            return this.stop;
        }

        public double getTruePositiveRate() {
            return this.truePositiveRate;
        }

        private VQSRRange(double start, double stop, double truePositiveRate) {
            this.start = start;
            this.stop = stop;
            this.truePositiveRate = truePositiveRate;
        }
    }
}

