/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import java.util.ArrayList;
import java.util.HashMap;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.TableType;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

@Analysis(name="Variant Quality Score", description="Shows various stats of sets of variants binned by variant quality score")
public class VariantQualityScore
extends VariantEvaluator {
    @DataPoint(description="the Ti/Tv ratio broken out by variant quality")
    TiTvStats titvStats = null;
    @DataPoint(description="average variant quality for each allele count")
    AlleleCountStats alleleCountStats = null;

    public String getName() {
        return "VariantQualityScore";
    }

    @Override
    public int getComparisonOrder() {
        return 1;
    }

    @Override
    public boolean enabled() {
        return true;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String update1(VariantContext eval, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        String interesting = null;
        if (eval != null && eval.isSNP() && eval.isBiallelic() && eval.isPolymorphic()) {
            if (this.titvStats == null) {
                this.titvStats = new TiTvStats();
            }
            this.titvStats.incrValue(eval.getPhredScaledQual(), VariantContextUtils.isTransition(eval));
            if (this.alleleCountStats == null) {
                this.alleleCountStats = new AlleleCountStats();
            }
            int alternateAlleleCount = 0;
            for (Allele a : eval.getAlternateAlleles()) {
                alternateAlleleCount += eval.getChromosomeCount(a);
            }
            this.alleleCountStats.incrValue(eval.getPhredScaledQual(), alternateAlleleCount);
        }
        return interesting;
    }

    @Override
    public void finalizeEvaluation() {
        if (this.titvStats != null) {
            this.titvStats.organizeTiTvTables();
        }
        if (this.alleleCountStats != null) {
            this.alleleCountStats.organizeAlleleCountTables();
        }
    }

    class AlleleCountStats
    implements TableType {
        final HashMap<Integer, ArrayList<Double>> qualityListMap = new HashMap();
        final HashMap<Integer, Double> qualityMap = new HashMap();

        AlleleCountStats() {
        }

        @Override
        public Object[] getRowKeys() {
            int NUM_BINS = this.qualityListMap.keySet().size();
            Object[] rowKeys = new String[NUM_BINS];
            int iii = 0;
            for (Integer key : this.qualityListMap.keySet()) {
                rowKeys[iii] = "AC" + key;
                ++iii;
            }
            return rowKeys;
        }

        @Override
        public Object[] getColumnKeys() {
            return new String[]{"alleleCount", "avgQual"};
        }

        @Override
        public String getName() {
            return "AlleleCountStats";
        }

        @Override
        public String getCell(int x, int y) {
            int iii = 0;
            for (Integer key : this.qualityListMap.keySet()) {
                if (iii == x) {
                    if (y == 0) {
                        return String.valueOf(key);
                    }
                    return String.valueOf(this.qualityMap.get(key));
                }
                ++iii;
            }
            return null;
        }

        public String toString() {
            String returnString = "";
            returnString = returnString + "AlleleCountStats: ";
            return returnString;
        }

        public void incrValue(double qual, int alleleCount) {
            ArrayList<Double> list = this.qualityListMap.get(alleleCount);
            if (list == null) {
                list = new ArrayList();
            }
            list.add(qual);
            this.qualityListMap.put(alleleCount, list);
        }

        public void organizeAlleleCountTables() {
            for (Integer key : this.qualityListMap.keySet()) {
                ArrayList<Double> list = this.qualityListMap.get(key);
                double meanQual = 0.0;
                double numQuals = list.size();
                for (Double qual : list) {
                    meanQual += qual / numQuals;
                }
                this.qualityMap.put(key, meanQual);
            }
        }
    }

    static class TiTvStats
    implements TableType {
        static final int NUM_BINS = 20;
        final HashMap<Integer, Pair<Long, Long>> qualByIsTransition = new HashMap();
        final long[] transitionByQuality = new long[20];
        final long[] transversionByQuality = new long[20];
        final double[] titvByQuality = new double[20];

        TiTvStats() {
        }

        @Override
        public Object[] getRowKeys() {
            return new String[]{"sample"};
        }

        @Override
        public Object[] getColumnKeys() {
            Object[] columnKeys = new String[20];
            for (int iii = 0; iii < 20; ++iii) {
                columnKeys[iii] = "titvBin" + iii;
            }
            return columnKeys;
        }

        @Override
        public String getName() {
            return "TiTvStats";
        }

        @Override
        public String getCell(int x, int y) {
            return String.valueOf(this.titvByQuality[y]);
        }

        public String toString() {
            StringBuffer returnString = new StringBuffer();
            returnString.append("titvByQuality: ");
            for (int iii = 0; iii < 20; ++iii) {
                returnString.append(this.titvByQuality[iii]);
                returnString.append(" ");
            }
            return returnString.toString();
        }

        public void incrValue(double qual, boolean isTransition) {
            long numTransversion;
            Integer qualKey = Math.round((float)qual);
            long numTransition = isTransition ? 1L : 0L;
            long l = numTransversion = isTransition ? 0L : 1L;
            if (this.qualByIsTransition.containsKey(qualKey)) {
                Pair<Long, Long> transitionPair = this.qualByIsTransition.get(qualKey);
                transitionPair.set(transitionPair.getFirst() + numTransition, transitionPair.getSecond() + numTransversion);
                this.qualByIsTransition.put(qualKey, transitionPair);
            } else {
                this.qualByIsTransition.put(qualKey, new Pair<Long, Long>(numTransition, numTransversion));
            }
        }

        public void organizeTiTvTables() {
            for (int iii = 0; iii < 20; ++iii) {
                this.transitionByQuality[iii] = 0L;
                this.transversionByQuality[iii] = 0L;
                this.titvByQuality[iii] = 0.0;
            }
            int maxQual = 0;
            for (Integer qual : this.qualByIsTransition.keySet()) {
                if (qual <= maxQual) continue;
                maxQual = qual;
            }
            double binSize = (double)maxQual / 19.0;
            for (Integer qual : this.qualByIsTransition.keySet()) {
                int index = (int)Math.floor((double)qual.intValue() / binSize);
                if (index < 0) continue;
                Pair<Long, Long> transitionPair = this.qualByIsTransition.get(qual);
                int n = index;
                this.transitionByQuality[n] = this.transitionByQuality[n] + transitionPair.getFirst();
                int n2 = index;
                this.transversionByQuality[n2] = this.transversionByQuality[n2] + transitionPair.getSecond();
            }
            for (int iii = 0; iii < 20; ++iii) {
                this.titvByQuality[iii] = this.transitionByQuality[iii] + this.transversionByQuality[iii] > 800L ? (double)this.transitionByQuality[iii] / (double)this.transversionByQuality[iii] : 0.0;
            }
        }
    }
}

