/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import java.util.ArrayList;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.VariantEvalWalker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.TableType;
import org.broadinstitute.sting.utils.IndelUtils;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@Analysis(name="IndelStatistics", description="Shows various indel metrics and statistics")
public class IndelStatistics
extends VariantEvaluator {
    @DataPoint(description="Indel Statistics")
    IndelStats indelStats = null;
    IndelClasses indelClasses = null;
    int numSamples = 0;
    private static final int INDEL_SIZE_LIMIT = 100;
    private static final int IND_HET = 0;
    private static final int IND_INS = 1;
    private static final int IND_DEL = 2;
    private static final int IND_COMPLEX = 3;
    private static final int IND_HET_INS = 4;
    private static final int IND_HOM_INS = 5;
    private static final int IND_HET_DEL = 6;
    private static final int IND_HOM_DEL = 7;
    private static final int IND_HOM_REF = 8;
    private static final int IND_MIXED = 9;
    private static final int IND_LONG = 10;
    private static final int IND_AT_EXP = 11;
    private static final int IND_CG_EXP = 12;
    private static final int IND_FRAMESHIFT = 13;
    private static final int NUM_SCALAR_COLUMNS = 14;

    @Override
    public void initialize(VariantEvalWalker walker) {
        this.numSamples = walker.getNumSamples();
    }

    static int len2Index(int ind) {
        return ind + 100 + 14;
    }

    static int index2len(int ind) {
        return ind - 100 - 14;
    }

    public String getName() {
        return "IndelStatistics";
    }

    @Override
    public int getComparisonOrder() {
        return 1;
    }

    @Override
    public boolean enabled() {
        return true;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String update1(VariantContext eval, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (eval != null && eval.isPolymorphic()) {
            if (this.indelStats == null) {
                this.indelStats = new IndelStats(eval);
            }
            if (this.indelClasses == null) {
                this.indelClasses = new IndelClasses(eval);
            }
            if (eval.isIndel() || eval.isMixed()) {
                if (this.indelStats != null) {
                    this.indelStats.incrValue(eval, ref);
                }
                if (this.indelClasses != null) {
                    this.indelClasses.incrValue(eval, ref);
                }
            }
        }
        return null;
    }

    @Override
    public void finalizeEvaluation() {
        boolean k = false;
    }

    static class IndelClasses
    implements TableType {
        protected static final String[] columnNames = IndelUtils.getIndelClassificationNames();
        protected final int[] indelClassSummary = new int[columnNames.length];

        public IndelClasses(VariantContext vc) {
        }

        @Override
        public Object[] getRowKeys() {
            return new String[]{"all"};
        }

        @Override
        public Object getCell(int x, int y) {
            return String.format("%d", this.indelClassSummary[y]);
        }

        @Override
        public Object[] getColumnKeys() {
            return columnNames;
        }

        @Override
        public String getName() {
            return "IndelClasses";
        }

        public int getComparisonOrder() {
            return 1;
        }

        public String toString() {
            return this.getName();
        }

        private void incrementSampleStat(VariantContext vc, int index) {
            int n = index;
            this.indelClassSummary[n] = this.indelClassSummary[n] + 1;
        }

        public void incrValue(VariantContext vc, ReferenceContext ref) {
            ArrayList<Integer> indices = IndelUtils.findEventClassificationIndex(vc, ref);
            byte[] refBases = ref.getBases();
            for (int index : indices) {
                this.incrementSampleStat(vc, index);
            }
        }
    }

    static class IndelStats
    implements TableType {
        protected static final String[] COLUMN_KEYS = new String[215];
        protected final int[] indelSummary = new int[COLUMN_KEYS.length];

        public IndelStats(VariantContext vc) {
        }

        @Override
        public Object[] getRowKeys() {
            return new String[]{"all"};
        }

        @Override
        public Object getCell(int x, int y) {
            return String.format("%d", this.indelSummary[y]);
        }

        @Override
        public Object[] getColumnKeys() {
            return COLUMN_KEYS;
        }

        @Override
        public String getName() {
            return "IndelStats";
        }

        public int getComparisonOrder() {
            return 1;
        }

        public String toString() {
            return this.getName();
        }

        public void incrValue(VariantContext vc, ReferenceContext ref) {
            int eventLength = 0;
            boolean isInsertion = false;
            boolean isDeletion = false;
            if (vc.isSimpleInsertion()) {
                eventLength = vc.getAlternateAllele(0).length();
                this.indelSummary[1] = this.indelSummary[1] + 1;
                isInsertion = true;
            } else if (vc.isSimpleDeletion()) {
                this.indelSummary[2] = this.indelSummary[2] + 1;
                eventLength = -vc.getReference().length();
                isDeletion = true;
            } else if (vc.isComplexIndel()) {
                this.indelSummary[3] = this.indelSummary[3] + 1;
            } else if (vc.isMixed()) {
                this.indelSummary[9] = this.indelSummary[9] + 1;
            }
            if (IndelUtils.isATExpansion(vc, ref)) {
                this.indelSummary[11] = this.indelSummary[11] + 1;
            }
            if (IndelUtils.isCGExpansion(vc, ref)) {
                this.indelSummary[12] = this.indelSummary[12] + 1;
            }
            if (vc.isSimpleDeletion() || vc.isSimpleInsertion()) {
                if (Math.abs(eventLength) < 100) {
                    int n = IndelStatistics.len2Index(eventLength);
                    this.indelSummary[n] = this.indelSummary[n] + 1;
                    if (eventLength % 3 != 0) {
                        this.indelSummary[13] = this.indelSummary[13] + 1;
                    }
                } else {
                    this.indelSummary[10] = this.indelSummary[10] + 1;
                }
            }
        }

        static {
            IndelStats.COLUMN_KEYS[0] = "heterozygosity";
            IndelStats.COLUMN_KEYS[1] = "insertions";
            IndelStats.COLUMN_KEYS[2] = "deletions";
            IndelStats.COLUMN_KEYS[3] = "complex";
            IndelStats.COLUMN_KEYS[4] = "het_insertions";
            IndelStats.COLUMN_KEYS[5] = "homozygous_insertions";
            IndelStats.COLUMN_KEYS[6] = "het_deletions";
            IndelStats.COLUMN_KEYS[7] = "homozygous_deletions";
            IndelStats.COLUMN_KEYS[8] = "homozygous_reference_sites";
            IndelStats.COLUMN_KEYS[9] = "complex_events";
            IndelStats.COLUMN_KEYS[10] = "long_indels";
            IndelStats.COLUMN_KEYS[11] = "AT_expansions";
            IndelStats.COLUMN_KEYS[12] = "CG_expansions";
            IndelStats.COLUMN_KEYS[13] = "frameshift_indels";
            for (int k = 14; k < 215; ++k) {
                IndelStats.COLUMN_KEYS[k] = "indel_size_len" + Integer.valueOf(IndelStatistics.index2len(k));
            }
        }
    }
}

