/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.StandardEval;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@Analysis(description="The overlap between eval and comp sites")
public class CompOverlap
extends VariantEvaluator
implements StandardEval {
    @DataPoint(description="number of eval SNP sites")
    long nEvalVariants = 0L;
    @DataPoint(description="number of eval sites outside of comp sites")
    long novelSites = 0L;
    @DataPoint(description="number of eval sites at comp sites")
    long nVariantsAtComp = 0L;
    @DataPoint(description="percentage of eval sites at comp sites")
    double compRate = 0.0;
    @DataPoint(description="number of concordant sites")
    long nConcordant = 0L;
    @DataPoint(description="the concordance rate")
    double concordantRate = 0.0;

    @Override
    public int getComparisonOrder() {
        return 2;
    }

    public long nNovelSites() {
        return this.nEvalVariants - this.nVariantsAtComp;
    }

    public double compRate() {
        return this.rate(this.nVariantsAtComp, this.nEvalVariants);
    }

    public double concordanceRate() {
        return this.rate(this.nConcordant, this.nVariantsAtComp);
    }

    @Override
    public void finalizeEvaluation() {
        this.compRate = 100.0 * this.compRate();
        this.concordantRate = 100.0 * this.concordanceRate();
        this.novelSites = this.nNovelSites();
    }

    @Override
    public boolean enabled() {
        return true;
    }

    public boolean discordantP(VariantContext eval, VariantContext comp) {
        for (Allele a : eval.getAlleles()) {
            if (comp.hasAllele(a, true)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String update2(VariantContext eval, VariantContext comp, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        boolean compIsGood;
        boolean evalIsGood = eval != null && eval.isPolymorphic();
        boolean bl = compIsGood = comp != null && comp.isNotFiltered();
        if (evalIsGood) {
            ++this.nEvalVariants;
        }
        if (compIsGood && evalIsGood) {
            ++this.nVariantsAtComp;
            if (!this.discordantP(eval, comp)) {
                ++this.nConcordant;
            }
        }
        return null;
    }
}

