/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.SampleSummaryStats;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

class ACSummaryStats
extends SampleSummaryStats {
    private String[] rowKeys;

    public ACSummaryStats(VariantContext evalvc, VariantContext compvc) {
        int i;
        this.concordanceSummary.put("allSamples", new double[COLUMN_KEYS.length]);
        this.rowKeys = new String[3 + 2 * evalvc.getGenotypes().size() + 2 * compvc.getGenotypes().size()];
        this.rowKeys[0] = "allSamples";
        for (i = 0; i <= 2 * evalvc.getGenotypes().size(); ++i) {
            this.concordanceSummary.put(String.format("evalAC%d", i), new double[COLUMN_KEYS.length]);
            this.rowKeys[i + 1] = String.format("evalAC%d", i);
        }
        for (i = 0; i <= 2 * compvc.getGenotypes().size(); ++i) {
            this.concordanceSummary.put(String.format("compAC%d", i), new double[COLUMN_KEYS.length]);
            this.rowKeys[2 + 2 * evalvc.getGenotypes().size() + i] = String.format("compAC%d", i);
        }
    }

    @Override
    public String getName() {
        return "Allele Count Summary Statistics";
    }

    @Override
    public Object[] getRowKeys() {
        if (this.rowKeys == null) {
            throw new StingException("rowKeys is null!!");
        }
        return this.rowKeys;
    }
}

