/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.gatk.walkers.phasing.DistanceMergeRule;
import org.broadinstitute.sting.gatk.walkers.phasing.MergeBasedOnRefSeqAnnotation;
import org.broadinstitute.sting.gatk.walkers.phasing.RefSeqDataParser;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

class SameGenePlusWithinDistanceMergeRule
extends DistanceMergeRule {
    private MergeBasedOnRefSeqAnnotation mergeBasedOnRefSeqAnnotation;

    public SameGenePlusWithinDistanceMergeRule(int maxGenomicDistanceForMNP, GenomeLocParser genomeLocParser, String mergeBasedOnRefSeqAnnotation) {
        super(maxGenomicDistanceForMNP, genomeLocParser);
        if (mergeBasedOnRefSeqAnnotation.equals("UNION")) {
            this.mergeBasedOnRefSeqAnnotation = MergeBasedOnRefSeqAnnotation.UNION_WITH_DIST;
        } else if (mergeBasedOnRefSeqAnnotation.equals("INTERSECT")) {
            this.mergeBasedOnRefSeqAnnotation = MergeBasedOnRefSeqAnnotation.INTERSECT_WITH_DIST;
        } else {
            throw new UserException("Must provide IGNORE, UNION, or INTERSECT as argument to mergeBasedOnRefSeqAnnotation!");
        }
    }

    @Override
    public boolean shouldAttemptToMerge(VariantContext vc1, VariantContext vc2) {
        boolean withinDistance = super.shouldAttemptToMerge(vc1, vc2);
        if (this.mergeBasedOnRefSeqAnnotation == MergeBasedOnRefSeqAnnotation.UNION_WITH_DIST) {
            return withinDistance || this.sameGene(vc1, vc2);
        }
        return withinDistance && this.sameGene(vc1, vc2);
    }

    private boolean sameGene(VariantContext vc1, VariantContext vc2) {
        Set<String> names_vc1 = RefSeqDataParser.getRefSeqNames(vc1);
        Set<String> names_vc2 = RefSeqDataParser.getRefSeqNames(vc2);
        names_vc1.retainAll(names_vc2);
        if (!names_vc1.isEmpty()) {
            return true;
        }
        Set<String> names2_vc1 = RefSeqDataParser.getRefSeqNames(vc1, true);
        Set<String> names2_vc2 = RefSeqDataParser.getRefSeqNames(vc2, true);
        names2_vc1.retainAll(names2_vc2);
        return !names2_vc1.isEmpty();
    }

    @Override
    public String toString() {
        return super.toString() + " " + (this.mergeBasedOnRefSeqAnnotation == MergeBasedOnRefSeqAnnotation.UNION_WITH_DIST ? "OR" : "AND") + " on the same gene";
    }

    @Override
    public Map<String, Object> addToMergedAttributes(VariantContext vc1, VariantContext vc2) {
        Map<String, Object> addedAttribs = super.addToMergedAttributes(vc1, vc2);
        addedAttribs.putAll(RefSeqDataParser.getMergedRefSeqNameAttributes(vc1, vc2));
        return addedAttribs;
    }
}

