/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import org.broadinstitute.sting.gatk.walkers.phasing.PhasingGraphEdge;
import org.broadinstitute.sting.utils.DisjointSet;

public class PhasingGraph
implements Iterable<PhasingGraphEdge> {
    private Neighbors[] adj;

    public PhasingGraph(int numVertices) {
        this.adj = new Neighbors[numVertices];
        for (int i = 0; i < numVertices; ++i) {
            this.adj[i] = new Neighbors();
        }
    }

    public void addEdge(PhasingGraphEdge e) {
        if (e.v1 == e.v2) {
            return;
        }
        this.adj[e.v1].addNeighbor(e);
        this.adj[e.v2].addNeighbor(e);
    }

    public void addEdges(Collection<PhasingGraphEdge> edges) {
        for (PhasingGraphEdge e : edges) {
            this.addEdge(e);
        }
    }

    public void removeEdge(PhasingGraphEdge e) {
        this.adj[e.v1].removeNeighbor(e);
        this.adj[e.v2].removeNeighbor(e);
    }

    public Collection<PhasingGraphEdge> removeAllIncidentEdges(int vertexIndex) {
        TreeSet<PhasingGraphEdge> incidentEdges = new TreeSet<PhasingGraphEdge>(this.adj[vertexIndex].neighbors);
        for (PhasingGraphEdge neighbEdge : incidentEdges) {
            if (vertexIndex != neighbEdge.v1) {
                this.adj[neighbEdge.v1].removeNeighbor(neighbEdge);
                continue;
            }
            if (vertexIndex == neighbEdge.v2) continue;
            this.adj[neighbEdge.v2].removeNeighbor(neighbEdge);
        }
        this.adj[vertexIndex].clearAllNeighbors();
        return incidentEdges;
    }

    public DisjointSet getConnectedComponents() {
        DisjointSet cc = new DisjointSet(this.adj.length);
        for (PhasingGraphEdge e : this) {
            cc.setUnion(e.v1, e.v2);
        }
        return cc;
    }

    @Override
    public Iterator<PhasingGraphEdge> iterator() {
        return new AllEdgesIterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.adj.length; ++i) {
            sb.append(i + ":");
            for (PhasingGraphEdge e : this.adj[i]) {
                sb.append(" " + (e.v1 == i ? e.v2 : e.v1));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private class Neighbors
    implements Iterable<PhasingGraphEdge> {
        private Set<PhasingGraphEdge> neighbors = new TreeSet<PhasingGraphEdge>();

        public void addNeighbor(PhasingGraphEdge e) {
            this.neighbors.add(e);
        }

        public void removeNeighbor(PhasingGraphEdge e) {
            this.neighbors.remove(e);
        }

        @Override
        public Iterator<PhasingGraphEdge> iterator() {
            return this.neighbors.iterator();
        }

        public void clearAllNeighbors() {
            this.neighbors.clear();
        }
    }

    private class AllEdgesIterator
    implements Iterator<PhasingGraphEdge> {
        private int curInd = 0;
        private Iterator<PhasingGraphEdge> innerIt = null;
        private PhasingGraphEdge nextEdge = null;

        @Override
        public boolean hasNext() {
            if (this.nextEdge != null) {
                return true;
            }
            while (this.curInd < PhasingGraph.this.adj.length) {
                if (this.innerIt == null) {
                    this.innerIt = PhasingGraph.this.adj[this.curInd].iterator();
                }
                while (this.innerIt.hasNext()) {
                    PhasingGraphEdge e = this.innerIt.next();
                    if (e.v1 != this.curInd) continue;
                    this.nextEdge = e;
                    return true;
                }
                this.innerIt = null;
                ++this.curInd;
            }
            return false;
        }

        @Override
        public PhasingGraphEdge next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            PhasingGraphEdge tmpEdge = this.nextEdge;
            this.nextEdge = null;
            return tmpEdge;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

