/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.Allows;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.phasing.DistanceMergeRule;
import org.broadinstitute.sting.gatk.walkers.phasing.ExistsDoubleAltAlleleMergeRule;
import org.broadinstitute.sting.gatk.walkers.phasing.MergeSegregatingAlternateAllelesVCFWriter;
import org.broadinstitute.sting.gatk.walkers.phasing.PrefixPolymorphismMergeAllelesRule;
import org.broadinstitute.sting.gatk.walkers.phasing.SameGenePlusWithinDistanceMergeRule;
import org.broadinstitute.sting.gatk.walkers.phasing.WriteVCF;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

@Allows(value={DataSource.REFERENCE})
@Requires(value={DataSource.REFERENCE})
@By(value=DataSource.REFERENCE_ORDERED_DATA)
public class MergeSegregatingAlternateAllelesWalker
extends RodWalker<Integer, Integer> {
    @Output(doc="File to which variants should be written", required=true)
    protected VCFWriter writer = null;
    private MergeSegregatingAlternateAllelesVCFWriter vcMergerWriter = null;
    @Argument(fullName="maxGenomicDistance", shortName="maxDist", doc="The maximum reference-genome distance between consecutive heterozygous sites to permit merging phased VCF records; [default:1]", required=false)
    protected int maxGenomicDistance = 1;
    @Argument(fullName="useSingleSample", shortName="useSample", doc="Only output genotypes for the single sample given; [default:use all samples]", required=false)
    protected String useSingleSample = null;
    @Hidden
    @Argument(fullName="emitOnlyMergedRecords", shortName="emitOnlyMerged", doc="Only output records that resulted from merging [For DEBUGGING purposes only - DO NOT USE, since it disregards the semantics of '|' as 'phased relative to previous non-filtered VC']; [default:false]", required=false)
    protected boolean emitOnlyMergedRecords = false;
    @Argument(fullName="disablePrintAltAlleleStats", shortName="noAlleleStats", doc="Should the print-out of alternate allele statistics be disabled?; [default:false]", required=false)
    protected boolean disablePrintAlternateAlleleStatistics = false;
    public static final String IGNORE_REFSEQ = "IGNORE";
    public static final String UNION_REFSEQ = "UNION";
    public static final String INTERSECT_REFSEQ = "INTERSECT";
    @Argument(fullName="mergeBasedOnRefSeqAnnotation", shortName="mergeBasedOnRefSeqAnnotation", doc="'Should merging be performed if two sites lie on the same RefSeq sequence in the INFO field {IGNORE, UNION, INTERSECT}; [default:IGNORE]", required=false)
    protected String mergeBasedOnRefSeqAnnotation = "IGNORE";
    @Argument(fullName="dontRequireSomeSampleHasDoubleAltAllele", shortName="dontRequireSomeSampleHasDoubleAltAllele", doc="Should the requirement, that SUCCESSIVE records to be merged have at least one sample with a double alternate allele, be relaxed?; [default:false]", required=false)
    protected boolean dontRequireSomeSampleHasDoubleAltAllele = false;
    @Input(fullName="variant", shortName="V", doc="Select variants from this VCF file", required=true)
    public RodBinding<VariantContext> variants;

    @Override
    public void initialize() {
        this.initializeVcfWriter();
    }

    private void initializeVcfWriter() {
        GenomeLocParser genomeLocParser = this.getToolkit().getGenomeLocParser();
        DistanceMergeRule vcMergeRule = this.mergeBasedOnRefSeqAnnotation.equals(IGNORE_REFSEQ) ? new DistanceMergeRule(this.maxGenomicDistance, genomeLocParser) : new SameGenePlusWithinDistanceMergeRule(this.maxGenomicDistance, genomeLocParser, this.mergeBasedOnRefSeqAnnotation);
        VariantContextUtils.AlleleMergeRule alleleMergeRule = this.dontRequireSomeSampleHasDoubleAltAllele ? new PrefixPolymorphismMergeAllelesRule() : new ExistsDoubleAltAlleleMergeRule();
        this.vcMergerWriter = new MergeSegregatingAlternateAllelesVCFWriter(this.writer, genomeLocParser, this.getToolkit().getArguments().referenceFile, vcMergeRule, alleleMergeRule, this.useSingleSample, this.emitOnlyMergedRecords, logger, false, !this.disablePrintAlternateAlleleStatistics);
        this.writer = null;
        HashSet<VCFHeaderLine> hInfo = new HashSet<VCFHeaderLine>();
        hInfo.addAll(VCFUtils.getHeaderFields(this.getToolkit()));
        hInfo.add(new VCFHeaderLine("reference", this.getToolkit().getArguments().referenceFile.getName()));
        Map<String, VCFHeader> rodNameToHeader = VCFUtils.getVCFHeadersFromRods(this.getToolkit(), Arrays.asList(this.variants.getName()));
        this.vcMergerWriter.writeHeader(new VCFHeader(hInfo, new TreeSet<String>(rodNameToHeader.get(this.variants.getName()).getGenotypeSamples())));
    }

    @Override
    public boolean generateExtendedEvents() {
        return false;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return null;
        }
        for (VariantContext vc : tracker.getValues(this.variants, context.getLocation())) {
            this.writeVCF(vc);
        }
        return 0;
    }

    private void writeVCF(VariantContext vc) {
        WriteVCF.writeVCF(vc, this.vcMergerWriter, logger);
    }

    @Override
    public Integer reduce(Integer result, Integer total) {
        if (result == null) {
            return total;
        }
        return total + result;
    }

    @Override
    public void onTraversalDone(Integer result) {
        this.vcMergerWriter.close();
        if (this.useSingleSample != null) {
            System.out.println("Only considered single sample: " + this.useSingleSample);
        }
        System.out.println("Number of successive pairs of records: " + this.vcMergerWriter.getNumRecordsAttemptToMerge());
        System.out.println("Number of potentially merged records (" + this.vcMergerWriter.getVcMergeRule() + "): " + this.vcMergerWriter.getNumRecordsSatisfyingMergeRule());
        System.out.println("Number of records merged (" + this.vcMergerWriter.getAlleleMergeRule() + "): " + this.vcMergerWriter.getNumMergedRecords());
        System.out.println(this.vcMergerWriter.getAltAlleleStats());
    }
}

