/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.sf.picard.reference.ReferenceSequenceFile;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.walkers.phasing.DistanceMergeRule;
import org.broadinstitute.sting.gatk.walkers.phasing.SegregatingMNPmergeAllelesRule;
import org.broadinstitute.sting.gatk.walkers.phasing.VariantContextMergeRule;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.fasta.CachingIndexedFastaSequenceFile;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class MergeSegregatingAlternateAllelesVCFWriter
implements VCFWriter {
    private VCFWriter innerWriter;
    private GenomeLocParser genomeLocParser;
    private ReferenceSequenceFile referenceFileForMNPmerging;
    private VariantContextMergeRule vcMergeRule;
    private VariantContextUtils.AlleleMergeRule alleleMergeRule;
    private String useSingleSample = null;
    private boolean emitOnlyMergedRecords;
    private VCFRecord vcfrWaitingToMerge;
    private List<VCFRecord> filteredVcfrList;
    private int numRecordsAttemptToMerge;
    private int numRecordsSatisfyingMergeRule;
    private int numMergedRecords;
    private AltAlleleStatsForSamples altAlleleStats = null;
    private Logger logger;
    private boolean takeOwnershipOfInner;

    public MergeSegregatingAlternateAllelesVCFWriter(VCFWriter innerWriter, GenomeLocParser genomeLocParser, File referenceFile, VariantContextMergeRule vcMergeRule, VariantContextUtils.AlleleMergeRule alleleMergeRule, String singleSample, boolean emitOnlyMergedRecords, Logger logger, boolean takeOwnershipOfInner, boolean trackAltAlleleStats) {
        this.innerWriter = innerWriter;
        this.genomeLocParser = genomeLocParser;
        try {
            this.referenceFileForMNPmerging = new CachingIndexedFastaSequenceFile(referenceFile);
        }
        catch (FileNotFoundException ex) {
            throw new UserException.CouldNotReadInputFile(referenceFile, (Exception)ex);
        }
        this.vcMergeRule = vcMergeRule;
        this.alleleMergeRule = alleleMergeRule;
        this.useSingleSample = singleSample;
        this.emitOnlyMergedRecords = emitOnlyMergedRecords;
        this.vcfrWaitingToMerge = null;
        this.filteredVcfrList = new LinkedList<VCFRecord>();
        this.numRecordsSatisfyingMergeRule = 0;
        this.numMergedRecords = 0;
        if (trackAltAlleleStats) {
            this.altAlleleStats = new AltAlleleStatsForSamples();
        }
        this.logger = logger;
        this.takeOwnershipOfInner = takeOwnershipOfInner;
    }

    public MergeSegregatingAlternateAllelesVCFWriter(VCFWriter innerWriter, GenomeLocParser genomeLocParser, File referenceFile, int maxGenomicDistanceForMNP, Logger logger, boolean takeOwnershipOfInner) {
        this(innerWriter, genomeLocParser, referenceFile, new DistanceMergeRule(maxGenomicDistanceForMNP, genomeLocParser), new SegregatingMNPmergeAllelesRule(), null, false, logger, takeOwnershipOfInner, true);
    }

    @Override
    public void writeHeader(VCFHeader header) {
        if (this.useSingleSample != null) {
            TreeSet<String> singSampSet = new TreeSet<String>();
            singSampSet.add(this.useSingleSample);
            header = new VCFHeader(header.getMetaData(), singSampSet);
        }
        this.innerWriter.writeHeader(header);
    }

    @Override
    public void close() {
        this.stopWaitingToMerge();
        if (this.takeOwnershipOfInner) {
            this.innerWriter.close();
        }
    }

    @Override
    public void add(VariantContext vc) {
        if (this.useSingleSample != null) {
            Genotype sampGt = vc.getGenotype(this.useSingleSample);
            if (sampGt != null) {
                vc = vc.subContextFromGenotypes(sampGt);
            } else {
                return;
            }
        }
        this.logger.debug("Next VC input = " + VariantContextUtils.getLocation(this.genomeLocParser, vc));
        boolean curVcIsNotFiltered = vc.isNotFiltered();
        if (this.vcfrWaitingToMerge == null) {
            this.logger.debug("NOT Waiting to merge...");
            if (!this.filteredVcfrList.isEmpty()) {
                throw new ReviewedStingException("filteredVcfrList should be empty if not waiting to merge a vc!");
            }
            if (curVcIsNotFiltered) {
                this.logger.debug("Waiting for new variant " + VariantContextUtils.getLocation(this.genomeLocParser, vc));
                this.vcfrWaitingToMerge = new VCFRecord(vc, false);
            } else if (!this.emitOnlyMergedRecords) {
                this.logger.debug("DIRECTLY output " + VariantContextUtils.getLocation(this.genomeLocParser, vc));
                this.innerWriter.add(vc);
            }
        } else {
            this.logger.debug("Waiting to merge " + VariantContextUtils.getLocation(this.genomeLocParser, this.vcfrWaitingToMerge.vc));
            if (!curVcIsNotFiltered) {
                if (!this.emitOnlyMergedRecords) {
                    this.logger.debug("Caching unprocessed output " + VariantContextUtils.getLocation(this.genomeLocParser, vc));
                    this.filteredVcfrList.add(new VCFRecord(vc, false));
                }
            } else {
                ++this.numRecordsAttemptToMerge;
                boolean shouldAttemptToMerge = this.vcMergeRule.shouldAttemptToMerge(this.vcfrWaitingToMerge.vc, vc);
                this.logger.debug("shouldAttemptToMerge? = " + shouldAttemptToMerge);
                if (this.altAlleleStats != null) {
                    this.altAlleleStats.updateSampleStats(this.vcfrWaitingToMerge.vc, vc, shouldAttemptToMerge);
                }
                boolean mergedRecords = false;
                if (shouldAttemptToMerge) {
                    ++this.numRecordsSatisfyingMergeRule;
                    VariantContext mergedVc = VariantContextUtils.mergeIntoMNP(this.genomeLocParser, this.vcfrWaitingToMerge.vc, vc, this.referenceFileForMNPmerging, this.alleleMergeRule);
                    if (mergedVc != null) {
                        mergedRecords = true;
                        Map<String, Object> addedAttribs = this.vcMergeRule.addToMergedAttributes(this.vcfrWaitingToMerge.vc, vc);
                        addedAttribs.putAll(mergedVc.getAttributes());
                        mergedVc = VariantContext.modifyAttributes(mergedVc, addedAttribs);
                        this.vcfrWaitingToMerge = new VCFRecord(mergedVc, true);
                        ++this.numMergedRecords;
                    }
                }
                if (!mergedRecords) {
                    this.stopWaitingToMerge();
                    this.vcfrWaitingToMerge = new VCFRecord(vc, false);
                }
                this.logger.debug("Merged? = " + mergedRecords);
            }
        }
    }

    private void stopWaitingToMerge() {
        if (this.vcfrWaitingToMerge == null) {
            if (!this.filteredVcfrList.isEmpty()) {
                throw new ReviewedStingException("filteredVcfrList should be empty if not waiting to merge a vc!");
            }
            return;
        }
        if (!this.emitOnlyMergedRecords || this.vcfrWaitingToMerge.resultedFromMerge) {
            this.innerWriter.add(this.vcfrWaitingToMerge.vc);
        }
        this.vcfrWaitingToMerge = null;
        for (VCFRecord vcfr : this.filteredVcfrList) {
            this.innerWriter.add(vcfr.vc);
        }
        this.filteredVcfrList.clear();
    }

    public int getNumRecordsAttemptToMerge() {
        return this.numRecordsAttemptToMerge;
    }

    public int getNumRecordsSatisfyingMergeRule() {
        return this.numRecordsSatisfyingMergeRule;
    }

    public int getNumMergedRecords() {
        return this.numMergedRecords;
    }

    public VariantContextMergeRule getVcMergeRule() {
        return this.vcMergeRule;
    }

    public VariantContextUtils.AlleleMergeRule getAlleleMergeRule() {
        return this.alleleMergeRule;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public String getAltAlleleStats() {
        if (this.altAlleleStats == null) {
            return "";
        }
        return "\n" + this.altAlleleStats.toString();
    }

    private class AltAlleleStatsForSamples {
        private Map<String, AltAlleleStats> sampleStats = new HashMap<String, AltAlleleStats>();

        public void updateSampleStats(VariantContext vc1, VariantContext vc2, boolean shouldAttemptToMerge) {
            if (vc1.isFiltered() || vc2.isFiltered()) {
                return;
            }
            TreeSet<String> allSamples = new TreeSet<String>(vc1.getSampleNames());
            allSamples.addAll(vc2.getSampleNames());
            for (String samp : allSamples) {
                AltAlleleStats aas = this.sampleStats.get(samp);
                if (aas == null) {
                    aas = new AltAlleleStats();
                    this.sampleStats.put(samp, aas);
                }
                Genotype gt1 = vc1.getGenotype(samp);
                Genotype gt2 = vc2.getGenotype(samp);
                if (gt1 == null || gt2 == null) {
                    ++aas.oneSampleMissing;
                    continue;
                }
                if (gt1.isNoCall() || gt1.isFiltered() || gt2.isNoCall() || gt2.isFiltered()) {
                    ++aas.atLeastOneSampleNotCalledOrFiltered;
                    continue;
                }
                ++aas.numSuccessiveGenotypes;
                if (!shouldAttemptToMerge) continue;
                ++aas.numSuccessiveGenotypesAttemptedToBeMerged;
                if (!VariantContextUtils.alleleSegregationIsKnown(gt1, gt2)) {
                    ++aas.segregationUnknown;
                    MergeSegregatingAlternateAllelesVCFWriter.this.logger.debug("Unknown segregation of alleles [not phased] for " + samp + " at " + VariantContextUtils.getLocation(MergeSegregatingAlternateAllelesVCFWriter.this.genomeLocParser, vc1) + ", " + VariantContextUtils.getLocation(MergeSegregatingAlternateAllelesVCFWriter.this.genomeLocParser, vc2));
                    continue;
                }
                if (gt1.isHomRef() || gt2.isHomRef()) {
                    MergeSegregatingAlternateAllelesVCFWriter.this.logger.debug("gt1.isHomRef() || gt2.isHomRef() for " + samp + " at " + VariantContextUtils.getLocation(MergeSegregatingAlternateAllelesVCFWriter.this.genomeLocParser, vc1) + ", " + VariantContextUtils.getLocation(MergeSegregatingAlternateAllelesVCFWriter.this.genomeLocParser, vc2));
                    ++aas.eitherNotVariant;
                    continue;
                }
                ++aas.bothInPairHaveVariant;
                List<Allele> site1Alleles = gt1.getAlleles();
                List<Allele> site2Alleles = gt2.getAlleles();
                Iterator<Allele> all2It = site2Alleles.iterator();
                for (Allele all1 : site1Alleles) {
                    Allele all2 = all2It.next();
                    if (all1.isReference()) {
                        if (all2.isReference()) {
                            ++aas.ref_ref_pair;
                            continue;
                        }
                        ++aas.ref_alt_pair;
                        continue;
                    }
                    if (all2.isReference()) {
                        ++aas.alt_ref_pair;
                        continue;
                    }
                    ++aas.alt_alt_pair;
                }
                if (!this.containsRefAllele(site1Alleles) || !this.containsRefAllele(site2Alleles)) continue;
                MergeSegregatingAlternateAllelesVCFWriter.this.logger.debug("HET-HET for " + samp + " at " + VariantContextUtils.getLocation(MergeSegregatingAlternateAllelesVCFWriter.this.genomeLocParser, vc1) + ", " + VariantContextUtils.getLocation(MergeSegregatingAlternateAllelesVCFWriter.this.genomeLocParser, vc2));
                if (!(!MergeSegregatingAlternateAllelesVCFWriter.this.logger.isDebugEnabled() || gt1.isHet() && gt2.isHet())) {
                    throw new ReviewedStingException("Since !gt1.isHomRef() && !gt2.isHomRef(), yet both have ref alleles, they BOTH must be hets!");
                }
                boolean hasMNP = false;
                all2It = site2Alleles.iterator();
                for (Allele all1 : site1Alleles) {
                    Allele all2 = all2It.next();
                    if (!all1.isNonReference() || !all2.isNonReference()) continue;
                    hasMNP = true;
                    break;
                }
                if (hasMNP) {
                    ++aas.MNPsites;
                    continue;
                }
                ++aas.CHetSites;
            }
        }

        private boolean containsRefAllele(List<Allele> siteAlleles) {
            for (Allele all : siteAlleles) {
                if (!all.isReference()) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("-------------------------------------------------------------------------\n");
            sb.append("Per-sample alternate allele statistics [" + MergeSegregatingAlternateAllelesVCFWriter.this.vcMergeRule + "]\n");
            sb.append("-------------------------------------------------------------------------");
            for (Map.Entry<String, AltAlleleStats> sampAltAllStatsEntry : this.sampleStats.entrySet()) {
                String samp = sampAltAllStatsEntry.getKey();
                AltAlleleStats stats = sampAltAllStatsEntry.getValue();
                sb.append("\n* Sample:\t" + samp + "\n" + stats);
            }
            return sb.toString();
        }
    }

    private class AltAlleleStats {
        public int numSuccessiveGenotypes = 0;
        public int numSuccessiveGenotypesAttemptedToBeMerged = 0;
        public int oneSampleMissing = 0;
        public int atLeastOneSampleNotCalledOrFiltered = 0;
        public int segregationUnknown = 0;
        public int eitherNotVariant = 0;
        public int bothInPairHaveVariant = 0;
        public int ref_ref_pair = 0;
        public int ref_alt_pair = 0;
        public int alt_ref_pair = 0;
        public int alt_alt_pair = 0;
        public int MNPsites = 0;
        public int CHetSites = 0;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Sample missing:\t" + this.oneSampleMissing + "\n");
            sb.append("Not called or filtered:\t" + this.atLeastOneSampleNotCalledOrFiltered + "\n");
            sb.append("* Number of successive pairs of genotypes:\t" + this.numSuccessiveGenotypes + "\n");
            sb.append("Number of successive pairs of genotypes with " + MergeSegregatingAlternateAllelesVCFWriter.this.vcMergeRule + ":\t" + this.numSuccessiveGenotypesAttemptedToBeMerged + "\n");
            sb.append("Unknown segregation, " + MergeSegregatingAlternateAllelesVCFWriter.this.vcMergeRule + ":\t" + this.segregationUnknown + "\n");
            sb.append("Not variant at least one of pair, segregation known, " + MergeSegregatingAlternateAllelesVCFWriter.this.vcMergeRule + ":\t" + this.eitherNotVariant + "\n");
            sb.append("* Variant at both, segregation known, " + MergeSegregatingAlternateAllelesVCFWriter.this.vcMergeRule + ":\t" + this.percentageString(this.bothInPairHaveVariant, this.numSuccessiveGenotypes) + "\n");
            sb.append("[Total haplotypes at pairs:\t" + (this.ref_ref_pair + this.ref_alt_pair + this.alt_ref_pair + this.alt_alt_pair) + "\n");
            sb.append("REF-REF:\t" + this.ref_ref_pair + "\n");
            sb.append("REF-ALT:\t" + this.ref_alt_pair + "\n");
            sb.append("ALT-REF:\t" + this.alt_ref_pair + "\n");
            sb.append("ALT-ALT:\t" + this.alt_alt_pair + "]\n");
            int hetAfterHetSites = this.MNPsites + this.CHetSites;
            sb.append("* Het-Het sites (with REF allele present at each):\t" + this.percentageString(hetAfterHetSites, this.bothInPairHaveVariant) + "\n");
            sb.append("* MNPs:\t" + this.percentageString(this.MNPsites, hetAfterHetSites) + "\n");
            sb.append("Compound Hets:\t" + this.CHetSites + "\n");
            return sb.toString();
        }

        private String percentageString(int count, int baseCount) {
            int NUM_DECIMAL_PLACES = 1;
            String percent = new Formatter().format("%." + NUM_DECIMAL_PLACES + "f", MathUtils.percentage(count, baseCount)).toString();
            return count + " (" + percent + "%)";
        }
    }

    private static class VCFRecord {
        public VariantContext vc;
        public boolean resultedFromMerge;

        public VCFRecord(VariantContext vc, boolean resultedFromMerge) {
            this.vc = vc;
            this.resultedFromMerge = resultedFromMerge;
        }
    }
}

