/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class MergeAndMatchHaplotypes
extends RodWalker<Integer, Integer> {
    @Output
    protected VCFWriter vcfWriter = null;
    @Input(fullName="pbt", shortName="pbt", doc="Input VCF truth file", required=true)
    public RodBinding<VariantContext> pbtTrack;
    @Input(fullName="rbp", shortName="rbp", doc="Input VCF truth file", required=true)
    public RodBinding<VariantContext> rbpTrack;
    private Map<String, Genotype> pbtCache = new HashMap<String, Genotype>();
    private Map<String, Genotype> rbpCache = new HashMap<String, Genotype>();
    private final String SOURCE_NAME = "MergeReadBackedAndTransmissionPhasedVariants";

    @Override
    public void initialize() {
        ArrayList<String> rodNames = new ArrayList<String>();
        rodNames.add(this.pbtTrack.getName());
        Map<String, VCFHeader> vcfRods = VCFUtils.getVCFHeadersFromRods(this.getToolkit(), rodNames);
        Set<String> vcfSamples = SampleUtils.getSampleList(vcfRods, VariantContextUtils.GenotypeMergeType.REQUIRE_UNIQUE);
        HashSet<VCFHeaderLine> headerLines = new HashSet<VCFHeaderLine>();
        headerLines.addAll(VCFUtils.getHeaderFields(this.getToolkit()));
        this.vcfWriter.writeHeader(new VCFHeader(headerLines, vcfSamples));
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker != null) {
            VariantContext rbp;
            List<VariantContext> pbts = tracker.getValues(this.pbtTrack, ref.getLocus());
            List<VariantContext> rbps = tracker.getValues(this.rbpTrack, ref.getLocus());
            VariantContext pbt = pbts.iterator().hasNext() ? (VariantContext)pbts.iterator().next() : null;
            VariantContext variantContext = rbp = rbps.iterator().hasNext() ? (VariantContext)rbps.iterator().next() : null;
            if (pbt != null && rbp != null) {
                Map<String, Genotype> genotypes = pbt.getGenotypes();
                if (!rbp.isFiltered()) {
                    for (String sample : rbp.getSampleNames()) {
                        Genotype rbpg = rbp.getGenotype(sample);
                        Genotype pbtg = pbt.getGenotype(sample);
                        if (!pbtg.isPhased() && rbpg.isPhased() && this.rbpCache.containsKey(sample)) {
                            boolean orientationMatches = this.rbpCache.get(sample).sameGenotype(this.pbtCache.get(sample), false);
                            if (orientationMatches) {
                                pbtg = rbpg;
                            } else {
                                List<Allele> fwdAlleles = rbpg.getAlleles();
                                ArrayList<Allele> revAlleles = new ArrayList<Allele>();
                                for (int i = fwdAlleles.size() - 1; i >= 0; --i) {
                                    revAlleles.add(fwdAlleles.get(i));
                                }
                                pbtg = new Genotype(sample, revAlleles, rbpg.getNegLog10PError(), rbpg.getFilters(), rbpg.getAttributes(), rbpg.isPhased());
                            }
                        }
                        genotypes.put(sample, pbtg);
                        if (rbpg.isHet()) {
                            this.rbpCache.put(sample, rbpg);
                            this.pbtCache.put(sample, pbtg);
                            continue;
                        }
                        if (rbpg.isPhased()) continue;
                        this.rbpCache.remove(sample);
                        this.pbtCache.remove(sample);
                    }
                }
                VariantContext newvc = new VariantContext("MergeReadBackedAndTransmissionPhasedVariants", pbt.getChr(), (long)pbt.getStart(), (long)pbt.getStart(), pbt.getAlleles(), genotypes, pbt.getNegLog10PError(), pbt.getFilters(), pbt.getAttributes());
                this.vcfWriter.add(newvc);
            }
        }
        return null;
    }

    @Override
    public Integer reduceInit() {
        return null;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return null;
    }
}

